/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor.uranTypes;

import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.item.reactor.uranTypes.UranBaseType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.misc.StackUtil;
import java.awt.Color;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class NetherStarUranium
extends UranBaseType {
    public NetherStarUranium() {
        this.loadDefaults();
    }

    @Override
    public int getMaxDurability() {
        return 20000;
    }

    @Override
    public float getEUPerPulse() {
        return 5.0f;
    }

    @Override
    public int getPulsesPerTick() {
        return 2;
    }

    @Override
    public int getPulsesForConnection() {
        return 3;
    }

    @Override
    public float getHeatModifier() {
        return 1.2f;
    }

    @Override
    public float getExplosionEffectModifier() {
        return 2.0f;
    }

    @Override
    public ItemStack getUraniumIngot() {
        return Ic2Items.netherStarUraniumIngot.func_77946_l();
    }

    @Override
    public ItemStack getRodType(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return Ic2Items.reactorNetherStarUraniumRodSingle.func_77946_l();
            }
            case DualRod: {
                return Ic2Items.reactorNetherStarUraniumRodDual.func_77946_l();
            }
            case QuadRod: {
                return Ic2Items.reactorNetherStarUraniumRodQuad.func_77946_l();
            }
            case NearDepletedRod: {
                return Ic2Items.reactorNearDepletedNetherStarUraniumRod.func_77946_l();
            }
            case IsotopicRod: {
                return Ic2Items.reactorNetherStarUraniumIsotopicRod.func_77946_l();
            }
            case ReEnrichedRod: {
                return Ic2Items.reactorReEnrichedNetherStarUraniumRod.func_77946_l();
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getNewIsotopicRod() {
        return StackUtil.copyWithDamage(this.getRodType(IUranium.RodType.IsotopicRod), this.getMaxDurability() - 1);
    }

    @Override
    public short getRodID(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return 37;
            }
            case DualRod: {
                return 38;
            }
            case QuadRod: {
                return 39;
            }
            case IsotopicRod: {
                return 46;
            }
        }
        return 0;
    }

    @Override
    public LocaleComp getName(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return Ic2ItemLang.uranRodNetherStarSingle;
            }
            case DualRod: {
                return Ic2ItemLang.uranRodNetherStarDouble;
            }
            case QuadRod: {
                return Ic2ItemLang.uranRodNetherStarQuad;
            }
            case NearDepletedRod: {
                return Ic2ItemLang.uranRodNetherStarNearDeplete;
            }
            case IsotopicRod: {
                return Ic2ItemLang.uranRodNetherStarIsotopic;
            }
            case ReEnrichedRod: {
                return Ic2ItemLang.uranRodNetherStarReEnriched;
            }
        }
        return Ic2Lang.nullKey;
    }

    @Override
    public boolean isReEnrichedUran() {
        return true;
    }

    @Override
    public Color getReEnrichedColor() {
        return new Color(16772970);
    }

    @Override
    public ItemStack getIngridient() {
        return new ItemStack(Items.field_151156_bN);
    }

    @Override
    public int getIngrientPoints() {
        return 200;
    }

    @Override
    public int getRow() {
        return 4;
    }

    @Override
    public int getIngridientCost() {
        return 150;
    }
}

