/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tfbp;

import ic2.core.item.tfbp.ItemTFBPBase;
import ic2.core.item.tfbp.bp.BiomeBP;
import ic2.core.item.tfbp.bp.ChillingBP;
import ic2.core.item.tfbp.bp.CultivatedBP;
import ic2.core.item.tfbp.bp.DesertificationBP;
import ic2.core.item.tfbp.bp.FlatificationBP;
import ic2.core.item.tfbp.bp.IrrigationBP;
import ic2.core.item.tfbp.bp.MushroomBP;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.obj.IBootable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTFBP
extends ItemTFBPBase
implements IBootable {
    Map<Integer, ITerformLogic> logics = new HashMap<Integer, ITerformLogic>();

    public ItemTFBP() {
        this.setUnlocalizedName(Ic2ItemLang.tfbpBase);
        this.func_77627_a(true);
    }

    @Override
    public void onLoad() {
        this.logics.put(0, new MushroomBP());
        this.logics.put(1, new CultivatedBP());
        this.logics.put(2, new IrrigationBP());
        this.logics.put(3, new ChillingBP());
        this.logics.put(4, new DesertificationBP());
        this.logics.put(5, new FlatificationBP());
        this.logics.put(20, new BiomeBP(Biomes.field_76772_c, 129, Ic2ItemLang.tfbpBiomeCultivation, 4000, 40));
        this.logics.put(21, new BiomeBP(Biomes.field_76769_d, 130, Ic2ItemLang.tfbpBiomeDesertification, 2500, 40));
        this.logics.put(22, new BiomeBP(Biomes.field_76767_f, 131, Ic2ItemLang.tfbpBiomeForestification, 2000, 50));
        this.logics.put(23, new BiomeBP(Biomes.field_76780_h, 132, Ic2ItemLang.tfbpBiomeIrrigation, 5000, 30));
        this.logics.put(24, new BiomeBP(Biomes.field_76789_p, 133, Ic2ItemLang.tfbpBiomeMushroom, 8000, 25));
        this.logics.put(25, new BiomeBP(Biomes.field_76782_w, 134, Ic2ItemLang.tfbpBiomeUndergrowth, 5000, 30));
        this.logics.put(26, new BiomeBP(Biomes.field_76774_n, 135, Ic2ItemLang.tfbpBiomeChilling, 6000, 35));
        Ic2Items.tfbpMushroom = new ItemStack((Item)this, 1, 0);
        Ic2Items.tfbpCultivation = new ItemStack((Item)this, 1, 1);
        Ic2Items.tfbpChilling = new ItemStack((Item)this, 1, 2);
        Ic2Items.tfbpIrrigation = new ItemStack((Item)this, 1, 3);
        Ic2Items.tfbpDesertification = new ItemStack((Item)this, 1, 4);
        Ic2Items.tfbpFlatificator = new ItemStack((Item)this, 1, 5);
        Ic2Items.tfbpBiomeCultivation = new ItemStack((Item)this, 1, 20);
        Ic2Items.tfbpBiomeDesertification = new ItemStack((Item)this, 1, 21);
        Ic2Items.tfbpBiomeForestification = new ItemStack((Item)this, 1, 22);
        Ic2Items.tfbpBiomeIrrigation = new ItemStack((Item)this, 1, 23);
        Ic2Items.tfbpBiomeMushroom = new ItemStack((Item)this, 1, 24);
        Ic2Items.tfbpBiomeUndergrowth = new ItemStack((Item)this, 1, 25);
        Ic2Items.tfbpBiomeChilling = new ItemStack((Item)this, 1, 26);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        ITerformLogic logic;
        if (PlayerHandler.getClientPlayerHandler().hasEUReader() && (logic = this.logics.get(stack.func_77960_j())) != null) {
            logic.addEUReaderTooltip(stack, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, tooltip);
        }
    }

    public List<Integer> getSortedList() {
        ArrayList<Integer> list = new ArrayList<Integer>(this.logics.keySet());
        Collections.sort(list);
        return list;
    }

    @Override
    public List<Integer> getValidVariants() {
        return this.getSortedList();
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        ITerformLogic logic = this.logics.get(stack.func_77960_j());
        if (logic != null) {
            return logic.getName();
        }
        return super.getLangComponent(stack);
    }

    @Override
    public int getTextureEntry(int meta) {
        ITerformLogic logic = this.logics.get(meta);
        if (logic != null) {
            return logic.getIcon();
        }
        return 0;
    }

    @Override
    public double getConsume(ItemStack stack) {
        ITerformLogic logic = this.logics.get(stack.func_77960_j());
        if (logic != null) {
            return logic.getCost();
        }
        return 0.0;
    }

    @Override
    public int getRange(ItemStack stack) {
        ITerformLogic logic = this.logics.get(stack.func_77960_j());
        if (logic != null) {
            return logic.getRange();
        }
        return 0;
    }

    @Override
    public boolean canInsert(ItemStack stack, EntityPlayer player, World world, BlockPos pos) {
        ITerformLogic logic = this.logics.get(stack.func_77960_j());
        if (logic != null) {
            logic.onInsert(stack, player, world, pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean terraform(ItemStack stack, World world, BlockPos pos) {
        ITerformLogic logic = this.logics.get(stack.func_77960_j());
        if (logic != null) {
            return logic.terraform(stack, world, pos);
        }
        return false;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (Integer meta : this.getSortedList()) {
            items.add((Object)new ItemStack((Item)this, 1, meta.intValue()));
        }
    }

    @Override
    public boolean needsSortedLogic(ItemStack stack) {
        return this.logics.get(stack.func_77960_j()) instanceof BiomeBP;
    }

    public static interface ITerformLogic {
        public boolean terraform(ItemStack var1, World var2, BlockPos var3);

        public int getCost();

        public int getRange();

        public void onInsert(ItemStack var1, EntityPlayer var2, World var3, BlockPos var4);

        public LocaleComp getName();

        public int getIcon();

        public void addEUReaderTooltip(ItemStack var1, EntityPlayer var2, List<String> var3);
    }
}

