/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades;

import ic2.core.IC2;
import ic2.core.block.base.BlockMultiID;
import ic2.core.block.base.tile.TileEntityChargePadBase;
import ic2.core.block.wiring.tile.TileEntityElectricMFE;
import ic2.core.block.wiring.tile.TileEntityElectricMFSU;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.util.obj.IBootable;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemChargePadUpgrade
extends ItemIC2
implements IBootable {
    public ItemChargePadUpgrade() {
        this.func_77627_a(true);
        this.setUnlocalizedName(Ic2ItemLang.padUpgradeBase);
    }

    @Override
    public void onLoad() {
        Ic2Items.crystalUpgradeKid = new ItemStack((Item)this, 1, 0);
        Ic2Items.mfsuUpgradeKid = new ItemStack((Item)this, 1, 1);
        Ic2Items.lapotronicUpgradeKid = new ItemStack((Item)this, 1, 2);
        Ic2Items.fissionUpgradeKid = new ItemStack((Item)this, 1, 3);
        Ic2Items.padUpgradeDamage = new ItemStack((Item)this, 1, 4);
        Ic2Items.padUpgradeDrain = new ItemStack((Item)this, 1, 5);
        Ic2Items.padUpgradeProximity = new ItemStack((Item)this, 1, 6);
        Ic2Items.padUpgradeWideBand = new ItemStack((Item)this, 1, 7);
        Ic2Items.padUpgradeArmorPriorty = new ItemStack((Item)this, 1, 8);
        Ic2Items.padUpgradeBasicFieldUpgrade = new ItemStack((Item)this, 1, 9);
        Ic2Items.padUpgradeFieldUpgrade = new ItemStack((Item)this, 1, 10);
        Ic2Items.padUpgradeAdvFieldUpgrade = new ItemStack((Item)this, 1, 11);
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 144 + meta;
    }

    public TileEntityChargePadBase.PadUpgrade getUpgrade(ItemStack stack) {
        int meta = stack.func_77960_j();
        if (meta >= 4 && meta <= 11) {
            return TileEntityChargePadBase.PadUpgrade.values()[meta -= 4];
        }
        return null;
    }

    public TileEntityChargePadBase.ChargePadType getUpgradeType(int meta) {
        if (meta < 4) {
            switch (meta) {
                case 0: {
                    return TileEntityChargePadBase.ChargePadType.MV;
                }
                case 2: {
                    return TileEntityChargePadBase.ChargePadType.HV;
                }
                case 3: {
                    return TileEntityChargePadBase.ChargePadType.Nuclear;
                }
            }
        }
        return null;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int i = 0; i < 12; ++i) {
            items.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return Ic2ItemLang.upgradeKitCrystalizer;
            }
            case 1: {
                return Ic2ItemLang.upgradeKitmfsu;
            }
            case 2: {
                return Ic2ItemLang.upgradeKitLapotronic;
            }
            case 3: {
                return Ic2ItemLang.upgradeKitfission;
            }
            case 4: {
                return Ic2ItemLang.padUpgradeDamage;
            }
            case 5: {
                return Ic2ItemLang.padUpgradeDrain;
            }
            case 6: {
                return Ic2ItemLang.padUpgradeProximity;
            }
            case 7: {
                return Ic2ItemLang.padUpgradeWideBand;
            }
            case 8: {
                return Ic2ItemLang.padUpgradeArmor;
            }
            case 9: {
                return Ic2ItemLang.padUpgradefieldOne;
            }
            case 10: {
                return Ic2ItemLang.padUpgradefieldTwo;
            }
            case 11: {
                return Ic2ItemLang.padUpgradefieldThree;
            }
        }
        return super.getLangComponent(stack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        TileEntityChargePadBase.PadUpgrade upgrade = this.getUpgrade(stack);
        if (upgrade != null) {
            return upgrade.isRare ? EnumRarity.UNCOMMON : EnumRarity.COMMON;
        }
        int meta = stack.func_77952_i();
        if (meta == 2 || meta == 3 || meta == 1) {
            return EnumRarity.UNCOMMON;
        }
        return super.func_77613_e(stack);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity tile;
        ItemStack stack = player.func_184586_b(hand);
        int meta = stack.func_77960_j();
        if (meta < 4 && meta != 1) {
            TileEntity tile2 = world.func_175625_s(pos);
            if (tile2 instanceof TileEntityChargePadBase) {
                TileEntity newTile;
                TileEntityChargePadBase pad = (TileEntityChargePadBase)tile2;
                TileEntityChargePadBase.ChargePadType upgrade = pad.type.upgrade();
                if (upgrade == null || upgrade != this.getUpgradeType(meta) || world.field_72995_K) {
                    return EnumActionResult.PASS;
                }
                if (!IC2.config.getFlag("ChargePadUpgradeAnySide") && side != EnumFacing.DOWN) {
                    IC2.platform.messagePlayer(player, Ic2InfoLang.chargePadWrongSide);
                    return EnumActionResult.FAIL;
                }
                if (world.func_175656_a(pos, Ic2States.chargePadLV.func_177226_a((IProperty)BlockMultiID.metadata, (Comparable)Integer.valueOf(upgrade.ordinal()))) && (newTile = world.func_175625_s(pos)) instanceof TileEntityChargePadBase) {
                    TileEntityChargePadBase newPad = (TileEntityChargePadBase)newTile;
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    newPad.upgrade(pad);
                    world.func_175704_b(pos, pos);
                    world.func_190524_a(pos, Ic2States.chargePadLV.func_177230_c(), pos);
                    return EnumActionResult.SUCCESS;
                }
            }
        } else if (meta == 1 && (tile = world.func_175625_s(pos)) instanceof TileEntityElectricMFE) {
            TileEntity newTile;
            TileEntityElectricMFE mfe = (TileEntityElectricMFE)tile;
            if (world.field_72995_K) {
                return EnumActionResult.PASS;
            }
            if (world.func_175656_a(pos, Ic2States.mfsu) && (newTile = world.func_175625_s(pos)) instanceof TileEntityElectricMFSU) {
                TileEntityElectricMFSU mfsu = (TileEntityElectricMFSU)newTile;
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                mfsu.inventory = mfe.inventory;
                mfsu.setStored(mfe.energy);
                mfsu.setFacingWithoutNotify(mfe.getFacing());
                world.func_175704_b(pos, pos);
                world.func_190524_a(pos, Ic2States.chargePadLV.func_177230_c(), pos);
                return EnumActionResult.SUCCESS;
            }
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }
}

