/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util.misc;

import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;

public class FluidHelper {
    public static boolean drainContainers(IFluidHandler fluidHandler, IHasInventory inv, int inputSlot) {
        ItemStack input = inv.getStackInSlot(inputSlot);
        if (input.func_190926_b() || input.func_77973_b().hasContainerItem(input) && input.func_190916_E() > 1) {
            return false;
        }
        FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)input, (IFluidHandler)fluidHandler, (int)1000, null, (boolean)false);
        if (!result.isSuccess()) {
            return false;
        }
        result = FluidUtil.tryEmptyContainer((ItemStack)input, (IFluidHandler)fluidHandler, (int)1000, null, (boolean)true);
        if (!result.isSuccess()) {
            return false;
        }
        input.func_190918_g(1);
        ItemStack drainedItem = result.getResult();
        if (!drainedItem.func_190926_b() && (inv.getStackInSlot(inputSlot).func_190926_b() || StackUtil.isStackEqual(drainedItem, inv.getStackInSlot(inputSlot), false, false))) {
            inv.setStackInSlot(inputSlot, drainedItem);
        }
        return true;
    }

    public static boolean drainContainers(IFluidHandler fluidHandler, IHasInventory inv, int inputSlot, IHasInventory outputInv) {
        ItemStack added;
        ItemStack container;
        ItemStack added2;
        ItemStack input = inv.getStackInSlot(inputSlot);
        IItemTransporter trans = TransporterManager.manager.getTransporter(outputInv, true);
        if (input.func_190926_b() || trans == null) {
            return false;
        }
        ItemStack drainedItemSimulated = FluidUtil.tryEmptyContainer((ItemStack)input, (IFluidHandler)fluidHandler, (int)1000, null, (boolean)false).getResult();
        if (StackUtil.isStackEqual(input, drainedItemSimulated)) {
            return false;
        }
        if (drainedItemSimulated.func_190916_E() != 0 && (added2 = trans.addItem(drainedItemSimulated, null, false)).func_190926_b()) {
            return false;
        }
        if (input.func_190916_E() == 1 && !(container = input.func_77973_b().getContainerItem(input)).func_190926_b() && (added = trans.addItem(container, null, false)).func_190926_b()) {
            return false;
        }
        FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)input, (IFluidHandler)fluidHandler, (int)1000, null, (boolean)true);
        if (!result.isSuccess()) {
            return false;
        }
        ItemStack drainedItem = result.getResult();
        if (!drainedItem.func_190926_b()) {
            input.func_190918_g(1);
            trans.addItem(drainedItem, null, true);
        } else {
            input.func_190918_g(1);
        }
        return true;
    }

    public static boolean hasRoomLeft(ItemStack stack) {
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)stack);
        if (handler != null) {
            IFluidTankProperties[] array = handler.getTankProperties();
            for (int i = 0; i < array.length; ++i) {
                IFluidTankProperties prop = array[i];
                FluidStack fluid = prop.getContents();
                int lvl = prop.getCapacity();
                if (lvl <= 0 || !prop.canFill() || fluid != null && lvl <= fluid.amount) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasFluid(IFluidHandler handler, FluidStack search, boolean requiredAmount) {
        if (handler == null || search == null) {
            return false;
        }
        IFluidTankProperties[] array = handler.getTankProperties();
        for (int i = 0; i < array.length; ++i) {
            IFluidTankProperties entry = array[i];
            FluidStack tankEntry = entry.getContents();
            if (!search.isFluidEqual(tankEntry) || !entry.canDrainFluidType(tankEntry) || requiredAmount && tankEntry.amount < search.amount) continue;
            return true;
        }
        return false;
    }

    public static boolean canFillContainer(ItemStack stack, FluidStack fluidToFill, boolean allowPartical) {
        return FluidHelper.fillContainer(stack.func_77946_l(), fluidToFill.copy(), false, allowPartical, false) != null;
    }

    public static ItemStack fillContainer(ItemStack stack, FluidStack fluidToFill, boolean doFill, boolean allowPartical, boolean drainFluid) {
        if (fluidToFill == null || stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack filled = stack.func_77946_l();
        filled.func_190920_e(1);
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)filled);
        if (handler == null || !FluidHelper.canFillFluidToHandler((IFluidHandler)handler, fluidToFill)) {
            return ItemStack.field_190927_a;
        }
        int added = handler.fill(fluidToFill, false);
        if (added <= 0 || !allowPartical && added < fluidToFill.amount) {
            return ItemStack.field_190927_a;
        }
        added = handler.fill(fluidToFill, doFill);
        if (drainFluid) {
            fluidToFill.amount -= added;
        }
        return handler.getContainer().func_77946_l();
    }

    public static Tuple<ItemStack, FluidStack> fillContainer(ItemStack stack, FluidStack fluidToFill, boolean doFill, boolean allowPartical) {
        if (fluidToFill == null || stack.func_190926_b()) {
            return null;
        }
        ItemStack filled = stack.func_77946_l();
        filled.func_190920_e(1);
        FluidStack fluidCopy = fluidToFill.copy();
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)filled);
        if (handler == null || !FluidHelper.canFillFluidToHandler((IFluidHandler)handler, fluidCopy)) {
            return null;
        }
        int added = handler.fill(fluidCopy, false);
        if (added <= 0 || !allowPartical && added < fluidCopy.amount) {
            return null;
        }
        added = handler.fill(fluidCopy, doFill);
        return new Tuple((Object)handler.getContainer().func_77946_l(), (Object)FluidHelper.copyWithSize(fluidCopy, added));
    }

    public static boolean canFillFluidToHandler(IFluidHandler handler, FluidStack fluid) {
        IFluidTankProperties[] props = handler.getTankProperties();
        for (int i = 0; i < props.length; ++i) {
            IFluidTankProperties prop = props[i];
            if (!prop.canFillFluidType(fluid)) continue;
            return true;
        }
        return false;
    }

    public static IFluidHandler getFluidHandler(TileEntity tile, EnumFacing side) {
        if (tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
            return (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
        }
        return null;
    }

    public static FluidStack copyFluid(FluidStack fluid) {
        return fluid == null ? null : fluid.copy();
    }

    public static FluidStack copyWithSize(FluidStack entry, int newAmount) {
        FluidStack fluid = entry.copy();
        fluid.amount = newAmount;
        return fluid;
    }

    public static IFluidHandler getBlockHandler(IBlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (block instanceof IFluidBlock) {
            return new FluidBlockWrapper((IFluidBlock)block, world, pos);
        }
        if (block instanceof BlockLiquid) {
            return new BlockLiquidWrapper((BlockLiquid)block, world, pos);
        }
        return null;
    }

    public static List<FluidStack> copyFluids(List<FluidStack> fluids) {
        ArrayList<FluidStack> list = new ArrayList<FluidStack>(fluids.size());
        for (FluidStack stack : fluids) {
            list.add(stack.copy());
        }
        return list;
    }
}

