/*
 * Decompiled with CFR 0.152.
 */
package br.net.fabiozumbi12.RankUpper;

import br.net.fabiozumbi12.RankUpper.RUUtil;
import br.net.fabiozumbi12.RankUpper.RankUpper;
import br.net.fabiozumbi12.RankUpper.config.RankedGroupsCategory;
import br.net.fabiozumbi12.RankUpper.config.StatsCategory;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.rojo8399.placeholderapi.PlaceholderService;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.statistic.Statistic;
import org.spongepowered.api.text.Text;

public class RUCommands {
    private static RankUpper plugin;

    public static void init(RankUpper pl) {
        plugin = pl;
        Sponge.getCommandManager().register((Object)plugin, RUCommands.rankUpper(), new String[]{"rankupper", "ru"});
    }

    private static CommandCallable rankUpper() {
        CommandSpec addgroup = CommandSpec.builder().description((Text)Text.of((String)"Add groups to config.")).permission("rankupper.addgroup").arguments(new CommandElement[]{GenericArguments.string((Text)Text.of((String)"group")), GenericArguments.string((Text)Text.of((String)"next-group")), GenericArguments.integer((Text)Text.of((String)"minutes")), GenericArguments.integer((Text)Text.of((String)"levels")), GenericArguments.integer((Text)Text.of((String)"money"))}).executor((src, args) -> {
            int time = (Integer)args.getOne("minutes").get();
            int levels = (Integer)args.getOne("levels").get();
            int money = (Integer)args.getOne("money").get();
            String group = (String)args.getOne("group").get();
            String newGroup = (String)args.getOne("next-group").get();
            if (RankUpper.get().getConfig().addGroup(group, newGroup, time, levels, money)) {
                RankUpper.get().getLang().sendMessage(src, RankUpper.get().getLang().get("config.addedgroup"));
            } else {
                RankUpper.get().getLang().sendMessage(src, RankUpper.get().getLang().get("config.notaddedgroup"));
            }
            return CommandResult.success();
        }).build();
        CommandSpec setgroup = CommandSpec.builder().description((Text)Text.of((String)"Edit groups on config.")).permission("rankupper.setgroup").arguments(new CommandElement[]{GenericArguments.string((Text)Text.of((String)"group")), GenericArguments.string((Text)Text.of((String)"next-group")), GenericArguments.integer((Text)Text.of((String)"minutes")), GenericArguments.integer((Text)Text.of((String)"levels")), GenericArguments.integer((Text)Text.of((String)"money"))}).executor((src, args) -> {
            int time = (Integer)args.getOne("minutes").get();
            int levels = (Integer)args.getOne("levels").get();
            int money = (Integer)args.getOne("money").get();
            String group = (String)args.getOne("group").get();
            String newGroup = (String)args.getOne("next-group").get();
            if (RankUpper.get().getConfig().setGroup(group, newGroup, time, levels, money).booleanValue()) {
                RankUpper.get().getLang().sendMessage(src, RankUpper.get().getLang().get("config.setgroup"));
            } else {
                RankUpper.get().getLang().sendMessage(src, RankUpper.get().getLang().get("config.notsetgroup"));
            }
            return CommandResult.success();
        }).build();
        CommandSpec set = CommandSpec.builder().description((Text)Text.of((String)"Set time played by player.")).permission("rankupper.set").arguments(new CommandElement[]{GenericArguments.user((Text)Text.of((String)"player")), GenericArguments.integer((Text)Text.of((String)"minutes"))}).executor((src, args) -> {
            int time = (Integer)args.getOne("minutes").get();
            RankUpper.get().getStats().setPlayerTime(RankUpper.get().getStats().getPlayerKey((User)args.getOne("player").get()), time);
            RankUpper.get().getLang().sendMessage(src, RankUpper.get().getLang().get("commands.setto").replace("{time}", RUUtil.timeDescript(time)).replace("{player}", ((User)args.getOne("player").get()).getName()));
            return CommandResult.success();
        }).build();
        CommandSpec add = CommandSpec.builder().description((Text)Text.of((String)"Add time played by player.")).permission("rankupper.add").arguments(new CommandElement[]{GenericArguments.user((Text)Text.of((String)"player")), GenericArguments.integer((Text)Text.of((String)"minutes"))}).executor((src, args) -> {
            int time = (Integer)args.getOne("minutes").get();
            RankUpper.get().getLang().sendMessage(src, RankUpper.get().getLang().get("commands.added").replace("{time}", RUUtil.timeDescript(RankUpper.get().getStats().addPlayerTime((User)args.getOne("player").get(), time))).replace("{player}", ((User)args.getOne("player").get()).getName()));
            return CommandResult.success();
        }).build();
        CommandSpec check = CommandSpec.builder().description((Text)Text.of((String)"Check if requirements is done to rankup.")).permission("rankupper.check").arguments(GenericArguments.optional((CommandElement)GenericArguments.user((Text)Text.of((String)"player")))).executor((src, args) -> {
            if (args.hasAny("player") && src.hasPermission("rankupper.check-others")) {
                if (RankUpper.get().getConfig().root().check_rankup && RankUpper.get().getConfig().checkRankup((User)args.getOne("player").get())) {
                    return CommandResult.success();
                }
                RUCommands.SendCheckMessage(src, (User)args.getOne("player").get());
            } else if (src instanceof Player) {
                if (RankUpper.get().getConfig().root().check_rankup && RankUpper.get().getConfig().checkRankup((User)((Player)src))) {
                    return CommandResult.success();
                }
                RUCommands.SendCheckMessage(src, (User)((Player)src));
            }
            return CommandResult.success();
        }).build();
        CommandSpec rankup = CommandSpec.builder().description((Text)Text.of((String)"If requirements is done, rankup.")).permission("rankupper.rankup").arguments(GenericArguments.optional((CommandElement)GenericArguments.user((Text)Text.of((String)"player")))).executor((src, args) -> {
            if (args.hasAny("player") && src.hasPermission("rankupper.rankup-others")) {
                if (RankUpper.get().getConfig().checkRankup((User)args.getOne("player").get())) {
                    return CommandResult.success();
                }
                RUCommands.SendCheckMessage(src, (User)args.getOne("player").get());
            } else if (src instanceof Player) {
                if (RankUpper.get().getConfig().checkRankup((User)((Player)src))) {
                    return CommandResult.success();
                }
                RUCommands.SendCheckMessage(src, (User)((Player)src));
            }
            return CommandResult.success();
        }).build();
        CommandSpec playerInfo = CommandSpec.builder().description((Text)Text.of((String)"See player infos.")).permission("rankupper.player-info").arguments(GenericArguments.user((Text)Text.of((String)"player"))).executor((src, args) -> {
            HashMap<String, Object> pdb = RankUpper.get().getStats().getPlayerDB((User)args.getOne("player").get());
            if (!pdb.isEmpty()) {
                RankUpper.get().getLang().sendMessage(src, "Player Info:");
                src.sendMessage(RUUtil.toText("&3- Nick: &b" + pdb.get("PlayerName")));
                src.sendMessage(RUUtil.toText("&3- Joind Date: &b" + pdb.get("JoinDate")));
                src.sendMessage(RUUtil.toText("&3- Last Visit: &b" + pdb.get("LastVisit")));
                src.sendMessage(RUUtil.toText("&3- Time Played: &b" + RUUtil.timeDescript((Integer)pdb.get("TimePlayed"))));
                return CommandResult.success();
            }
            throw new CommandException(RUUtil.toText(RankUpper.get().getLang().get("commands.unknownplayer").replace("{player}", ((User)args.getOne("player").get()).getName())), true);
        }).build();
        CommandSpec top = CommandSpec.builder().description((Text)Text.of((String)"Check the top played times.")).permission("rankupper.top").executor((src, args) -> {
            RUCommands.ExecuteTopCount(src);
            return CommandResult.success();
        }).build();
        CommandSpec help = CommandSpec.builder().description((Text)Text.of((String)"Help command for rankupper.")).executor((src, args) -> {
            RUCommands.sendHelp(src);
            return CommandResult.success();
        }).build();
        CommandSpec reload = CommandSpec.builder().description((Text)Text.of((String)"Reload rankupper.")).permission("rankupper.reload").executor((src, args) -> {
            plugin.reload();
            RankUpper.get().getLang().sendMessage(src, "&aRankUpper reloaded!");
            return CommandResult.success();
        }).build();
        CommandSpec saveAll = CommandSpec.builder().description((Text)Text.of((String)"Force save rankuppper stats.")).permission("rankupper.save-all").executor((src, args) -> {
            RankUpper.get().getStats().savePlayersStats();
            RankUpper.get().getLang().sendMessage(src, "&aPlayer stats Saved!");
            return CommandResult.success();
        }).build();
        CommandSpec loadAll = CommandSpec.builder().description((Text)Text.of((String)"Force load rankuppper stats.")).permission("rankupper.load-all").executor((src, args) -> {
            RankUpper.get().getStats().loadPlayerStats();
            RankUpper.get().getLang().sendMessage(src, "&aPlayer stats Loaded!");
            return CommandResult.success();
        }).build();
        CommandSpec listGroups = CommandSpec.builder().description((Text)Text.of((String)"List all groups from on config.")).permission("rankupper.list-groups").executor((src, args) -> {
            Map<String, RankedGroupsCategory> groups = RankUpper.get().getConfig().root().ranked_groups;
            src.sendMessage(RUUtil.toText("&b--------------- RankUpper Groups ---------------"));
            groups.keySet().forEach(key -> {
                src.sendMessage(RUUtil.toText("&7Group: &a" + key));
                try {
                    src.sendMessage(RUUtil.toText("&7Commands: "));
                    ((RankedGroupsCategory)groups.get((Object)key)).execute_commands.forEach(cmd -> src.sendMessage(RUUtil.toText("&a-- &b" + cmd)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                src.sendMessage(RUUtil.toText("&7Minutes: &a" + ((RankedGroupsCategory)groups.get((Object)key)).minutes_needed + " (" + RUUtil.timeDescript(((RankedGroupsCategory)groups.get((Object)key)).minutes_needed) + ")"));
                src.sendMessage(RUUtil.toText("&7Levels: &a" + ((RankedGroupsCategory)groups.get((Object)key)).levels_needed));
                src.sendMessage(RUUtil.toText("&7Money: &a" + ((RankedGroupsCategory)groups.get((Object)key)).money_needed));
                src.sendMessage(RUUtil.toText("&7Next Group: &a" + ((RankedGroupsCategory)groups.get((Object)key)).next_group));
                src.sendMessage(RUUtil.toText("&7Message: &a" + ((RankedGroupsCategory)groups.get((Object)key)).message_broadcast));
                src.sendMessage(RUUtil.toText("&b---------------------------------------------"));
            });
            return CommandResult.success();
        }).build();
        CommandSpec backup = CommandSpec.builder().description((Text)Text.of((String)"Mak a backup of player stats to file.")).permission("rankupper.backup").executor((src, args) -> {
            try {
                File statsConf = new File(RankUpper.get().getConfigDir(), "playerstats.conf");
                HoconConfigurationLoader statsManager = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(statsConf)).build();
                CommentedConfigurationNode tempStats = (CommentedConfigurationNode)statsManager.load();
                RankUpper.get().getStats().stats().players.forEach((key, value) -> {
                    String pKey = key;
                    if (pKey == null || pKey.isEmpty()) {
                        pKey = Sponge.getServer().getPlayer(value.PlayerName).isPresent() ? ((Player)Sponge.getServer().getPlayer(value.PlayerName).get()).getUniqueId().toString() : value.PlayerName;
                    }
                    CommentedConfigurationNode pNode = tempStats.getNode(new Object[]{pKey});
                    pNode.getNode(new Object[]{"JoinDate"}).setValue((Object)value.JoinDate);
                    pNode.getNode(new Object[]{"LastVisist"}).setValue((Object)value.LastVisit);
                    pNode.getNode(new Object[]{"PlayerName"}).setValue((Object)value.PlayerName);
                    pNode.getNode(new Object[]{"TimePlayed"}).setValue((Object)value.TimePlayed);
                });
                statsManager.save((ConfigurationNode)tempStats);
                RankUpper.get().getLang().sendMessage(src, "&aBackup saved to playerstats.conf\n&eThis backup will be loaded on next server start or on ru reload!");
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return CommandResult.success();
        }).build();
        return CommandSpec.builder().description((Text)Text.of((String)"Main command for rankupper.")).executor((src, args) -> {
            src.sendMessage(RUUtil.toText("&b---------------- " + RankUpper.get().instance().getName() + " " + (String)RankUpper.get().instance().getVersion().get() + " ---------------"));
            src.sendMessage(RUUtil.toText("&bDeveloped by &6" + (String)RankUpper.get().instance().getAuthors().get(0) + "."));
            src.sendMessage(RUUtil.toText("&bFor more information about the commands, type [&6/ru ?&b]."));
            src.sendMessage(RUUtil.toText("&b---------------------------------------------------"));
            return CommandResult.success();
        }).child((CommandCallable)help, new String[]{"?", "help"}).child((CommandCallable)reload, new String[]{"reload", "rl"}).child((CommandCallable)addgroup, new String[]{"addgroup"}).child((CommandCallable)setgroup, new String[]{"setgroup"}).child((CommandCallable)add, new String[]{"add"}).child((CommandCallable)set, new String[]{"set"}).child((CommandCallable)check, new String[]{"check"}).child((CommandCallable)rankup, new String[]{"rankup", "up"}).child((CommandCallable)top, new String[]{"top"}).child((CommandCallable)playerInfo, new String[]{"player-info"}).child((CommandCallable)saveAll, new String[]{"save-all"}).child((CommandCallable)loadAll, new String[]{"load-all"}).child((CommandCallable)listGroups, new String[]{"list-groups"}).child((CommandCallable)backup, new String[]{"backup"}).build();
    }

    private static void ExecuteTopCount(CommandSource p) {
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        for (StatsCategory.PlayerInfoCategory key : RankUpper.get().getStats().stats().players.values()) {
            String play = key.PlayerName;
            if (key.TimePlayed <= 0) continue;
            stats.put(play, key.TimePlayed);
        }
        int top10 = 0;
        Map<String, Integer> Sorted = RUUtil.sort(stats);
        RankUpper.get().getLang().sendMessage(p, "commands.top10");
        for (String plr : Sorted.keySet()) {
            int time = Sorted.get(plr);
            String color = "&2";
            if (++top10 == 1) {
                color = "&e&l";
            }
            if (top10 == 2) {
                color = "&7&l";
            }
            if (top10 == 3) {
                color = "&6&l";
            }
            if (top10 == 10) {
                color = "&c";
            }
            p.sendMessage(RUUtil.toText("&3" + top10 + ". " + color + plr + ": &a" + RUUtil.timeDescript(time)));
            if (top10 != 10) continue;
            break;
        }
    }

    private static void SendCheckMessage(CommandSource sender, User playerToCheck) {
        Optional phapiOpt;
        long actual;
        String ngroup;
        int time = RankUpper.get().getStats().getPlayerTime(RankUpper.get().getStats().getPlayerKey(playerToCheck));
        Subject subG = RankUpper.get().getPerms().getHighestGroup(playerToCheck);
        String pgroup = "";
        String dispName = "";
        if (subG != null) {
            pgroup = subG.getIdentifier();
            dispName = subG.getOption("display_name").isPresent() ? (String)subG.getOption("display_name").get() : pgroup;
        }
        RankUpper.get().getLogger().debug("Player Groups: " + pgroup);
        if (pgroup.isEmpty()) {
            RankUpper.get().getLang().sendMessage(sender, RankUpper.get().getLang().get("commands.check.youplayed").replace("{time}", RUUtil.timeDescript(time)).replace("{group}", "none"));
        } else {
            RankUpper.get().getLang().sendMessage(sender, RankUpper.get().getLang().get("commands.check.youplayed").replace("{time}", RUUtil.timeDescript(time)).replace("{group}", dispName));
        }
        String string = ngroup = RankUpper.get().getConfig().root().ranked_groups.get(pgroup) != null ? RankUpper.get().getConfig().root().ranked_groups.get((Object)pgroup).next_group : null;
        if (ngroup == null || ngroup.isEmpty() || !RankUpper.get().getPerms().getAllGroups().contains(ngroup)) {
            return;
        }
        sender.sendMessage(RUUtil.toText(RankUpper.get().getLang().get("commands.nextgroup").replace("{group}", ngroup)));
        int minutesNeeded = RankUpper.get().getConfig().root().ranked_groups.get((Object)pgroup).minutes_needed;
        int moneyNeeded = RankUpper.get().getConfig().root().ranked_groups.get((Object)pgroup).money_needed;
        int levelNeeded = RankUpper.get().getConfig().root().ranked_groups.get((Object)pgroup).levels_needed;
        if (minutesNeeded > 0) {
            if (RankUpper.get().getStats().getPlayerTime(RankUpper.get().getStats().getPlayerKey(playerToCheck)) >= minutesNeeded) {
                sender.sendMessage(RUUtil.toText(RankUpper.get().getLang().get("config.time") + ": &a" + RUUtil.timeDescript(minutesNeeded) + " - " + RankUpper.get().getLang().get("config.ok")));
            } else {
                sender.sendMessage(RUUtil.toText(RankUpper.get().getLang().get("config.time") + ": &c" + RUUtil.timeDescript(minutesNeeded)));
            }
        }
        if (moneyNeeded > 0 && RankUpper.get().getEconomy() != null) {
            UniqueAccount acc = (UniqueAccount)RankUpper.get().getEconomy().getOrCreateAccount(playerToCheck.getUniqueId()).get();
            double userMoney = acc.getBalance(RankUpper.get().getEconomy().getDefaultCurrency()).doubleValue();
            String userMoneyStr = String.format("%.2f", userMoney);
            if (userMoney >= (double)moneyNeeded) {
                sender.sendMessage(RUUtil.toText(RankUpper.get().getLang().get("config.money") + ": &a" + RankUpper.get().getLang().get("config.cifra") + " " + userMoneyStr + "/" + moneyNeeded + " - " + RankUpper.get().getLang().get("config.ok")));
            } else {
                sender.sendMessage(RUUtil.toText(RankUpper.get().getLang().get("config.money") + ": &c" + RankUpper.get().getLang().get("config.cifra") + " " + userMoneyStr + "/" + moneyNeeded));
            }
        }
        if (levelNeeded > 0) {
            if (!playerToCheck.get(Keys.EXPERIENCE_LEVEL).isPresent()) {
                sender.sendMessage(RUUtil.toText(RankUpper.get().getLang().get("config.levels") + ": &c0/" + levelNeeded + " Lvs."));
                return;
            }
            int lvls = (Integer)playerToCheck.get(Keys.EXPERIENCE_LEVEL).get();
            if (lvls >= levelNeeded) {
                sender.sendMessage(RUUtil.toText(RankUpper.get().getLang().get("config.levels") + ": &a" + lvls + "/" + levelNeeded + " Lvs. - " + RankUpper.get().getLang().get("config.ok")));
            } else {
                sender.sendMessage(RUUtil.toText(RankUpper.get().getLang().get("config.levels") + ": &c" + lvls + "/" + levelNeeded + " Lvs."));
            }
        }
        for (Map.Entry<String, Long> key : RankUpper.get().getConfig().root().ranked_groups.get((Object)pgroup).minecraft_statistic.entrySet()) {
            if (key.getValue() <= 0L || !Sponge.getRegistry().getType(Statistic.class, key.getKey()).isPresent()) continue;
            Statistic stat = (Statistic)Sponge.getRegistry().getType(Statistic.class, key.getKey()).get();
            long needed = key.getValue();
            long l = actual = playerToCheck.getStatisticData().get((Object)stat).isPresent() ? (Long)playerToCheck.getStatisticData().get((Object)stat).get() : 0L;
            if (actual >= needed) {
                sender.sendMessage(RUUtil.toText(RankUpper.get().getLang().get("config.statistics").replace("{statistic}", stat.getName()) + ": &a" + actual + "/" + needed + " - " + RankUpper.get().getLang().get("config.ok")));
                continue;
            }
            sender.sendMessage(RUUtil.toText(RankUpper.get().getLang().get("config.statistics").replace("{statistic}", stat.getName()) + ": &c" + actual + "/" + needed));
        }
        if (Sponge.getServer().getServerScoreboard().isPresent()) {
            for (Map.Entry<String, Long> key : RankUpper.get().getConfig().root().ranked_groups.get((Object)pgroup).minecraft_scoreboards.entrySet()) {
                if (key.getValue() <= 0L || ((Scoreboard)Sponge.getServer().getServerScoreboard().get()).getScores((Text)Text.of((String)key.getKey())).isEmpty()) continue;
                Score score = (Score)((Scoreboard)Sponge.getServer().getServerScoreboard().get()).getScores((Text)Text.of((String)key.getKey())).stream().findFirst().get();
                long needed = key.getValue();
                actual = score.getScore();
                if (actual >= needed) {
                    sender.sendMessage(RUUtil.toText(RankUpper.get().getLang().get("config.scoreboards").replace("{score}", score.getName().toPlain()) + ": &a" + actual + "/" + needed + " - " + RankUpper.get().getLang().get("config.ok")));
                    continue;
                }
                sender.sendMessage(RUUtil.toText(RankUpper.get().getLang().get("config.scoreboards").replace("{score}", score.getName().toPlain()) + ": &c" + actual + "/" + needed));
            }
        }
        if (Sponge.getPluginManager().getPlugin("placeholderapi").isPresent() && (phapiOpt = Sponge.getServiceManager().provide(PlaceholderService.class)).isPresent()) {
            PlaceholderService phapi = (PlaceholderService)phapiOpt.get();
            for (Map.Entry<String, Long> key : RankUpper.get().getConfig().root().ranked_groups.get((Object)pgroup).placeholder_api_requirements.entrySet()) {
                Optional optVal = phapi.parse(key.getKey(), playerToCheck.getPlayer().isPresent() ? playerToCheck.getPlayer().get() : playerToCheck, null, Long.class);
                if (!optVal.isPresent() || !((PlaceholderService)phapiOpt.get()).isRegistered(key.getKey())) continue;
                long needed = key.getValue();
                long actual2 = (Long)optVal.get();
                if (actual2 >= key.getValue()) {
                    sender.sendMessage(RUUtil.toText(RankUpper.get().getLang().get("config.placeholderapi").replace("{placeholder}", key.getKey().replace("%", "")) + ": &a" + actual2 + "/" + needed + " - " + RankUpper.get().getLang().get("config.ok")));
                    continue;
                }
                sender.sendMessage(RUUtil.toText(RankUpper.get().getLang().get("config.placeholderapi").replace("{placeholder}", key.getKey().replace("%", "")) + ": &c" + actual2 + "/" + needed));
            }
        }
    }

    private static void sendHelp(CommandSource source) {
        RankUpper.get().getLang().sendMessage(source, RankUpper.get().getLang().get("commands.commandshelp"));
        for (String key : RankUpper.get().getLang().helpStrings()) {
            if (source.hasPermission("rankupper." + key)) {
                source.sendMessage(RUUtil.toText(RankUpper.get().getLang().get("commands.help." + key)));
                continue;
            }
            if (!source.hasPermission("rankupper." + key + ".others")) continue;
            source.sendMessage(RUUtil.toText(RankUpper.get().getLang().get("commands.help." + key + ".others")));
        }
    }
}

