/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.worldrebuilder.commands;

import io.github.aquerr.worldrebuilder.WorldRebuilder;
import io.github.aquerr.worldrebuilder.commands.WRCommand;
import io.github.aquerr.worldrebuilder.entity.Region;
import java.util.LinkedList;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.World;

public class InfoCommand
extends WRCommand {
    public InfoCommand(WorldRebuilder plugin) {
        super(plugin);
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        Region region = (Region)args.requireOne((Text)Text.of((String)"region"));
        LinkedList<Text> helpList = new LinkedList<Text>();
        String worldName = "Not Found";
        Optional optionalWorld = Sponge.getServer().getWorld(region.getWorldUniqueId());
        if (optionalWorld.isPresent()) {
            worldName = ((World)optionalWorld.get()).getName();
        }
        Text.Builder textBuilder = Text.builder();
        textBuilder.append(new Text[]{Text.of((Object[])new Object[]{TextColors.BLUE, " - Name: ", TextColors.GOLD, region.getName(), "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.BLUE, " - World Name: ", TextColors.GOLD, worldName, "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.BLUE, " - First Point: ", TextColors.GOLD, region.getFirstPoint(), "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.BLUE, " - Second Point: ", TextColors.GOLD, region.getSecondPoint(), "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.BLUE, " - Restore Time: ", TextColors.GOLD, region.getRestoreTime(), "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.BLUE, " - Active: ", region.isActive() ? TextColors.GREEN : TextColors.RED, region.isActive()})});
        helpList.add(textBuilder.build());
        PaginationList paginationList = PaginationList.builder().title(Text.of((Object[])new Object[]{TextColors.GOLD, "Region Info"})).contents(helpList).linesPerPage(14).padding(Text.of((Object[])new Object[]{TextColors.BLUE, "-"})).build();
        paginationList.sendTo((MessageReceiver)src);
        return CommandResult.success();
    }
}

