/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.worldrebuilder.listener;

import io.github.aquerr.worldrebuilder.WorldRebuilder;
import io.github.aquerr.worldrebuilder.entity.Region;
import io.github.aquerr.worldrebuilder.listener.AbstractListener;
import io.github.aquerr.worldrebuilder.scheduling.RebuildEntityTask;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.hanging.Hanging;
import org.spongepowered.api.entity.living.ArmorStand;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.api.world.Location;

public class EntityDestroyListener
extends AbstractListener {
    public EntityDestroyListener(WorldRebuilder plugin) {
        super(plugin);
    }

    @Listener
    public void onEntityAttacked(AttackEntityEvent event) {
        Entity entity = event.getTargetEntity();
        if (!(entity instanceof Hanging) && !(entity instanceof ArmorStand)) {
            return;
        }
        CompletableFuture.runAsync(() -> this.tryRebuildEntity(entity.getWorld().getUniqueId(), event.getTargetEntity().createSnapshot()));
    }

    private void tryRebuildEntity(UUID worldUUID, EntitySnapshot entity) {
        Optional optionalLocation = entity.getLocation();
        if (!optionalLocation.isPresent()) {
            return;
        }
        Location location = (Location)optionalLocation.get();
        Collection<Region> regions = super.getPlugin().getRegionManager().getRegions();
        Region affectedRegion = null;
        for (Region region : regions) {
            if (!region.isActive() || !region.intersects(worldUUID, location.getBlockPosition())) continue;
            affectedRegion = region;
            break;
        }
        if (affectedRegion == null) {
            return;
        }
        super.getPlugin().getWorldRebuilderScheduler().scheduleRebuildEntityTask(new RebuildEntityTask(worldUUID, entity), affectedRegion.getRestoreTime());
    }
}

