/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.worldrebuilder.scheduling;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.world.World;

public class RebuildEntitiesTask
implements Runnable {
    private final UUID worldUUID;
    private final List<EntitySnapshot> entitySnapshots;

    public RebuildEntitiesTask(UUID worldUUID, List<EntitySnapshot> entitySnapshots) {
        this.worldUUID = worldUUID;
        this.entitySnapshots = entitySnapshots;
    }

    @Override
    public void run() {
        Optional optionalWorld = Sponge.getServer().getWorld(this.worldUUID);
        if (!optionalWorld.isPresent()) {
            return;
        }
        World world = (World)optionalWorld.get();
        for (EntitySnapshot entitySnapshot : this.entitySnapshots) {
            Optional optionalEntity = entitySnapshot.restore();
            optionalEntity.ifPresent(arg_0 -> ((World)world).spawnEntity(arg_0));
        }
    }
}

