/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.worldrebuilder.scheduling;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.github.aquerr.worldrebuilder.WorldRebuilder;
import io.github.aquerr.worldrebuilder.scheduling.RebuildBlocksTask;
import io.github.aquerr.worldrebuilder.scheduling.RebuildEntitiesTask;
import io.github.aquerr.worldrebuilder.scheduling.RebuildEntityTask;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.scheduler.Scheduler;

@Singleton
public class WorldRebuilderScheduler {
    private final Scheduler spongeScheduler = Sponge.getScheduler();

    @Inject
    public WorldRebuilderScheduler() {
    }

    public void scheduleRebuildBlocksTask(RebuildBlocksTask rebuildBlocksTask, int delayInSeconds) {
        this.spongeScheduler.createTaskBuilder().execute((Runnable)rebuildBlocksTask).delay((long)delayInSeconds, TimeUnit.SECONDS).name("World Rebuilder - Blocks Rebuild Task").submit((Object)WorldRebuilder.getPlugin());
    }

    public void scheduleRebuildEntityTask(RebuildEntitiesTask rebuildEntitiesTask, int delayInSeconds) {
        this.spongeScheduler.createTaskBuilder().execute((Runnable)rebuildEntitiesTask).delay((long)delayInSeconds, TimeUnit.SECONDS).name("World Rebuilder - Entities Rebuild Task").submit((Object)WorldRebuilder.getPlugin());
    }

    public void scheduleRebuildEntityTask(RebuildEntityTask rebuildEntityTask, int delayInSeconds) {
        this.spongeScheduler.createTaskBuilder().execute((Runnable)rebuildEntityTask).delay((long)delayInSeconds, TimeUnit.SECONDS).name("World Rebuilder - Entity Rebuild Task").submit((Object)WorldRebuilder.getPlugin());
    }
}

