/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.worldrebuilder.storage;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.github.aquerr.worldrebuilder.entity.Region;
import io.github.aquerr.worldrebuilder.storage.Storage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;

@Singleton
public class HOCONStorage
implements Storage {
    private static final String ROOT_NODE_NAME = "regions";
    private final Path regionsFilePath;
    private final ConfigurationLoader<CommentedConfigurationNode> configLoader;
    private CommentedConfigurationNode configNode;

    @Inject
    public HOCONStorage(Path configDir) {
        Path storageDirPath = configDir.resolve("storage");
        if (Files.notExists(storageDirPath, new LinkOption[0])) {
            try {
                Files.createDirectories(storageDirPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.regionsFilePath = storageDirPath.resolve("regions.conf");
        if (Files.notExists(this.regionsFilePath, new LinkOption[0])) {
            try {
                Files.createFile(this.regionsFilePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.configLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(this.regionsFilePath)).build();
        this.reload();
    }

    @Override
    public void reload() {
        try {
            this.configNode = (CommentedConfigurationNode)this.configLoader.load();
            this.saveChanges();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addRegion(Region region) throws ObjectMappingException {
        this.configNode.getNode(new Object[]{ROOT_NODE_NAME, region.getName(), "worldUUID"}).setValue(TypeToken.of(UUID.class), (Object)region.getWorldUniqueId());
        this.configNode.getNode(new Object[]{ROOT_NODE_NAME, region.getName(), "firstPoint"}).setValue(TypeToken.of(Vector3i.class), (Object)region.getFirstPoint());
        this.configNode.getNode(new Object[]{ROOT_NODE_NAME, region.getName(), "secondName"}).setValue(TypeToken.of(Vector3i.class), (Object)region.getSecondPoint());
        this.configNode.getNode(new Object[]{ROOT_NODE_NAME, region.getName(), "restoreTime"}).setValue((Object)region.getRestoreTime());
        this.configNode.getNode(new Object[]{ROOT_NODE_NAME, region.getName(), "active"}).setValue((Object)region.isActive());
        this.saveChanges();
    }

    private void saveChanges() {
        try {
            this.configLoader.save((ConfigurationNode)this.configNode);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteRegion(String name) {
        this.configNode.getNode(new Object[]{ROOT_NODE_NAME}).removeChild((Object)name);
        this.saveChanges();
    }

    @Override
    public Region getRegion(String name) throws ObjectMappingException {
        UUID worldUUID = (UUID)this.configNode.getNode(new Object[]{ROOT_NODE_NAME, name, "worldUUID"}).getValue(TypeToken.of(UUID.class));
        Vector3i firstPosition = (Vector3i)this.configNode.getNode(new Object[]{ROOT_NODE_NAME, name, "firstPoint"}).getValue(TypeToken.of(Vector3i.class));
        Vector3i secondPosition = (Vector3i)this.configNode.getNode(new Object[]{ROOT_NODE_NAME, name, "secondName"}).getValue(TypeToken.of(Vector3i.class));
        int restoreTime = this.configNode.getNode(new Object[]{ROOT_NODE_NAME, name, "restoreTime"}).getInt(10);
        boolean isActive = this.configNode.getNode(new Object[]{ROOT_NODE_NAME, name, "active"}).getBoolean(true);
        return new Region(name, worldUUID, firstPosition, secondPosition, restoreTime, isActive);
    }

    @Override
    public List<Region> getRegions() throws ObjectMappingException {
        LinkedList<Region> regions = new LinkedList<Region>();
        CommentedConfigurationNode regionsNode = this.configNode.getNode(new Object[]{ROOT_NODE_NAME});
        Map regionNodes = regionsNode.getChildrenMap();
        Set regionsNames = regionNodes.keySet();
        for (Object regionName : regionsNames) {
            if (!(regionName instanceof String)) continue;
            Region arena = this.getRegion(String.valueOf(regionName));
            regions.add(arena);
        }
        return regions;
    }
}

