/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block.component;

import java.util.Random;
import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.IComponentProvider;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface ITickableComponent {
    public int update(Block var1, World var2, BlockPos var3, IBlockState var4, Random var5);

    public static class PeriodicTickableComponent
    implements IBlockComponent {
        private final ITickableComponent tickable;
        private final int firstTickDelay;

        public PeriodicTickableComponent(ITickableComponent tickable, int firstTickDelay) {
            this.tickable = tickable;
            this.firstTickDelay = firstTickDelay;
        }

        public PeriodicTickableComponent(ITickableComponent tickable) {
            this(tickable, 0);
        }

        @Override
        public void onBlockAdded(Block block, World world, BlockPos pos, IBlockState state) {
            if (this.firstTickDelay > 0) {
                world.func_175684_a(pos, block, 1);
            }
        }

        public int update(Block block, World world, BlockPos pos, IBlockState state, Random rand) {
            return this.tickable.update(block, world, pos, state, rand);
        }
    }

    public static class RandomTickableComponent
    implements IBlockComponent {
        private final ITickableComponent tickable;

        private RandomTickableComponent(ITickableComponent tickable) {
            this.tickable = tickable;
        }

        @Override
        public void onComponentAdded(IComponentProvider provider) {
            if (provider instanceof Block) {
                ((Block)provider).func_149675_a(true);
            }
        }

        public void update(Block block, World world, BlockPos pos, IBlockState state, Random rand) {
            this.tickable.update(block, world, pos, state, rand);
        }
    }
}

