/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.block.material.Material;

class MaterialDeserializer
implements JsonDeserializer<Material> {
    private static Map<String, Material> materialMap = Maps.newHashMap();

    MaterialDeserializer() {
    }

    public Material deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Material material = materialMap.get(json.getAsString());
        if (material == null) {
            throw new JsonParseException("Unknown block material: " + json.getAsString());
        }
        return material;
    }

    static {
        materialMap.put("cactus", Material.field_151570_A);
        materialMap.put("circuits", Material.field_151594_q);
        materialMap.put("clay", Material.field_151571_B);
        materialMap.put("cloth", Material.field_151580_n);
        materialMap.put("craftedSnow", Material.field_151596_z);
        materialMap.put("fire", Material.field_151581_o);
        materialMap.put("glass", Material.field_151592_s);
        materialMap.put("grass", Material.field_151577_b);
        materialMap.put("ground", Material.field_151578_c);
        materialMap.put("ice", Material.field_151588_w);
        materialMap.put("iron", Material.field_151573_f);
        materialMap.put("lava", Material.field_151587_i);
        materialMap.put("leaves", Material.field_151584_j);
        materialMap.put("plants", Material.field_151585_k);
        materialMap.put("pumpkin", Material.field_151572_C);
        materialMap.put("redstoneLight", Material.field_151591_t);
        materialMap.put("rock", Material.field_151576_e);
        materialMap.put("sand", Material.field_151595_p);
        materialMap.put("snow", Material.field_151597_y);
        materialMap.put("sponge", Material.field_151583_m);
        materialMap.put("tnt", Material.field_151590_u);
        materialMap.put("vine", Material.field_151582_l);
        materialMap.put("water", Material.field_151586_h);
        materialMap.put("wood", Material.field_151575_d);
        materialMap.put("air", Material.field_151579_a);
    }
}

