/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import cubex2.cs4.api.WrappedBlockState;
import cubex2.cs4.plugins.vanilla.WrappedBlockStateImpl;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;

class WrappedBlockStateDeserializer
implements JsonDeserializer<WrappedBlockState> {
    WrappedBlockStateDeserializer() {
    }

    public WrappedBlockState deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ResourceLocation block;
        List<Object> properties = Lists.newArrayList();
        if (json.isJsonObject()) {
            JsonObject jsonObject = json.getAsJsonObject();
            block = (ResourceLocation)context.deserialize(jsonObject.get("block"), ResourceLocation.class);
            if (jsonObject.has("properties")) {
                properties = this.deserializeProperties(jsonObject.get("properties"));
            }
        } else {
            block = (ResourceLocation)context.deserialize(json, ResourceLocation.class);
        }
        return new WrappedBlockStateImpl(block, properties);
    }

    private List<Tuple<String, String>> deserializeProperties(JsonElement element) {
        if (element.isJsonObject()) {
            return element.getAsJsonObject().entrySet().stream().map(e -> new Tuple(e.getKey(), (Object)((JsonElement)e.getValue()).getAsString())).collect(Collectors.toList());
        }
        return Arrays.stream(element.getAsString().split(",")).map(s -> s.split("=")).map(a -> new Tuple((Object)a[0], (Object)a[1])).collect(Collectors.toList());
    }
}

