/*
 * Decompiled with CFR 0.152.
 */
package me.time6628.clag.sponge.commands.subcommands.laggychunks;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import me.time6628.clag.sponge.CatClearLag;
import me.time6628.clag.sponge.commands.LaggyChunksCommand;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Chunk;

public class EntitiesCommand
extends LaggyChunksCommand
implements CommandExecutor {
    private final CatClearLag plugin = CatClearLag.instance;

    public static CommandSpec getCommand() {
        return CommandSpec.builder().description((Text)Text.of((String)"List chunks in order of most to least entities.")).permission("catclearlag.command.laggychunks").executor((CommandExecutor)new EntitiesCommand()).build();
    }

    @Override
    public CommandResult execute(CommandSource src, CommandContext args) {
        List chunksToSort = (List)((Player)src).getWorld().getLoadedChunks();
        TreeMap<Chunk, Integer> sortedChunks = new TreeMap<Chunk, Integer>((o1, o2) -> Integer.compare(o2.getEntities().size(), o1.getEntities().size()));
        for (Chunk chunk2 : chunksToSort) {
            sortedChunks.put(chunk2, chunk2.getEntities().size());
        }
        ArrayList texts = new ArrayList();
        sortedChunks.forEach((chunk, integer) -> texts.add(Text.builder().append(new Text[]{Text.of((String)(chunk.getPosition().getX() + "," + chunk.getPosition().getZ() + " contains " + integer + " entities."))}).onClick((ClickAction)this.callback((Chunk)chunk)).build()));
        this.plugin.getPaginationService().builder().contents(texts).title(Text.builder().color(TextColors.LIGHT_PURPLE).append(new Text[]{Text.of((String)"Laggy Chunks")}).build()).sendTo((MessageReceiver)src);
        return CommandResult.success();
    }
}

