/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api.delegates.manager;

import java.util.Objects;
import java.util.Optional;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.User;
import me.lucko.luckperms.api.context.ContextCalculator;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.api.context.StaticContextCalculator;
import me.lucko.luckperms.common.api.delegates.model.ApiUser;
import me.lucko.luckperms.common.contexts.ContextManager;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ApiContextManager
implements me.lucko.luckperms.api.context.ContextManager {
    private final LuckPermsPlugin plugin;
    private final ContextManager handle;

    public ApiContextManager(LuckPermsPlugin plugin, ContextManager handle) {
        this.plugin = plugin;
        this.handle = handle;
    }

    private Object checkType(Object subject) {
        if (!this.handle.getSubjectClass().isAssignableFrom(subject.getClass())) {
            throw new IllegalStateException("Subject class " + subject.getClass() + " is not assignable from " + this.handle.getSubjectClass());
        }
        return subject;
    }

    @Override
    public @NonNull ImmutableContextSet getApplicableContext(@NonNull Object subject) {
        Objects.requireNonNull(subject, "subject");
        return this.handle.getApplicableContext(this.checkType(subject));
    }

    @Override
    public @NonNull Contexts getApplicableContexts(@NonNull Object subject) {
        Objects.requireNonNull(subject, "subject");
        return this.handle.getApplicableContexts(this.checkType(subject));
    }

    @Override
    public @NonNull Optional<ImmutableContextSet> lookupApplicableContext(@NonNull User user) {
        Objects.requireNonNull(user, "user");
        return this.plugin.getContextForUser(ApiUser.cast(user)).map(c -> c.getContexts().makeImmutable());
    }

    @Override
    public @NonNull Optional<Contexts> lookupApplicableContexts(@NonNull User user) {
        Objects.requireNonNull(user, "user");
        return this.plugin.getContextForUser(ApiUser.cast(user));
    }

    @Override
    public @NonNull ImmutableContextSet getStaticContext() {
        return this.handle.getStaticContext();
    }

    @Override
    public @NonNull Contexts getStaticContexts() {
        return this.handle.getStaticContexts();
    }

    @Override
    public @NonNull Contexts formContexts(@NonNull Object subject, @NonNull ImmutableContextSet contextSet) {
        Objects.requireNonNull(subject, "subject");
        Objects.requireNonNull(contextSet, "contextSet");
        return this.handle.formContexts(this.checkType(subject), contextSet);
    }

    @Override
    public @NonNull Contexts formContexts(@NonNull ImmutableContextSet contextSet) {
        Objects.requireNonNull(contextSet, "contextSet");
        return this.handle.formContexts(contextSet);
    }

    @Override
    public void registerCalculator(@NonNull ContextCalculator<?> calculator) {
        Objects.requireNonNull(calculator, "calculator");
        this.handle.registerCalculator(calculator);
    }

    @Override
    public void registerStaticCalculator(@NonNull StaticContextCalculator calculator) {
        Objects.requireNonNull(calculator, "calculator");
        this.handle.registerStaticCalculator(calculator);
    }

    @Override
    public void invalidateCache(@NonNull Object subject) {
        Objects.requireNonNull(subject, "subject");
        this.handle.invalidateCache(this.checkType(subject));
    }
}

