/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.meta;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import me.lucko.luckperms.api.ChatMetaType;
import me.lucko.luckperms.api.LocalizedNode;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SharedSubCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.node.comparator.NodeWithContextComparator;
import me.lucko.luckperms.common.node.factory.NodeFactory;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.Predicates;
import me.lucko.luckperms.common.utils.TextUtils;
import me.lucko.luckperms.lib.text.BuildableComponent;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.TextComponent;
import me.lucko.luckperms.lib.text.event.ClickEvent;
import me.lucko.luckperms.lib.text.event.HoverEvent;

public class MetaInfo
extends SharedSubCommand {
    private static String processLocation(LocalizedNode node, PermissionHolder holder) {
        return node.getLocation().equalsIgnoreCase(holder.getObjectName()) ? "self" : node.getLocation();
    }

    public MetaInfo(LocaleManager locale) {
        super(CommandSpec.META_INFO.localize(locale), "info", CommandPermission.USER_META_INFO, CommandPermission.GROUP_META_INFO, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, PermissionHolder holder, List<String> args, String label, CommandPermission permission) {
        if (ArgumentPermissions.checkViewPerms(plugin, sender, permission, holder)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        TreeSet<Map.Entry<Integer, LocalizedNode>> prefixes = new TreeSet<Map.Entry<Integer, LocalizedNode>>(MetaComparator.INSTANCE.reversed());
        TreeSet<Map.Entry<Integer, LocalizedNode>> suffixes = new TreeSet<Map.Entry<Integer, LocalizedNode>>(MetaComparator.INSTANCE.reversed());
        LinkedHashSet<LocalizedNode> meta = new LinkedHashSet<LocalizedNode>();
        for (LocalizedNode node : holder.resolveInheritances()) {
            if (!node.isSuffix() && !node.isPrefix() && !node.isMeta()) continue;
            if (node.isPrefix()) {
                prefixes.add(Maps.immutableEntry((Object)node.getPrefix().getKey(), (Object)node));
                continue;
            }
            if (node.isSuffix()) {
                suffixes.add(Maps.immutableEntry((Object)node.getSuffix().getKey(), (Object)node));
                continue;
            }
            if (!node.isMeta()) continue;
            meta.add(node);
        }
        if (prefixes.isEmpty()) {
            Message.CHAT_META_PREFIX_NONE.send(sender, holder.getFormattedDisplayName());
        } else {
            Message.CHAT_META_PREFIX_HEADER.send(sender, holder.getFormattedDisplayName());
            MetaInfo.sendChatMetaMessage(ChatMetaType.PREFIX, prefixes, sender, holder, label);
        }
        if (suffixes.isEmpty()) {
            Message.CHAT_META_SUFFIX_NONE.send(sender, holder.getFormattedDisplayName());
        } else {
            Message.CHAT_META_SUFFIX_HEADER.send(sender, holder.getFormattedDisplayName());
            MetaInfo.sendChatMetaMessage(ChatMetaType.SUFFIX, suffixes, sender, holder, label);
        }
        if (meta.isEmpty()) {
            Message.META_NONE.send(sender, holder.getFormattedDisplayName());
        } else {
            Message.META_HEADER.send(sender, holder.getFormattedDisplayName());
            MetaInfo.sendMetaMessage(meta, sender, holder, label);
        }
        return CommandResult.SUCCESS;
    }

    private static void sendMetaMessage(Set<LocalizedNode> meta, Sender sender, PermissionHolder holder, String label) {
        for (LocalizedNode m : meta) {
            String location = MetaInfo.processLocation(m, holder);
            if (m.hasSpecificContext()) {
                String context = MessageUtils.getAppendableNodeContextString(sender.getPlugin().getLocaleManager(), m);
                TextComponent.Builder builder = Message.META_ENTRY_WITH_CONTEXT.asComponent(sender.getPlugin().getLocaleManager(), m.getMeta().getKey(), m.getMeta().getValue(), location, context).toBuilder();
                builder.applyDeep(MetaInfo.makeFancy(holder, label, m));
                sender.sendMessage((Component)builder.build());
                continue;
            }
            TextComponent.Builder builder = Message.META_ENTRY.asComponent(sender.getPlugin().getLocaleManager(), m.getMeta().getKey(), m.getMeta().getValue(), location).toBuilder();
            builder.applyDeep(MetaInfo.makeFancy(holder, label, m));
            sender.sendMessage((Component)builder.build());
        }
    }

    private static void sendChatMetaMessage(ChatMetaType type, SortedSet<Map.Entry<Integer, LocalizedNode>> meta, Sender sender, PermissionHolder holder, String label) {
        for (Map.Entry entry : meta) {
            String location = MetaInfo.processLocation((LocalizedNode)entry.getValue(), holder);
            if (((LocalizedNode)entry.getValue()).hasSpecificContext()) {
                String context = MessageUtils.getAppendableNodeContextString(sender.getPlugin().getLocaleManager(), (Node)entry.getValue());
                TextComponent.Builder builder = Message.CHAT_META_ENTRY_WITH_CONTEXT.asComponent(sender.getPlugin().getLocaleManager(), entry.getKey(), type.getEntry((Node)entry.getValue()).getValue(), location, context).toBuilder();
                builder.applyDeep(MetaInfo.makeFancy(type, holder, label, (LocalizedNode)entry.getValue()));
                sender.sendMessage((Component)builder.build());
                continue;
            }
            TextComponent.Builder builder = Message.CHAT_META_ENTRY.asComponent(sender.getPlugin().getLocaleManager(), entry.getKey(), type.getEntry((Node)entry.getValue()).getValue(), location).toBuilder();
            builder.applyDeep(MetaInfo.makeFancy(type, holder, label, (LocalizedNode)entry.getValue()));
            sender.sendMessage((Component)builder.build());
        }
    }

    private static Consumer<BuildableComponent.Builder<?, ?>> makeFancy(ChatMetaType type, PermissionHolder holder, String label, LocalizedNode node) {
        Group group;
        if (!node.getLocation().equals(holder.getObjectName()) && (group = (Group)holder.getPlugin().getGroupManager().getIfLoaded(node.getLocation())) != null) {
            holder = group;
        }
        HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Component)TextUtils.fromLegacy(TextUtils.joinNewline("\u00a53> \u00a5a" + type.getEntry(node).getKey() + " \u00a57- \u00a5r" + type.getEntry(node).getValue(), " ", "\u00a57Click to remove this " + type.name().toLowerCase() + " from " + holder.getFormattedDisplayName()), '\u00a5'));
        String command = "/" + label + " " + NodeFactory.nodeAsCommand(node, holder.getType().isGroup() ? holder.getObjectName() : holder.getFormattedDisplayName(), holder.getType(), false, !holder.getPlugin().getConfiguration().getContextsFile().getDefaultContexts().isEmpty());
        ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command);
        return component -> {
            component.hoverEvent(hoverEvent);
            component.clickEvent(clickEvent);
        };
    }

    private static Consumer<BuildableComponent.Builder<?, ?>> makeFancy(PermissionHolder holder, String label, LocalizedNode node) {
        Group group;
        if (!node.getLocation().equals(holder.getObjectName()) && (group = (Group)holder.getPlugin().getGroupManager().getIfLoaded(node.getLocation())) != null) {
            holder = group;
        }
        HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Component)TextUtils.fromLegacy(TextUtils.joinNewline("\u00a53> \u00a5r" + node.getMeta().getKey() + " \u00a57- \u00a5r" + node.getMeta().getValue(), " ", "\u00a57Click to remove this meta pair from " + holder.getFormattedDisplayName()), '\u00a5'));
        String command = "/" + label + " " + NodeFactory.nodeAsCommand(node, holder.getType().isGroup() ? holder.getObjectName() : holder.getFormattedDisplayName(), holder.getType(), false, !holder.getPlugin().getConfiguration().getContextsFile().getDefaultContexts().isEmpty());
        ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command);
        return component -> {
            component.hoverEvent(hoverEvent);
            component.clickEvent(clickEvent);
        };
    }

    private static final class MetaComparator
    implements Comparator<Map.Entry<Integer, LocalizedNode>> {
        public static final MetaComparator INSTANCE = new MetaComparator();

        private MetaComparator() {
        }

        @Override
        public int compare(Map.Entry<Integer, LocalizedNode> o1, Map.Entry<Integer, LocalizedNode> o2) {
            int result = Integer.compare(o1.getKey(), o2.getKey());
            if (result != 0) {
                return result;
            }
            return NodeWithContextComparator.normal().compare(o1.getValue(), o2.getValue());
        }
    }
}

