/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.parent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import me.lucko.luckperms.api.LocalizedNode;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SharedSubCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.command.utils.SortMode;
import me.lucko.luckperms.common.command.utils.SortType;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.node.comparator.NodeWithContextComparator;
import me.lucko.luckperms.common.node.factory.NodeFactory;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.DurationFormatter;
import me.lucko.luckperms.common.utils.Iterators;
import me.lucko.luckperms.common.utils.Predicates;
import me.lucko.luckperms.common.utils.TextUtils;
import me.lucko.luckperms.lib.text.BuildableComponent;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.TextComponent;
import me.lucko.luckperms.lib.text.event.ClickEvent;
import me.lucko.luckperms.lib.text.event.HoverEvent;

public class ParentInfo
extends SharedSubCommand {
    private static final Comparator<LocalizedNode> ALPHABETICAL_NODE_COMPARATOR = (o1, o2) -> {
        int i = o1.getGroupName().compareTo(o2.getGroupName());
        if (i != 0) {
            return i;
        }
        return NodeWithContextComparator.reverse().compare((Node)o1, (Node)o2);
    };

    public ParentInfo(LocaleManager locale) {
        super(CommandSpec.PARENT_INFO.localize(locale), "info", CommandPermission.USER_PARENT_INFO, CommandPermission.GROUP_PARENT_INFO, Predicates.notInRange(0, 2));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, PermissionHolder holder, List<String> args, String label, CommandPermission permission) {
        if (ArgumentPermissions.checkViewPerms(plugin, sender, permission, holder)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        int page = ArgumentParser.parseIntOrElse(0, args, 1);
        SortMode sortMode = SortMode.determine(args);
        ArrayList<LocalizedNode> nodes = new ArrayList<LocalizedNode>(holder.enduringData().asSortedSet());
        nodes.removeIf(node -> !node.isGroupNode() || !node.getValue());
        if (nodes.isEmpty()) {
            Message.PARENT_INFO_NO_DATA.send(sender, holder.getFormattedDisplayName());
            return CommandResult.SUCCESS;
        }
        if (sortMode.getType() == SortType.ALPHABETICALLY) {
            nodes.sort(ALPHABETICAL_NODE_COMPARATOR);
        }
        if (!sortMode.isAscending()) {
            Collections.reverse(nodes);
        }
        int pageIndex = page - 1;
        List<List<LocalizedNode>> pages = Iterators.divideIterable(nodes, 19);
        if (pageIndex < 0 || pageIndex >= pages.size()) {
            page = 1;
            pageIndex = 0;
        }
        List<LocalizedNode> content = pages.get(pageIndex);
        Message.PARENT_INFO.send(sender, holder.getFormattedDisplayName(), page, pages.size(), nodes.size());
        for (LocalizedNode node2 : content) {
            String s = "&3> &a" + node2.getGroupName() + MessageUtils.getAppendableNodeContextString(plugin.getLocaleManager(), node2);
            if (node2.isTemporary()) {
                s = s + "\n&2  expires in " + DurationFormatter.LONG.formatDateDiff(node2.getExpiryUnixTime());
            }
            TextComponent message = ((TextComponent.Builder)TextUtils.fromLegacy(s, '&').toBuilder().applyDeep(ParentInfo.makeFancy(holder, label, node2))).build();
            sender.sendMessage((Component)message);
        }
        return CommandResult.SUCCESS;
    }

    private static Consumer<BuildableComponent.Builder<?, ?>> makeFancy(PermissionHolder holder, String label, Node node) {
        HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Component)TextUtils.fromLegacy(TextUtils.joinNewline("&3> &f" + node.getGroupName(), " ", "&7Click to remove this parent from " + holder.getFormattedDisplayName()), '&'));
        String command = "/" + label + " " + NodeFactory.nodeAsCommand(node, holder.getType().isGroup() ? holder.getObjectName() : holder.getFormattedDisplayName(), holder.getType(), false, !holder.getPlugin().getConfiguration().getContextsFile().getDefaultContexts().isEmpty());
        ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command);
        return component -> {
            component.hoverEvent(hoverEvent);
            component.clickEvent(clickEvent);
        };
    }
}

