/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.log;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.actionlog.Log;
import me.lucko.luckperms.common.command.abstraction.Command;
import me.lucko.luckperms.common.command.abstraction.MainCommand;
import me.lucko.luckperms.common.commands.log.LogGroupHistory;
import me.lucko.luckperms.common.commands.log.LogNotify;
import me.lucko.luckperms.common.commands.log.LogRecent;
import me.lucko.luckperms.common.commands.log.LogSearch;
import me.lucko.luckperms.common.commands.log.LogTrackHistory;
import me.lucko.luckperms.common.commands.log.LogUserHistory;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;

public class LogMainCommand
extends MainCommand<Log, Object> {
    private final ReentrantLock lock = new ReentrantLock();

    public LogMainCommand(LocaleManager locale) {
        super(CommandSpec.LOG.localize(locale), "Log", 1, ImmutableList.builder().add((Object)new LogRecent(locale)).add((Object)new LogSearch(locale)).add((Object)new LogNotify(locale)).add((Object)new LogUserHistory(locale)).add((Object)new LogGroupHistory(locale)).add((Object)new LogTrackHistory(locale)).build());
    }

    @Override
    protected ReentrantLock getLockForTarget(Object target) {
        return this.lock;
    }

    @Override
    protected Object parseTarget(String target, LuckPermsPlugin plugin, Sender sender) {
        return this;
    }

    @Override
    protected Log getTarget(Object target, LuckPermsPlugin plugin, Sender sender) {
        Log log = plugin.getStorage().getLog().join();
        if (log == null) {
            Message.LOG_LOAD_ERROR.send(sender, new Object[0]);
        }
        return log;
    }

    @Override
    protected void cleanup(Log log, LuckPermsPlugin plugin) {
    }

    @Override
    protected List<String> getTargets(LuckPermsPlugin plugin) {
        return null;
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, List<String> args) {
        List subs = this.getChildren().get().stream().filter(s -> s.isAuthorized(sender)).collect(Collectors.toList());
        if (args.size() <= 1) {
            if (args.isEmpty() || args.get(0).equalsIgnoreCase("")) {
                return subs.stream().map(m -> m.getName().toLowerCase()).collect(Collectors.toList());
            }
            return subs.stream().map(m -> m.getName().toLowerCase()).filter(s -> s.toLowerCase().startsWith(((String)args.get(0)).toLowerCase())).collect(Collectors.toList());
        }
        Optional<Command> o = subs.stream().filter(s -> s.getName().equalsIgnoreCase((String)args.get(0))).limit(1L).findAny();
        return o.map(cmd -> cmd.tabComplete(plugin, sender, args.subList(1, args.size()))).orElseGet(Collections::emptyList);
    }
}

