/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.misc;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import me.lucko.luckperms.common.backup.Importer;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.Predicates;

public class ImportCommand
extends SingleCommand {
    private final AtomicBoolean running = new AtomicBoolean(false);

    public ImportCommand(LocaleManager locale) {
        super(CommandSpec.IMPORT.localize(locale), "Import", CommandPermission.IMPORT, Predicates.not(1));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, List<String> args, String label) {
        List<String> commands;
        if (this.running.get()) {
            Message.IMPORT_ALREADY_RUNNING.send(sender, new Object[0]);
            return CommandResult.STATE_ERROR;
        }
        Path dataDirectory = plugin.getBootstrap().getDataDirectory();
        Path path = dataDirectory.resolve(args.get(0));
        if (!path.getParent().equals(dataDirectory) || path.getFileName().toString().equals("config.yml")) {
            Message.FILE_NOT_WITHIN_DIRECTORY.send(sender, path.toString());
            return CommandResult.INVALID_ARGS;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            Message.IMPORT_LOG_DOESNT_EXIST.send(sender, path.toString());
            return CommandResult.INVALID_ARGS;
        }
        if (!Files.isReadable(path)) {
            Message.IMPORT_LOG_NOT_READABLE.send(sender, path.toString());
            return CommandResult.FAILURE;
        }
        try {
            commands = Files.readAllLines(path, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
            Message.IMPORT_LOG_FAILURE.send(sender, new Object[0]);
            return CommandResult.FAILURE;
        }
        if (!this.running.compareAndSet(false, true)) {
            Message.IMPORT_ALREADY_RUNNING.send(sender, new Object[0]);
            return CommandResult.STATE_ERROR;
        }
        Importer importer = new Importer(plugin.getCommandManager(), sender, commands);
        plugin.getBootstrap().getScheduler().executeAsync(() -> {
            try {
                importer.run();
            }
            finally {
                this.running.set(false);
            }
        });
        return CommandResult.SUCCESS;
    }
}

