/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.track;

import java.util.List;
import me.lucko.luckperms.api.DataMutateResult;
import me.lucko.luckperms.common.actionlog.ExtendedLogEntry;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SubCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.DataConstraints;
import me.lucko.luckperms.common.utils.Predicates;

public class TrackInsert
extends SubCommand<Track> {
    public TrackInsert(LocaleManager locale) {
        super(CommandSpec.TRACK_INSERT.localize(locale), "insert", CommandPermission.TRACK_INSERT, Predicates.not(2));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, Track track, List<String> args, String label) {
        int pos;
        String groupName = args.get(0).toLowerCase();
        if (!DataConstraints.GROUP_NAME_TEST.test(groupName)) {
            this.sendDetailedUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }
        try {
            pos = Integer.parseInt(args.get(1));
        }
        catch (NumberFormatException e) {
            Message.TRACK_INSERT_ERROR_NUMBER.send(sender, args.get(1));
            return CommandResult.INVALID_ARGS;
        }
        Group group = StorageAssistant.loadGroup(groupName, sender, plugin, false);
        if (group == null) {
            return CommandResult.LOADING_ERROR;
        }
        try {
            DataMutateResult result = track.insertGroup(group, pos - 1);
            if (result.asBoolean()) {
                Message.TRACK_INSERT_SUCCESS.send(sender, group.getName(), track.getName(), pos);
                if (track.getGroups().size() > 1) {
                    Message.EMPTY.send(sender, MessageUtils.listToArrowSep(track.getGroups(), group.getName()));
                }
                ExtendedLogEntry.build().actor(sender).acted(track).action("insert", group.getName(), pos).build().submit(plugin, sender);
                StorageAssistant.save(track, sender, plugin);
                return CommandResult.SUCCESS;
            }
            Message.TRACK_ALREADY_CONTAINS.send(sender, track.getName(), group.getName());
            return CommandResult.STATE_ERROR;
        }
        catch (IndexOutOfBoundsException e) {
            Message.TRACK_INSERT_ERROR_INVALID_POS.send(sender, pos);
            return CommandResult.INVALID_ARGS;
        }
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, List<String> args) {
        return TabCompleter.create().at(0, TabCompletions.groups(plugin)).complete(args);
    }
}

