/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.sql;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.lucko.luckperms.api.HeldPermission;
import me.lucko.luckperms.api.LogEntry;
import me.lucko.luckperms.api.PlayerSaveResult;
import me.lucko.luckperms.common.actionlog.ExtendedLogEntry;
import me.lucko.luckperms.common.actionlog.Log;
import me.lucko.luckperms.common.bulkupdate.BulkUpdate;
import me.lucko.luckperms.common.bulkupdate.PreparedStatementBuilder;
import me.lucko.luckperms.common.bulkupdate.comparisons.Constraint;
import me.lucko.luckperms.common.contexts.ContextSetJsonSerializer;
import me.lucko.luckperms.common.managers.group.GroupManager;
import me.lucko.luckperms.common.managers.track.TrackManager;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.NodeMapType;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.model.UserIdentifier;
import me.lucko.luckperms.common.node.model.NodeDataContainer;
import me.lucko.luckperms.common.node.model.NodeHeldPermission;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.implementation.StorageImplementation;
import me.lucko.luckperms.common.storage.implementation.sql.connection.ConnectionFactory;
import me.lucko.luckperms.common.storage.implementation.sql.connection.file.SQLiteConnectionFactory;
import me.lucko.luckperms.common.storage.implementation.sql.connection.hikari.PostgreConnectionFactory;
import me.lucko.luckperms.common.storage.misc.PlayerSaveResultImpl;
import me.lucko.luckperms.common.utils.gson.GsonProvider;

public class SqlStorage
implements StorageImplementation {
    private static final Type LIST_STRING_TYPE = new TypeToken<List<String>>(){}.getType();
    private static final String USER_PERMISSIONS_SELECT = "SELECT permission, value, server, world, expiry, contexts FROM {prefix}user_permissions WHERE uuid=?";
    private static final String USER_PERMISSIONS_DELETE_SPECIFIC = "DELETE FROM {prefix}user_permissions WHERE uuid=? AND permission=? AND value=? AND server=? AND world=? AND expiry=? AND contexts=?";
    private static final String USER_PERMISSIONS_DELETE = "DELETE FROM {prefix}user_permissions WHERE uuid=?";
    private static final String USER_PERMISSIONS_INSERT = "INSERT INTO {prefix}user_permissions(uuid, permission, value, server, world, expiry, contexts) VALUES(?, ?, ?, ?, ?, ?, ?)";
    private static final String USER_PERMISSIONS_SELECT_DISTINCT = "SELECT DISTINCT uuid FROM {prefix}user_permissions";
    private static final String USER_PERMISSIONS_SELECT_PERMISSION = "SELECT uuid, permission, value, server, world, expiry, contexts FROM {prefix}user_permissions WHERE ";
    private static final String PLAYER_SELECT_UUID_BY_USERNAME = "SELECT uuid FROM {prefix}players WHERE username=? LIMIT 1";
    private static final String PLAYER_SELECT_USERNAME_BY_UUID = "SELECT username FROM {prefix}players WHERE uuid=? LIMIT 1";
    private static final String PLAYER_UPDATE_USERNAME_FOR_UUID = "UPDATE {prefix}players SET username=? WHERE uuid=?";
    private static final String PLAYER_INSERT = "INSERT INTO {prefix}players (uuid, username, primary_group) VALUES(?, ?, ?)";
    private static final String PLAYER_SELECT_ALL_UUIDS_BY_USERNAME = "SELECT uuid FROM {prefix}players WHERE username=? AND NOT uuid=?";
    private static final String PLAYER_DELETE_ALL_UUIDS_BY_USERNAME = "DELETE FROM {prefix}players WHERE username=? AND NOT uuid=?";
    private static final String PLAYER_SELECT_BY_UUID = "SELECT username, primary_group FROM {prefix}players WHERE uuid=?";
    private static final String PLAYER_SELECT_PRIMARY_GROUP_BY_UUID = "SELECT primary_group FROM {prefix}players WHERE uuid=? LIMIT 1";
    private static final String PLAYER_UPDATE_PRIMARY_GROUP_BY_UUID = "UPDATE {prefix}players SET primary_group=? WHERE uuid=?";
    private static final String GROUP_PERMISSIONS_SELECT = "SELECT permission, value, server, world, expiry, contexts FROM {prefix}group_permissions WHERE name=?";
    private static final String GROUP_PERMISSIONS_DELETE = "DELETE FROM {prefix}group_permissions WHERE name=?";
    private static final String GROUP_PERMISSIONS_DELETE_SPECIFIC = "DELETE FROM {prefix}group_permissions WHERE name=? AND permission=? AND value=? AND server=? AND world=? AND expiry=? AND contexts=?";
    private static final String GROUP_PERMISSIONS_INSERT = "INSERT INTO {prefix}group_permissions(name, permission, value, server, world, expiry, contexts) VALUES(?, ?, ?, ?, ?, ?, ?)";
    private static final String GROUP_PERMISSIONS_SELECT_PERMISSION = "SELECT name, permission, value, server, world, expiry, contexts FROM {prefix}group_permissions WHERE ";
    private static final String GROUP_SELECT_ALL = "SELECT name FROM '{prefix}groups'";
    private static final String MYSQL_GROUP_INSERT = "INSERT INTO '{prefix}groups' (name) VALUES(?) ON DUPLICATE KEY UPDATE name=name";
    private static final String H2_GROUP_INSERT = "MERGE INTO '{prefix}groups' (name) VALUES(?)";
    private static final String SQLITE_GROUP_INSERT = "INSERT OR IGNORE INTO '{prefix}groups' (name) VALUES(?)";
    private static final String POSTGRESQL_GROUP_INSERT = "INSERT INTO '{prefix}groups' (name) VALUES(?) ON CONFLICT (name) DO NOTHING";
    private static final String GROUP_DELETE = "DELETE FROM '{prefix}groups' WHERE name=?";
    private static final String TRACK_INSERT = "INSERT INTO {prefix}tracks (name, 'groups') VALUES(?, ?)";
    private static final String TRACK_SELECT = "SELECT 'groups' FROM {prefix}tracks WHERE name=?";
    private static final String TRACK_SELECT_ALL = "SELECT * FROM {prefix}tracks";
    private static final String TRACK_UPDATE = "UPDATE {prefix}tracks SET 'groups'=? WHERE name=?";
    private static final String TRACK_DELETE = "DELETE FROM {prefix}tracks WHERE name=?";
    private static final String ACTION_INSERT = "INSERT INTO {prefix}actions(time, actor_uuid, actor_name, type, acted_uuid, acted_name, action) VALUES(?, ?, ?, ?, ?, ?, ?)";
    private static final String ACTION_SELECT_ALL = "SELECT * FROM {prefix}actions";
    private final LuckPermsPlugin plugin;
    private final ConnectionFactory connectionFactory;
    private final Function<String, String> statementProcessor;

    public SqlStorage(LuckPermsPlugin plugin, ConnectionFactory connectionFactory, String tablePrefix) {
        this.plugin = plugin;
        this.connectionFactory = connectionFactory;
        this.statementProcessor = connectionFactory.getStatementProcessor().compose(s -> s.replace("{prefix}", tablePrefix));
    }

    @Override
    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getImplementationName() {
        return this.connectionFactory.getImplementationName();
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public Function<String, String> getStatementProcessor() {
        return this.statementProcessor;
    }

    /*
     * Exception decompiling
     */
    private boolean tableExists(String table) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void init() throws Exception {
        block79: {
            this.connectionFactory.init();
            if (!this.tableExists(this.statementProcessor.apply("{prefix}user_permissions"))) {
                String schemaFileName = "me/lucko/luckperms/schema/" + this.connectionFactory.getImplementationName().toLowerCase() + ".sql";
                try (InputStream is = this.plugin.getBootstrap().getResourceStream(schemaFileName);){
                    if (is == null) {
                        throw new Exception("Couldn't locate schema file for " + this.connectionFactory.getImplementationName());
                    }
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                         Connection connection = this.connectionFactory.getConnection();
                         Statement s = connection.createStatement();){
                        String line;
                        StringBuilder sb = new StringBuilder();
                        while ((line = reader.readLine()) != null) {
                            if (line.startsWith("--") || line.startsWith("#")) continue;
                            sb.append(line);
                            if (!line.endsWith(";")) continue;
                            sb.deleteCharAt(sb.length() - 1);
                            String result = this.statementProcessor.apply(sb.toString().trim());
                            if (!result.isEmpty()) {
                                s.addBatch(result);
                            }
                            sb = new StringBuilder();
                        }
                        s.executeBatch();
                    }
                }
            }
            try {
                if (this.connectionFactory instanceof SQLiteConnectionFactory || this.connectionFactory instanceof PostgreConnectionFactory) break block79;
                try (Connection connection = this.connectionFactory.getConnection();
                     Statement s = connection.createStatement();){
                    s.execute(this.statementProcessor.apply("ALTER TABLE {prefix}actions MODIFY COLUMN actor_name VARCHAR(100)"));
                    s.execute(this.statementProcessor.apply("ALTER TABLE {prefix}actions MODIFY COLUMN action VARCHAR(300)"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void shutdown() {
        try {
            this.connectionFactory.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<String, String> getMeta() {
        return this.connectionFactory.getMeta();
    }

    @Override
    public void logAction(LogEntry entry) throws SQLException {
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(ACTION_INSERT));){
            ps.setLong(1, entry.getTimestamp());
            ps.setString(2, entry.getActor().toString());
            ps.setString(3, entry.getActorName());
            ps.setString(4, Character.toString(entry.getType().getCode()));
            ps.setString(5, entry.getActed().map(UUID::toString).orElse("null"));
            ps.setString(6, entry.getActedName());
            ps.setString(7, entry.getAction());
            ps.execute();
        }
    }

    @Override
    public Log getLog() throws SQLException {
        Log.Builder log = Log.builder();
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(ACTION_SELECT_ALL));
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                String actedUuid = rs.getString("acted_uuid");
                ExtendedLogEntry e = ExtendedLogEntry.build().timestamp(rs.getLong("time")).actor(UUID.fromString(rs.getString("actor_uuid"))).actorName(rs.getString("actor_name")).type(LogEntry.Type.valueOf(rs.getString("type").toCharArray()[0])).acted(actedUuid.equals("null") ? null : UUID.fromString(actedUuid)).actedName(rs.getString("acted_name")).action(rs.getString("action")).build();
                log.add(e);
            }
        }
        return log.build();
    }

    @Override
    public void applyBulkUpdate(BulkUpdate bulkUpdate) throws SQLException {
        block38: {
            try (Connection c = this.connectionFactory.getConnection();){
                Throwable throwable;
                PreparedStatement ps;
                String table;
                if (bulkUpdate.getDataType().isIncludingUsers()) {
                    table = this.statementProcessor.apply("{prefix}user_permissions");
                    ps = bulkUpdate.buildAsSql().build(c, q -> q.replace("{table}", table));
                    throwable = null;
                    try {
                        ps.execute();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ps != null) {
                            if (throwable != null) {
                                try {
                                    ps.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ps.close();
                            }
                        }
                    }
                }
                if (!bulkUpdate.getDataType().isIncludingGroups()) break block38;
                table = this.statementProcessor.apply("{prefix}group_permissions");
                ps = bulkUpdate.buildAsSql().build(c, q -> q.replace("{table}", table));
                throwable = null;
                try {
                    ps.execute();
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (ps != null) {
                        if (throwable != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            ps.close();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User loadUser(UUID uuid, String username) throws SQLException {
        User user = (User)this.plugin.getUserManager().getOrMake(UserIdentifier.of(uuid, username));
        user.getIoLock().lock();
        try {
            Throwable throwable;
            ResultSet rs2;
            Throwable throwable2;
            PreparedStatement ps;
            ArrayList<NodeDataContainer> data = new ArrayList<NodeDataContainer>();
            String primaryGroup = null;
            String userName = null;
            try (Connection c = this.connectionFactory.getConnection();){
                ps = c.prepareStatement(this.statementProcessor.apply(USER_PERMISSIONS_SELECT));
                throwable2 = null;
                try {
                    ps.setString(1, user.getUuid().toString());
                    rs2 = ps.executeQuery();
                    throwable = null;
                    try {
                        while (rs2.next()) {
                            String permission = rs2.getString("permission");
                            boolean value = rs2.getBoolean("value");
                            String server = rs2.getString("server");
                            String world = rs2.getString("world");
                            long expiry = rs2.getLong("expiry");
                            String contexts = rs2.getString("contexts");
                            data.add(this.deserializeNode(permission, value, server, world, expiry, contexts));
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rs2 != null) {
                            if (throwable != null) {
                                try {
                                    rs2.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                rs2.close();
                            }
                        }
                    }
                }
                catch (Throwable rs2) {
                    throwable2 = rs2;
                    throw rs2;
                }
                finally {
                    if (ps != null) {
                        if (throwable2 != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable rs2) {
                                throwable2.addSuppressed(rs2);
                            }
                        } else {
                            ps.close();
                        }
                    }
                }
            }
            c = this.connectionFactory.getConnection();
            var8_8 = null;
            try {
                ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_SELECT_BY_UUID));
                throwable2 = null;
                try {
                    ps.setString(1, user.getUuid().toString());
                    rs2 = ps.executeQuery();
                    throwable = null;
                    try {
                        if (rs2.next()) {
                            userName = rs2.getString("username");
                            primaryGroup = rs2.getString("primary_group");
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (rs2 != null) {
                            if (throwable != null) {
                                try {
                                    rs2.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                rs2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable7) {
                    throwable2 = throwable7;
                    throw throwable7;
                }
                finally {
                    if (ps != null) {
                        if (throwable2 != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable8) {
                                throwable2.addSuppressed(throwable8);
                            }
                        } else {
                            ps.close();
                        }
                    }
                }
            }
            catch (Throwable throwable9) {
                var8_8 = throwable9;
                throw throwable9;
            }
            finally {
                if (c != null) {
                    if (var8_8 != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable throwable10) {
                            var8_8.addSuppressed(throwable10);
                        }
                    } else {
                        c.close();
                    }
                }
            }
            if (primaryGroup == null) {
                primaryGroup = "default";
            }
            user.getPrimaryGroup().setStoredValue(primaryGroup);
            user.setName(userName, true);
            if (!data.isEmpty()) {
                Set nodes = data.stream().map(NodeDataContainer::toNode).collect(Collectors.toSet());
                user.setNodes(NodeMapType.ENDURING, nodes);
                if (this.plugin.getUserManager().giveDefaultIfNeeded(user, false) | user.auditTemporaryPermissions()) {
                    this.saveUser(user);
                }
            } else if (this.plugin.getUserManager().shouldSave(user)) {
                user.clearNodes();
                user.getPrimaryGroup().setStoredValue(null);
                this.plugin.getUserManager().giveDefaultIfNeeded(user, false);
            }
        }
        finally {
            user.invalidateCachedData();
            user.getIoLock().unlock();
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveUser(User user) throws SQLException {
        block197: {
            user.getIoLock().lock();
            try {
                PreparedStatement ps4;
                Connection c;
                Throwable throwable;
                if (!this.plugin.getUserManager().shouldSave(user)) {
                    try (Connection c2 = this.connectionFactory.getConnection();){
                        try (PreparedStatement ps2 = c2.prepareStatement(this.statementProcessor.apply(USER_PERMISSIONS_DELETE));){
                            ps2.setString(1, user.getUuid().toString());
                            ps2.execute();
                        }
                        ps2 = c2.prepareStatement(this.statementProcessor.apply(PLAYER_UPDATE_PRIMARY_GROUP_BY_UUID));
                        var5_10 = null;
                        try {
                            ps2.setString(1, "default");
                            ps2.setString(2, user.getUuid().toString());
                            ps2.execute();
                        }
                        catch (Throwable throwable2) {
                            var5_10 = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (ps2 != null) {
                                if (var5_10 != null) {
                                    try {
                                        ps2.close();
                                    }
                                    catch (Throwable throwable3) {
                                        var5_10.addSuppressed(throwable3);
                                    }
                                } else {
                                    ps2.close();
                                }
                            }
                        }
                    }
                    return;
                }
                HashSet<NodeDataContainer> remote = new HashSet<NodeDataContainer>();
                try (Connection c3 = this.connectionFactory.getConnection();
                     PreparedStatement ps3 = c3.prepareStatement(this.statementProcessor.apply(USER_PERMISSIONS_SELECT));){
                    ps3.setString(1, user.getUuid().toString());
                    throwable = null;
                    try (ResultSet rs = ps3.executeQuery();){
                        while (rs.next()) {
                            String permission = rs.getString("permission");
                            boolean value = rs.getBoolean("value");
                            String server = rs.getString("server");
                            String world = rs.getString("world");
                            long expiry = rs.getLong("expiry");
                            String contexts = rs.getString("contexts");
                            remote.add(this.deserializeNode(permission, value, server, world, expiry, contexts));
                        }
                    }
                    catch (Throwable permission) {
                        throwable = permission;
                        throw permission;
                    }
                }
                Set<NodeDataContainer> local = user.enduringData().immutable().values().stream().map(NodeDataContainer::fromNode).collect(Collectors.toSet());
                Map.Entry<Set<NodeDataContainer>, Set<NodeDataContainer>> diff = SqlStorage.compareSets(local, remote);
                Set<NodeDataContainer> toAdd = diff.getKey();
                Set<NodeDataContainer> toRemove = diff.getValue();
                if (!toRemove.isEmpty()) {
                    c = this.connectionFactory.getConnection();
                    throwable = null;
                    try {
                        ps4 = c.prepareStatement(this.statementProcessor.apply(USER_PERMISSIONS_DELETE_SPECIFIC));
                        Throwable value = null;
                        try {
                            for (NodeDataContainer nd : toRemove) {
                                ps4.setString(1, user.getUuid().toString());
                                ps4.setString(2, nd.getPermission());
                                ps4.setBoolean(3, nd.getValue());
                                ps4.setString(4, nd.getServer());
                                ps4.setString(5, nd.getWorld());
                                ps4.setLong(6, nd.getExpiry());
                                ps4.setString(7, GsonProvider.normal().toJson((JsonElement)ContextSetJsonSerializer.serializeContextSet(nd.getContexts())));
                                ps4.addBatch();
                            }
                            ps4.executeBatch();
                        }
                        catch (Throwable throwable4) {
                            value = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (ps4 != null) {
                                if (value != null) {
                                    try {
                                        ps4.close();
                                    }
                                    catch (Throwable throwable5) {
                                        value.addSuppressed(throwable5);
                                    }
                                } else {
                                    ps4.close();
                                }
                            }
                        }
                    }
                    catch (Throwable ps4) {
                        throwable = ps4;
                        throw ps4;
                    }
                    finally {
                        if (c != null) {
                            if (throwable != null) {
                                try {
                                    c.close();
                                }
                                catch (Throwable ps4) {
                                    throwable.addSuppressed(ps4);
                                }
                            } else {
                                c.close();
                            }
                        }
                    }
                }
                if (!toAdd.isEmpty()) {
                    c = this.connectionFactory.getConnection();
                    throwable = null;
                    try {
                        ps4 = c.prepareStatement(this.statementProcessor.apply(USER_PERMISSIONS_INSERT));
                        Throwable value = null;
                        try {
                            for (NodeDataContainer nd : toAdd) {
                                ps4.setString(1, user.getUuid().toString());
                                ps4.setString(2, nd.getPermission());
                                ps4.setBoolean(3, nd.getValue());
                                ps4.setString(4, nd.getServer());
                                ps4.setString(5, nd.getWorld());
                                ps4.setLong(6, nd.getExpiry());
                                ps4.setString(7, GsonProvider.normal().toJson((JsonElement)ContextSetJsonSerializer.serializeContextSet(nd.getContexts())));
                                ps4.addBatch();
                            }
                            ps4.executeBatch();
                        }
                        catch (Throwable throwable6) {
                            value = throwable6;
                            throw throwable6;
                        }
                        finally {
                            if (ps4 != null) {
                                if (value != null) {
                                    try {
                                        ps4.close();
                                    }
                                    catch (Throwable throwable7) {
                                        value.addSuppressed(throwable7);
                                    }
                                } else {
                                    ps4.close();
                                }
                            }
                        }
                    }
                    catch (Throwable ps5) {
                        throwable = ps5;
                        throw ps5;
                    }
                    finally {
                        if (c != null) {
                            if (throwable != null) {
                                try {
                                    c.close();
                                }
                                catch (Throwable ps5) {
                                    throwable.addSuppressed(ps5);
                                }
                            } else {
                                c.close();
                            }
                        }
                    }
                }
                c = this.connectionFactory.getConnection();
                throwable = null;
                try {
                    boolean hasPrimaryGroupSaved;
                    PreparedStatement ps6 = c.prepareStatement(this.statementProcessor.apply(PLAYER_SELECT_PRIMARY_GROUP_BY_UUID));
                    Object object = null;
                    try {
                        ps6.setString(1, user.getUuid().toString());
                        try (ResultSet rs = ps6.executeQuery();){
                            hasPrimaryGroupSaved = rs.next();
                        }
                    }
                    catch (Throwable throwable8) {
                        object = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (ps6 != null) {
                            if (object != null) {
                                try {
                                    ps6.close();
                                }
                                catch (Throwable throwable9) {
                                    ((Throwable)object).addSuppressed(throwable9);
                                }
                            } else {
                                ps6.close();
                            }
                        }
                    }
                    if (hasPrimaryGroupSaved) {
                        ps6 = c.prepareStatement(this.statementProcessor.apply(PLAYER_UPDATE_PRIMARY_GROUP_BY_UUID));
                        object = null;
                        try {
                            ps6.setString(1, user.getPrimaryGroup().getStoredValue().orElse("default"));
                            ps6.setString(2, user.getUuid().toString());
                            ps6.execute();
                            break block197;
                        }
                        catch (Throwable throwable10) {
                            object = throwable10;
                            throw throwable10;
                        }
                        finally {
                            if (ps6 != null) {
                                if (object != null) {
                                    try {
                                        ps6.close();
                                    }
                                    catch (Throwable throwable11) {
                                        ((Throwable)object).addSuppressed(throwable11);
                                    }
                                } else {
                                    ps6.close();
                                }
                            }
                        }
                    }
                    ps6 = c.prepareStatement(this.statementProcessor.apply(PLAYER_INSERT));
                    object = null;
                    try {
                        ps6.setString(1, user.getUuid().toString());
                        ps6.setString(2, user.getName().orElse("null").toLowerCase());
                        ps6.setString(3, user.getPrimaryGroup().getStoredValue().orElse("default"));
                        ps6.execute();
                    }
                    catch (Throwable throwable12) {
                        object = throwable12;
                        throw throwable12;
                    }
                    finally {
                        if (ps6 != null) {
                            if (object != null) {
                                try {
                                    ps6.close();
                                }
                                catch (Throwable throwable13) {
                                    ((Throwable)object).addSuppressed(throwable13);
                                }
                            } else {
                                ps6.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable14) {
                    throwable = throwable14;
                    throw throwable14;
                }
                finally {
                    if (c != null) {
                        if (throwable != null) {
                            try {
                                c.close();
                            }
                            catch (Throwable throwable15) {
                                throwable.addSuppressed(throwable15);
                            }
                        } else {
                            c.close();
                        }
                    }
                }
            }
            finally {
                user.getIoLock().unlock();
            }
        }
    }

    @Override
    public Set<UUID> getUniqueUsers() throws SQLException {
        HashSet<UUID> uuids = new HashSet<UUID>();
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(USER_PERMISSIONS_SELECT_DISTINCT));
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                String uuid = rs.getString("uuid");
                uuids.add(UUID.fromString(uuid));
            }
        }
        return uuids;
    }

    @Override
    public List<HeldPermission<UUID>> getUsersWithPermission(Constraint constraint) throws SQLException {
        PreparedStatementBuilder builder = new PreparedStatementBuilder().append(USER_PERMISSIONS_SELECT_PERMISSION);
        constraint.appendSql(builder, "permission");
        ArrayList<HeldPermission<UUID>> held = new ArrayList<HeldPermission<UUID>>();
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = builder.build(c, this.statementProcessor);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                UUID holder = UUID.fromString(rs.getString("uuid"));
                String perm = rs.getString("permission");
                boolean value = rs.getBoolean("value");
                String server = rs.getString("server");
                String world = rs.getString("world");
                long expiry = rs.getLong("expiry");
                String contexts = rs.getString("contexts");
                NodeDataContainer data = this.deserializeNode(perm, value, server, world, expiry, contexts);
                held.add(NodeHeldPermission.of(holder, data));
            }
        }
        return held;
    }

    @Override
    public Group createAndLoadGroup(String name) throws SQLException {
        String query;
        switch (this.connectionFactory.getImplementationName()) {
            case "H2": {
                query = H2_GROUP_INSERT;
                break;
            }
            case "SQLite": {
                query = SQLITE_GROUP_INSERT;
                break;
            }
            case "PostgreSQL": {
                query = POSTGRESQL_GROUP_INSERT;
                break;
            }
            default: {
                query = MYSQL_GROUP_INSERT;
            }
        }
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(query));){
            ps.setString(1, name);
            ps.execute();
        }
        return this.loadGroup(name).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Group> loadGroup(String name) throws SQLException {
        Throwable throwable;
        Throwable throwable2;
        ArrayList<String> groups = new ArrayList<String>();
        try (Connection c = this.connectionFactory.getConnection();){
            throwable2 = null;
            try (PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(GROUP_SELECT_ALL));){
                throwable = null;
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        groups.add(rs.getString("name").toLowerCase());
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable rs) {
                throwable2 = rs;
                throw rs;
            }
        }
        if (!groups.contains(name)) {
            return Optional.empty();
        }
        Group group = (Group)this.plugin.getGroupManager().getOrMake(name);
        group.getIoLock().lock();
        try {
            ArrayList<NodeDataContainer> data = new ArrayList<NodeDataContainer>();
            throwable2 = null;
            try (Connection c = this.connectionFactory.getConnection();){
                throwable = null;
                try (PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(GROUP_PERMISSIONS_SELECT));){
                    ps.setString(1, group.getName());
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            String permission = rs.getString("permission");
                            boolean value = rs.getBoolean("value");
                            String server = rs.getString("server");
                            String world = rs.getString("world");
                            long expiry = rs.getLong("expiry");
                            String contexts = rs.getString("contexts");
                            data.add(this.deserializeNode(permission, value, server, world, expiry, contexts));
                        }
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            if (!data.isEmpty()) {
                Set nodes = data.stream().map(NodeDataContainer::toNode).collect(Collectors.toSet());
                group.setNodes(NodeMapType.ENDURING, nodes);
            } else {
                group.clearNodes();
            }
        }
        finally {
            group.invalidateCachedData();
            group.getIoLock().unlock();
        }
        return Optional.of(group);
    }

    @Override
    public void loadAllGroups() throws SQLException {
        ArrayList<String> groups = new ArrayList<String>();
        Connection c = this.connectionFactory.getConnection();
        Object object = null;
        try (PreparedStatement ps2 = c.prepareStatement(this.statementProcessor.apply(GROUP_SELECT_ALL));
             ResultSet rs = ps2.executeQuery();){
            while (rs.next()) {
                groups.add(rs.getString("name").toLowerCase());
            }
        }
        catch (Throwable ps2) {
            object = ps2;
            throw ps2;
        }
        finally {
            if (c != null) {
                if (object != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable ps2) {
                        ((Throwable)object).addSuppressed(ps2);
                    }
                } else {
                    c.close();
                }
            }
        }
        boolean success = true;
        for (String g2 : groups) {
            try {
                this.loadGroup(g2);
            }
            catch (Exception e) {
                e.printStackTrace();
                success = false;
            }
        }
        if (!success) {
            throw new RuntimeException("Exception occurred whilst loading a group");
        }
        GroupManager<? extends Group> gm = this.plugin.getGroupManager();
        gm.getAll().values().stream().filter(g -> !groups.contains(g.getName())).forEach(gm::unload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveGroup(Group group) throws SQLException {
        block120: {
            group.getIoLock().lock();
            try {
                PreparedStatement ps4;
                Connection c;
                Throwable throwable;
                if (group.enduringData().immutable().isEmpty()) {
                    try (Connection c2 = this.connectionFactory.getConnection();
                         PreparedStatement ps2 = c2.prepareStatement(this.statementProcessor.apply(GROUP_PERMISSIONS_DELETE));){
                        ps2.setString(1, group.getName());
                        ps2.execute();
                    }
                    return;
                }
                HashSet<NodeDataContainer> remote = new HashSet<NodeDataContainer>();
                try (Connection c3 = this.connectionFactory.getConnection();
                     PreparedStatement ps3 = c3.prepareStatement(this.statementProcessor.apply(GROUP_PERMISSIONS_SELECT));){
                    ps3.setString(1, group.getName());
                    throwable = null;
                    try (ResultSet rs = ps3.executeQuery();){
                        while (rs.next()) {
                            String permission = rs.getString("permission");
                            boolean value = rs.getBoolean("value");
                            String server = rs.getString("server");
                            String world = rs.getString("world");
                            long expiry = rs.getLong("expiry");
                            String contexts = rs.getString("contexts");
                            remote.add(this.deserializeNode(permission, value, server, world, expiry, contexts));
                        }
                    }
                    catch (Throwable permission) {
                        throwable = permission;
                        throw permission;
                    }
                }
                Set<NodeDataContainer> local = group.enduringData().immutable().values().stream().map(NodeDataContainer::fromNode).collect(Collectors.toSet());
                Map.Entry<Set<NodeDataContainer>, Set<NodeDataContainer>> diff = SqlStorage.compareSets(local, remote);
                Set<NodeDataContainer> toAdd = diff.getKey();
                Set<NodeDataContainer> toRemove = diff.getValue();
                if (!toRemove.isEmpty()) {
                    c = this.connectionFactory.getConnection();
                    throwable = null;
                    try {
                        ps4 = c.prepareStatement(this.statementProcessor.apply(GROUP_PERMISSIONS_DELETE_SPECIFIC));
                        Throwable throwable2 = null;
                        try {
                            for (NodeDataContainer nd : toRemove) {
                                ps4.setString(1, group.getName());
                                ps4.setString(2, nd.getPermission());
                                ps4.setBoolean(3, nd.getValue());
                                ps4.setString(4, nd.getServer());
                                ps4.setString(5, nd.getWorld());
                                ps4.setLong(6, nd.getExpiry());
                                ps4.setString(7, GsonProvider.normal().toJson((JsonElement)ContextSetJsonSerializer.serializeContextSet(nd.getContexts())));
                                ps4.addBatch();
                            }
                            ps4.executeBatch();
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (ps4 != null) {
                                if (throwable2 != null) {
                                    try {
                                        ps4.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                } else {
                                    ps4.close();
                                }
                            }
                        }
                    }
                    catch (Throwable ps4) {
                        throwable = ps4;
                        throw ps4;
                    }
                    finally {
                        if (c != null) {
                            if (throwable != null) {
                                try {
                                    c.close();
                                }
                                catch (Throwable ps4) {
                                    throwable.addSuppressed(ps4);
                                }
                            } else {
                                c.close();
                            }
                        }
                    }
                }
                if (toAdd.isEmpty()) break block120;
                c = this.connectionFactory.getConnection();
                throwable = null;
                try {
                    ps4 = c.prepareStatement(this.statementProcessor.apply(GROUP_PERMISSIONS_INSERT));
                    Throwable throwable5 = null;
                    try {
                        for (NodeDataContainer nd : toAdd) {
                            ps4.setString(1, group.getName());
                            ps4.setString(2, nd.getPermission());
                            ps4.setBoolean(3, nd.getValue());
                            ps4.setString(4, nd.getServer());
                            ps4.setString(5, nd.getWorld());
                            ps4.setLong(6, nd.getExpiry());
                            ps4.setString(7, GsonProvider.normal().toJson((JsonElement)ContextSetJsonSerializer.serializeContextSet(nd.getContexts())));
                            ps4.addBatch();
                        }
                        ps4.executeBatch();
                    }
                    catch (Throwable throwable6) {
                        throwable5 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (ps4 != null) {
                            if (throwable5 != null) {
                                try {
                                    ps4.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable5.addSuppressed(throwable7);
                                }
                            } else {
                                ps4.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (c != null) {
                        if (throwable != null) {
                            try {
                                c.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                        } else {
                            c.close();
                        }
                    }
                }
            }
            finally {
                group.getIoLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteGroup(Group group) throws SQLException {
        group.getIoLock().lock();
        try (Connection c = this.connectionFactory.getConnection();){
            try (PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(GROUP_PERMISSIONS_DELETE));){
                ps.setString(1, group.getName());
                ps.execute();
            }
            ps = c.prepareStatement(this.statementProcessor.apply(GROUP_DELETE));
            var5_7 = null;
            try {
                ps.setString(1, group.getName());
                ps.execute();
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (ps != null) {
                    if (var5_7 != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
        }
        finally {
            group.getIoLock().unlock();
        }
        this.plugin.getGroupManager().unload(group);
    }

    @Override
    public List<HeldPermission<String>> getGroupsWithPermission(Constraint constraint) throws SQLException {
        PreparedStatementBuilder builder = new PreparedStatementBuilder().append(GROUP_PERMISSIONS_SELECT_PERMISSION);
        constraint.appendSql(builder, "permission");
        ArrayList<HeldPermission<String>> held = new ArrayList<HeldPermission<String>>();
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = builder.build(c, this.statementProcessor);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                String holder = rs.getString("name");
                String perm = rs.getString("permission");
                boolean value = rs.getBoolean("value");
                String server = rs.getString("server");
                String world = rs.getString("world");
                long expiry = rs.getLong("expiry");
                String contexts = rs.getString("contexts");
                NodeDataContainer data = this.deserializeNode(perm, value, server, world, expiry, contexts);
                held.add(NodeHeldPermission.of(holder, data));
            }
        }
        return held;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Track createAndLoadTrack(String name) throws SQLException {
        Track track;
        block66: {
            track = (Track)this.plugin.getTrackManager().getOrMake(name);
            track.getIoLock().lock();
            try {
                boolean exists = false;
                String groups = null;
                try (Connection c = this.connectionFactory.getConnection();
                     PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(TRACK_SELECT));){
                    ps.setString(1, track.getName());
                    try (ResultSet rs = ps.executeQuery();){
                        if (rs.next()) {
                            exists = true;
                            groups = rs.getString("groups");
                        }
                    }
                }
                if (exists) {
                    track.setGroups((List)GsonProvider.normal().fromJson(groups, LIST_STRING_TYPE));
                    break block66;
                }
                String json = GsonProvider.normal().toJson(track.getGroups());
                try (Connection c = this.connectionFactory.getConnection();
                     PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(TRACK_INSERT));){
                    ps.setString(1, track.getName());
                    ps.setString(2, json);
                    ps.execute();
                }
            }
            finally {
                track.getIoLock().unlock();
            }
        }
        return track;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Track> loadTrack(String name) throws SQLException {
        Track track = (Track)this.plugin.getTrackManager().getIfLoaded(name);
        if (track != null) {
            track.getIoLock().lock();
        }
        try {
            String groups;
            block52: {
                try (Connection c = this.connectionFactory.getConnection();
                     PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(TRACK_SELECT));){
                    ps.setString(1, name);
                    try (ResultSet rs = ps.executeQuery();){
                        if (rs.next()) {
                            groups = rs.getString("groups");
                            break block52;
                        }
                        Optional<Track> optional = Optional.empty();
                        return optional;
                    }
                }
            }
            if (track == null) {
                track = (Track)this.plugin.getTrackManager().getOrMake(name);
                track.getIoLock().lock();
            }
            track.setGroups((List)GsonProvider.normal().fromJson(groups, LIST_STRING_TYPE));
            Optional<Track> optional = Optional.of(track);
            return optional;
        }
        finally {
            if (track != null) {
                track.getIoLock().unlock();
            }
        }
    }

    @Override
    public void loadAllTracks() throws SQLException {
        ArrayList<String> tracks = new ArrayList<String>();
        Connection c = this.connectionFactory.getConnection();
        Object object = null;
        try (PreparedStatement ps2 = c.prepareStatement(this.statementProcessor.apply(TRACK_SELECT_ALL));
             ResultSet rs = ps2.executeQuery();){
            while (rs.next()) {
                tracks.add(rs.getString("name").toLowerCase());
            }
        }
        catch (Throwable ps2) {
            object = ps2;
            throw ps2;
        }
        finally {
            if (c != null) {
                if (object != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable ps2) {
                        ((Throwable)object).addSuppressed(ps2);
                    }
                } else {
                    c.close();
                }
            }
        }
        boolean success = true;
        for (String t2 : tracks) {
            try {
                this.loadTrack(t2);
            }
            catch (Exception e) {
                e.printStackTrace();
                success = false;
            }
        }
        if (!success) {
            throw new RuntimeException("Exception occurred whilst loading a track");
        }
        TrackManager<? extends Track> tm = this.plugin.getTrackManager();
        tm.getAll().values().stream().filter(t -> !tracks.contains(t.getName())).forEach(tm::unload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveTrack(Track track) throws SQLException {
        track.getIoLock().lock();
        try {
            String s = GsonProvider.normal().toJson(track.getGroups());
            try (Connection c = this.connectionFactory.getConnection();
                 PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(TRACK_UPDATE));){
                ps.setString(1, s);
                ps.setString(2, track.getName());
                ps.execute();
            }
        }
        finally {
            track.getIoLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTrack(Track track) throws SQLException {
        track.getIoLock().lock();
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(TRACK_DELETE));){
            ps.setString(1, track.getName());
            ps.execute();
        }
        finally {
            track.getIoLock().unlock();
        }
        this.plugin.getTrackManager().unload(track);
    }

    @Override
    public PlayerSaveResult savePlayerData(UUID uuid, String username) throws SQLException {
        Throwable throwable;
        PreparedStatement ps3;
        Throwable throwable2;
        String oldUsername;
        block100: {
            if (!(username = username.toLowerCase()).equals(oldUsername = this.getPlayerName(uuid))) {
                try (Connection c = this.connectionFactory.getConnection();){
                    PreparedStatement ps2;
                    if (oldUsername != null) {
                        ps2 = c.prepareStatement(this.statementProcessor.apply(PLAYER_UPDATE_USERNAME_FOR_UUID));
                        throwable2 = null;
                        try {
                            ps2.setString(1, username);
                            ps2.setString(2, uuid.toString());
                            ps2.execute();
                            break block100;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (ps2 != null) {
                                if (throwable2 != null) {
                                    try {
                                        ps2.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                } else {
                                    ps2.close();
                                }
                            }
                        }
                    }
                    ps2 = c.prepareStatement(this.statementProcessor.apply(PLAYER_INSERT));
                    throwable2 = null;
                    try {
                        ps2.setString(1, uuid.toString());
                        ps2.setString(2, username);
                        ps2.setString(3, "default");
                        ps2.execute();
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (ps2 != null) {
                            if (throwable2 != null) {
                                try {
                                    ps2.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                }
                            } else {
                                ps2.close();
                            }
                        }
                    }
                }
            }
        }
        PlayerSaveResultImpl result = PlayerSaveResultImpl.determineBaseResult(username, oldUsername);
        HashSet<UUID> conflicting = new HashSet<UUID>();
        throwable2 = null;
        try (Connection c = this.connectionFactory.getConnection();){
            ps3 = c.prepareStatement(this.statementProcessor.apply(PLAYER_SELECT_ALL_UUIDS_BY_USERNAME));
            throwable = null;
            try {
                ps3.setString(1, username);
                ps3.setString(2, uuid.toString());
                try (ResultSet rs = ps3.executeQuery();){
                    while (rs.next()) {
                        conflicting.add(UUID.fromString(rs.getString("uuid")));
                    }
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            finally {
                if (ps3 != null) {
                    if (throwable != null) {
                        try {
                            ps3.close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                    } else {
                        ps3.close();
                    }
                }
            }
        }
        catch (Throwable ps3) {
            throwable2 = ps3;
            throw ps3;
        }
        if (!conflicting.isEmpty()) {
            c = this.connectionFactory.getConnection();
            throwable2 = null;
            try {
                ps3 = c.prepareStatement(this.statementProcessor.apply(PLAYER_DELETE_ALL_UUIDS_BY_USERNAME));
                throwable = null;
                try {
                    ps3.setString(1, username);
                    ps3.setString(2, uuid.toString());
                    ps3.execute();
                }
                catch (Throwable throwable9) {
                    throwable = throwable9;
                    throw throwable9;
                }
                finally {
                    if (ps3 != null) {
                        if (throwable != null) {
                            try {
                                ps3.close();
                            }
                            catch (Throwable throwable10) {
                                throwable.addSuppressed(throwable10);
                            }
                        } else {
                            ps3.close();
                        }
                    }
                }
            }
            catch (Throwable throwable11) {
                throwable2 = throwable11;
                throw throwable11;
            }
            finally {
                if (c != null) {
                    if (throwable2 != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable throwable12) {
                            throwable2.addSuppressed(throwable12);
                        }
                    } else {
                        c.close();
                    }
                }
            }
            result = result.withOtherUuidsPresent(conflicting);
        }
        return result;
    }

    @Override
    public UUID getPlayerUuid(String username) throws SQLException {
        username = username.toLowerCase();
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_SELECT_UUID_BY_USERNAME));){
            ps.setString(1, username);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    UUID uUID = UUID.fromString(rs.getString("uuid"));
                    return uUID;
                }
            }
        }
        return null;
    }

    @Override
    public String getPlayerName(UUID uuid) throws SQLException {
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_SELECT_USERNAME_BY_UUID));){
            ps.setString(1, uuid.toString());
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    String string = rs.getString("username");
                    return string;
                }
            }
        }
        return null;
    }

    private static Map.Entry<Set<NodeDataContainer>, Set<NodeDataContainer>> compareSets(Set<NodeDataContainer> local, Set<NodeDataContainer> remote) {
        HashSet<NodeDataContainer> toAdd = new HashSet<NodeDataContainer>(local);
        toAdd.removeAll(remote);
        HashSet<NodeDataContainer> toRemove = new HashSet<NodeDataContainer>(remote);
        toRemove.removeAll(local);
        return Maps.immutableEntry(toAdd, toRemove);
    }

    private NodeDataContainer deserializeNode(String permission, boolean value, String server, String world, long expiry, String contexts) {
        return NodeDataContainer.of(permission, value, server, world, expiry, ContextSetJsonSerializer.deserializeContextSet(GsonProvider.normal(), contexts).makeImmutable());
    }
}

