/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.sql.connection.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import me.lucko.luckperms.common.storage.implementation.sql.connection.ConnectionFactory;

abstract class FlatfileConnectionFactory
implements ConnectionFactory {
    protected static final DecimalFormat DF = new DecimalFormat("#.##");
    protected final Path file;

    FlatfileConnectionFactory(Path file) {
        this.file = file;
    }

    @Override
    public void init() {
    }

    protected Path getWriteFile() {
        return this.file;
    }

    @Override
    public Map<String, String> getMeta() {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        Path databaseFile = this.getWriteFile();
        if (Files.exists(databaseFile, new LinkOption[0])) {
            long length;
            try {
                length = Files.size(databaseFile);
            }
            catch (IOException e) {
                length = 0L;
            }
            double size = (double)length / 1048576.0;
            ret.put("File Size", DF.format(size) + "MB");
        } else {
            ret.put("File Size", "0MB");
        }
        return ret;
    }
}

