/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.utils;

import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import me.lucko.luckperms.lib.caffeine.cache.Caffeine;
import me.lucko.luckperms.lib.caffeine.cache.LoadingCache;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PatternCache {
    private static final LoadingCache<String, CachedPattern> CACHE = Caffeine.newBuilder().build(s -> {
        try {
            return new CachedPattern(Pattern.compile(s));
        }
        catch (PatternSyntaxException e) {
            return new CachedPattern(e);
        }
    });

    public static CachedPattern lookup(String regex) {
        CachedPattern pattern = (CachedPattern)CACHE.get((Object)regex);
        Objects.requireNonNull(pattern, "pattern");
        return pattern;
    }

    public static Pattern compile(String regex) throws PatternSyntaxException {
        CachedPattern pattern = PatternCache.lookup(regex);
        if (pattern.ex != null) {
            throw pattern.ex;
        }
        return pattern.instance;
    }

    public static Pattern compileDelimiterPattern(String delimiter, String escape) throws PatternSyntaxException {
        String pattern = "(?<!" + Pattern.quote(escape) + ")" + Pattern.quote(delimiter);
        return PatternCache.compile(pattern);
    }

    private PatternCache() {
    }

    public static final class CachedPattern {
        private final Pattern instance;
        private final PatternSyntaxException ex;

        CachedPattern(Pattern instance) {
            this.instance = instance;
            this.ex = null;
        }

        CachedPattern(PatternSyntaxException ex) {
            this.instance = null;
            this.ex = ex;
        }

        public @Nullable Pattern getPattern() {
            return this.instance;
        }

        public @Nullable PatternSyntaxException getException() {
            return this.ex;
        }
    }
}

