/*
 * Decompiled with CFR 0.152.
 */
package net.moddedminecraft.mmcreboot.commands;

import java.util.Optional;
import net.moddedminecraft.mmcreboot.Config.Config;
import net.moddedminecraft.mmcreboot.Config.Messages;
import net.moddedminecraft.mmcreboot.Main;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.text.Text;

public class RebootCMD
implements CommandExecutor {
    private final Main plugin;

    public RebootCMD(Main instance) {
        this.plugin = instance;
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        double restartTime;
        String timeValue = (String)args.getOne("h/m/s").get();
        int timeAmount = (Integer)args.getOne("time").get();
        Optional reasonOP = args.getOne("reason");
        this.plugin.reason = reasonOP.orElse(null);
        switch (timeValue) {
            case "h": {
                restartTime = timeAmount * 3600;
                break;
            }
            case "m": {
                restartTime = timeAmount * 60 + 1;
                break;
            }
            case "s": {
                restartTime = timeAmount;
                break;
            }
            default: {
                this.plugin.sendMessage(src, Messages.getRestartFormatMessage());
                src.sendMessage(Text.of());
                throw new CommandException(this.plugin.fromLegacy(Messages.getErrorInvalidTimescale()));
            }
        }
        this.plugin.logger.info("[MMCReboot] " + src.getName() + " is setting a new restart time...");
        if (this.plugin.tasksScheduled) {
            this.plugin.cancelTasks();
        }
        Config.restartInterval = restartTime / 3600.0;
        this.plugin.logger.info("[MMCReboot] scheduling restart tasks...");
        this.plugin.removeScoreboard();
        this.plugin.removeBossBar();
        this.plugin.scheduleTasks();
        this.plugin.isRestarting = true;
        if (restartTime <= 300.0 && Config.timerUseScoreboard) {
            this.plugin.displayRestart(Config.restartInterval * 3600.0);
        }
        double timeLeft = Config.restartInterval * 3600.0 - (double)(System.currentTimeMillis() - this.plugin.startTimestamp) / 1000.0;
        int hours = (int)(timeLeft / 3600.0);
        int minutes = (int)((timeLeft - (double)(hours * 3600)) / 60.0);
        int seconds = (int)timeLeft % 60;
        if (reasonOP.isPresent()) {
            this.plugin.sendMessage(src, Messages.getRestartMessageWithReason().replace("%hours%", String.valueOf(hours)).replace("%minutes%", String.valueOf(minutes)).replace("%seconds%", String.valueOf(seconds)));
            this.plugin.sendMessage(src, "&6" + this.plugin.reason);
        } else {
            this.plugin.sendMessage(src, Messages.getRestartMessageWithoutReason().replace("%hours%", String.valueOf(hours)).replace("%minutes%", String.valueOf(minutes)).replace("%seconds%", String.valueOf(seconds)));
        }
        return CommandResult.success();
    }
}

