/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.gui.backend;

import com.rwtema.extrautils2.compatibility.CompatClientHelper;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IWidgetClientTick;
import com.rwtema.extrautils2.gui.backend.IWidgetKeyInput;
import com.rwtema.extrautils2.gui.backend.IWidgetMouseInput;
import com.rwtema.extrautils2.gui.backend.WidgetBase;
import com.rwtema.extrautils2.render.IVertexBuffer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WidgetTextInput
extends WidgetBase
implements IWidgetKeyInput,
IWidgetMouseInput,
IWidgetClientTick {
    private static final int PADDING = 1;
    @Nonnull
    private String text = "";
    private int maxStringLength = 32;
    private int cursorCounter;
    private boolean canLoseFocus = true;
    private boolean isFocused;
    private int lineScrollOffset;
    private int cursorPosition;
    private int selectionEnd;

    public WidgetTextInput(int x, int y, int w, @Nonnull String text) {
        super(x, y, w, 11);
        this.text = text;
    }

    @Override
    public void updateClient() {
        ++this.cursorCounter;
    }

    @Nonnull
    public String getText() {
        return this.text;
    }

    public void setText(@Nonnull String textIn) {
        if (this.isValidText(textIn)) {
            this.text = textIn.length() > this.maxStringLength ? textIn.substring(0, this.maxStringLength) : textIn;
            this.setCursorPositionEnd();
            this.onValueChanged();
        }
    }

    public String getSelectedText() {
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        return this.text.substring(i, j);
    }

    public void writeText(String textToWrite) {
        int l;
        String s = "";
        String s1 = ChatAllowedCharacters.func_71565_a((String)textToWrite);
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        int k = this.maxStringLength - this.text.length() - (i - j);
        if (!this.text.isEmpty()) {
            s = s + this.text.substring(0, i);
        }
        if (k < s1.length()) {
            s = s + s1.substring(0, k);
            l = k;
        } else {
            s = s + s1;
            l = s1.length();
        }
        if (!this.text.isEmpty() && j < this.text.length()) {
            s = s + this.text.substring(j);
        }
        if (this.isValidText(s)) {
            this.text = s;
            this.moveCursorBy(i - this.selectionEnd + l);
            this.onValueChanged();
        }
    }

    protected void onValueChanged() {
    }

    public void deleteWords(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(num) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                boolean flag = num < 0;
                int i = flag ? this.cursorPosition + num : this.cursorPosition;
                int j = flag ? this.cursorPosition : this.cursorPosition + num;
                String s = "";
                if (i >= 0) {
                    s = this.text.substring(0, i);
                }
                if (j < this.text.length()) {
                    s = s + this.text.substring(j);
                }
                if (this.isValidText(s)) {
                    this.text = s;
                    if (flag) {
                        this.moveCursorBy(num);
                    }
                    this.onValueChanged();
                }
            }
        }
    }

    protected boolean isValidText(@Nonnull String s) {
        return true;
    }

    public int getNthWordFromCursor(int numWords) {
        return this.getNthWordFromPos(numWords, this.getCursorPosition());
    }

    public int getNthWordFromPos(int n, int pos) {
        return this.getNthWordFromPosWS(n, pos, true);
    }

    public int getNthWordFromPosWS(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipWs && i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursorBy(int num) {
        this.setCursorPosition(this.selectionEnd + num);
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text.length());
    }

    @SideOnly(value=Side.CLIENT)
    private void drawCursorVertical(int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.x + this.w) {
            endX = this.x + this.w;
        }
        if (startX > this.x + this.w) {
            startX = this.x + this.w;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        IVertexBuffer vertexbuffer = CompatClientHelper.wrap(tessellator.func_178180_c());
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179115_u();
        GlStateManager.func_187422_a((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        vertexbuffer.begin(7, DefaultVertexFormats.field_181705_e);
        vertexbuffer.pos(startX, endY, 0.0).endVertex();
        vertexbuffer.pos(endX, endY, 0.0).endVertex();
        vertexbuffer.pos(endX, startY, 0.0).endVertex();
        vertexbuffer.pos(startX, startY, 0.0).endVertex();
        tessellator.func_78381_a();
        GlStateManager.func_179134_v();
        GlStateManager.func_179098_w();
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public void setMaxStringLength(int length) {
        this.maxStringLength = length;
        if (this.text.length() > length) {
            this.text = this.text.substring(0, length);
            this.onValueChanged();
        }
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(int pos) {
        this.cursorPosition = pos;
        int i = this.text.length();
        this.cursorPosition = MathHelper.func_76125_a((int)this.cursorPosition, (int)0, (int)i);
        this.setSelectionPos(this.cursorPosition);
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public void setFocused(boolean isFocusedIn) {
        if (isFocusedIn && !this.isFocused) {
            this.cursorCounter = 0;
        }
        this.isFocused = isFocusedIn;
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public void setSelectionPos(int position) {
        int i = this.text.length();
        if (position > i) {
            position = i;
        }
        if (position < 0) {
            position = 0;
        }
        this.selectionEnd = position;
        if (this.getFontRendererInstance() != null) {
            if (this.lineScrollOffset > i) {
                this.lineScrollOffset = i;
            }
            int j = this.getW();
            String s = this.getFontRendererInstance().func_78269_a(this.text.substring(this.lineScrollOffset), j);
            int k = s.length() + this.lineScrollOffset;
            if (position == this.lineScrollOffset) {
                this.lineScrollOffset -= this.getFontRendererInstance().func_78262_a(this.text, j, true).length();
            }
            if (position > k) {
                this.lineScrollOffset += position - k;
            } else if (position <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - position;
            }
            this.lineScrollOffset = MathHelper.func_76125_a((int)this.lineScrollOffset, (int)0, (int)i);
        }
    }

    public void setCanLoseFocus(boolean canLoseFocusIn) {
        this.canLoseFocus = canLoseFocusIn;
    }

    @Override
    public boolean keyTyped(char key, int keyCode) {
        if (!this.isFocused) {
            return false;
        }
        if (GuiScreen.func_175278_g((int)keyCode)) {
            this.setCursorPositionEnd();
            this.setSelectionPos(0);
            return true;
        }
        if (GuiScreen.func_175280_f((int)keyCode)) {
            GuiScreen.func_146275_d((String)this.getSelectedText());
            return true;
        }
        if (GuiScreen.func_175279_e((int)keyCode)) {
            this.writeText(GuiScreen.func_146277_j());
            return true;
        }
        if (GuiScreen.func_175277_d((int)keyCode)) {
            GuiScreen.func_146275_d((String)this.getSelectedText());
            this.writeText("");
            return true;
        }
        boolean shiftKeyDown = GuiScreen.func_146272_n();
        boolean ctrlKeyDown = GuiScreen.func_146271_m();
        switch (keyCode) {
            case 14: {
                if (ctrlKeyDown) {
                    this.deleteWords(-1);
                } else {
                    this.deleteFromCursor(-1);
                }
                return true;
            }
            case 199: {
                if (shiftKeyDown) {
                    this.setSelectionPos(0);
                } else {
                    this.setCursorPositionZero();
                }
                return true;
            }
            case 203: {
                if (shiftKeyDown) {
                    if (ctrlKeyDown) {
                        this.setSelectionPos(this.getNthWordFromPos(-1, this.getSelectionEnd()));
                    } else {
                        this.setSelectionPos(this.getSelectionEnd() - 1);
                    }
                } else if (ctrlKeyDown) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 205: {
                if (shiftKeyDown) {
                    if (ctrlKeyDown) {
                        this.setSelectionPos(this.getNthWordFromPos(1, this.getSelectionEnd()));
                    } else {
                        this.setSelectionPos(this.getSelectionEnd() + 1);
                    }
                } else if (ctrlKeyDown) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 207: {
                if (shiftKeyDown) {
                    this.setSelectionPos(this.text.length());
                } else {
                    this.setCursorPositionEnd();
                }
                return true;
            }
            case 211: {
                if (ctrlKeyDown) {
                    this.deleteWords(1);
                } else {
                    this.deleteFromCursor(1);
                }
                return true;
            }
        }
        if (ChatAllowedCharacters.func_71566_a((char)key)) {
            this.writeText(Character.toString(key));
            return true;
        }
        return false;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton, boolean mouseOver) {
        if (this.canLoseFocus) {
            this.setFocused(mouseOver);
        }
        if (this.isFocused && mouseOver) {
            if (mouseButton == 0) {
                int i = mouseX - this.getX();
                String s = this.getFontRendererInstance().func_78269_a(this.text.substring(this.lineScrollOffset), this.getW());
                this.setCursorPosition(this.getFontRendererInstance().func_78269_a(s, --i).length() + this.lineScrollOffset);
            } else if (mouseButton == 1) {
                this.setText("");
            }
        }
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int mouseButton, boolean mouseOver) {
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY, int mouseButton, long timeSinceLastMove, boolean mouseOver) {
    }

    @Override
    public void mouseWheelScroll(int delta, boolean mouseOver) {
    }

    @Override
    public void mouseTick(int mouseX, int mouseY, boolean mouseOver) {
    }

    @Override
    public boolean usesMouseWheel() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRendererInstance() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
        int w = this.getW();
        int x1 = guiLeft + this.getX();
        gui.func_73729_b(x1, guiTop + this.getY(), 0, 102, w / 2, 11);
        gui.func_73729_b(x1 + w / 2, guiTop + this.getY(), 90 - w / 2, 102, w / 2, 11);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderForeground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
        int i = 0xE0E0E0;
        int j = this.cursorPosition - this.lineScrollOffset;
        int k = this.selectionEnd - this.lineScrollOffset;
        String s = this.getFontRendererInstance().func_78269_a(this.text.substring(this.lineScrollOffset), this.getW());
        boolean flag = j >= 0 && j <= s.length();
        boolean flag1 = this.isFocused && this.cursorCounter / 6 % 2 == 0 && flag;
        int l = this.x + 1;
        int i1 = this.y + 1;
        int j1 = l;
        if (k > s.length()) {
            k = s.length();
        }
        if (!s.isEmpty()) {
            String s1 = flag ? s.substring(0, j) : s;
            j1 = this.getFontRendererInstance().func_175063_a(s1, (float)l, (float)i1, i);
        }
        boolean flag2 = this.cursorPosition < this.text.length() || this.text.length() >= this.getMaxStringLength();
        int k1 = j1;
        if (!flag) {
            k1 = j > 0 ? l + this.w : l;
        } else if (flag2) {
            k1 = j1 - 1;
            --j1;
        }
        if (!s.isEmpty() && flag && j < s.length()) {
            j1 = this.getFontRendererInstance().func_175063_a(s.substring(j), (float)j1, (float)i1, i);
        }
        if (flag1) {
            if (flag2) {
                Gui.func_73734_a((int)k1, (int)(i1 - 1), (int)(k1 + 1), (int)(i1 + 1 + this.getFontRendererInstance().field_78288_b), (int)-3092272);
            } else {
                this.getFontRendererInstance().func_175063_a("_", (float)k1, (float)i1, i);
            }
        }
        if (k != j) {
            int l1 = l + this.getFontRendererInstance().func_78256_a(s.substring(0, k));
            this.drawCursorVertical(k1, i1 - 1, l1 - 1, i1 + 1 + this.getFontRendererInstance().field_78288_b);
        }
    }
}

