/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.handler.redstonesignal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lumien.randomthings.handler.redstonesignal.RedstoneSignal;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class RedstoneSignalHandler
extends WorldSavedData {
    public static final String ID = "RTRedstoneSignalHandler";
    List<RedstoneSignal> redstoneSignals = new ArrayList<RedstoneSignal>();

    public RedstoneSignalHandler(String name) {
        super(ID);
    }

    public RedstoneSignalHandler() {
        this(ID);
    }

    public boolean func_76188_b() {
        return true;
    }

    public static RedstoneSignalHandler getHandler() {
        World overWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_();
        RedstoneSignalHandler handler = (RedstoneSignalHandler)overWorld.func_175693_T().func_75742_a(RedstoneSignalHandler.class, ID);
        if (handler == null) {
            handler = new RedstoneSignalHandler();
            overWorld.func_175693_T().func_75745_a(ID, (WorldSavedData)handler);
        }
        return handler;
    }

    private void updatePosition(World worldObj, BlockPos pos) {
        IBlockState targetState = worldObj.func_180495_p(pos);
        targetState.func_189546_a(worldObj, pos, Blocks.field_150451_bX, pos);
        worldObj.func_175685_c(pos, Blocks.field_150451_bX, false);
    }

    public synchronized boolean addSignal(World worldObj, BlockPos pos, int duration, int strength) {
        if (worldObj.func_175667_e(pos)) {
            this.redstoneSignals.add(new RedstoneSignal(worldObj.field_73011_w.getDimension(), pos, duration, strength));
            this.updatePosition(worldObj, pos);
            return true;
        }
        return false;
    }

    public synchronized void tick() {
        Iterator<RedstoneSignal> iterator = this.redstoneSignals.iterator();
        while (iterator.hasNext()) {
            RedstoneSignal rs = iterator.next();
            WorldServer signalWorld = DimensionManager.getWorld((int)rs.getDimension());
            if (signalWorld == null || !signalWorld.func_175667_e(rs.getPosition()) || !rs.tick()) continue;
            iterator.remove();
            this.updatePosition((World)signalWorld, rs.getPosition());
        }
    }

    public synchronized int getStrongPower(World worldObj, BlockPos pos, EnumFacing facing) {
        pos = pos.func_177972_a(facing.func_176734_d());
        int dimension = worldObj.field_73011_w.getDimension();
        for (RedstoneSignal rs : this.redstoneSignals) {
            if (rs.getDimension() != dimension || !rs.getPosition().equals((Object)pos)) continue;
            return rs.getRedstoneStrength();
        }
        return 0;
    }

    public synchronized void func_76184_a(NBTTagCompound nbt) {
        NBTTagList nbtSignalList = nbt.func_150295_c("redstoneSignals", 10);
        for (int i = 0; i < nbtSignalList.func_74745_c(); ++i) {
            NBTTagCompound signalCompound = nbtSignalList.func_150305_b(i);
            RedstoneSignal rs = new RedstoneSignal();
            rs.readFromNBT(signalCompound);
            this.redstoneSignals.add(rs);
        }
    }

    public synchronized NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagList nbtSignalList = new NBTTagList();
        for (RedstoneSignal rs : this.redstoneSignals) {
            NBTTagCompound signalCompound = new NBTTagCompound();
            rs.writeToNBT(signalCompound);
            nbtSignalList.func_74742_a((NBTBase)signalCompound);
        }
        nbt.func_74782_a("redstoneSignals", (NBTBase)nbtSignalList);
        return nbt;
    }
}

