/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.text;

import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.event.ClickEvent;
import me.lucko.luckperms.lib.text.event.HoverEvent;
import me.lucko.luckperms.lib.text.format.TextColor;
import me.lucko.luckperms.lib.text.format.TextDecoration;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface BuildableComponent<C extends BuildableComponent<C, B>, B extends Builder<C, B>>
extends Component {
    public @NonNull B toBuilder();

    public static interface Builder<C extends BuildableComponent, B extends Builder<C, B>> {
        public @NonNull B append(@NonNull Component var1);

        public @NonNull B append(@NonNull Iterable<? extends Component> var1);

        default public @NonNull B apply(@NonNull Consumer<Builder<?, ?>> consumer) {
            consumer.accept(this);
            return (B)this;
        }

        public @NonNull B applyDeep(@NonNull Consumer<Builder<?, ?>> var1);

        public @NonNull B mapChildren(@NonNull Function<BuildableComponent<?, ?>, BuildableComponent<?, ?>> var1);

        public @NonNull B mapChildrenDeep(@NonNull Function<BuildableComponent<?, ?>, BuildableComponent<?, ?>> var1);

        public @NonNull B color(@Nullable TextColor var1);

        public @NonNull B colorIfAbsent(@Nullable TextColor var1);

        default public @NonNull B decorations(@NonNull Set<TextDecoration> decorations, boolean flag) {
            TextDecoration.State state = TextDecoration.State.byBoolean(flag);
            decorations.forEach(decoration -> this.decoration((TextDecoration)decoration, state));
            return (B)this;
        }

        default public @NonNull B decoration(@NonNull TextDecoration decoration, boolean flag) {
            return this.decoration(decoration, TextDecoration.State.byBoolean(flag));
        }

        public @NonNull B decoration(@NonNull TextDecoration var1, @NonNull TextDecoration.State var2);

        public @NonNull B clickEvent(@Nullable ClickEvent var1);

        public @NonNull B hoverEvent(@Nullable HoverEvent var1);

        public @NonNull B insertion(@Nullable String var1);

        default public @NonNull B mergeStyle(@NonNull Component that) {
            this.mergeColor(that);
            this.mergeDecorations(that);
            this.mergeEvents(that);
            return (B)this;
        }

        default public @NonNull B mergeColor(@NonNull Component that) {
            if (that.color() != null) {
                this.color(that.color());
            }
            return (B)this;
        }

        default public @NonNull B mergeDecorations(@NonNull Component that) {
            for (TextDecoration decoration : TextDecoration.values()) {
                TextDecoration.State state = that.decoration(decoration);
                if (state == TextDecoration.State.NOT_SET) continue;
                this.decoration(decoration, state);
            }
            return (B)this;
        }

        default public @NonNull B mergeEvents(@NonNull Component that) {
            if (that.clickEvent() != null) {
                this.clickEvent(that.clickEvent());
            }
            if (that.hoverEvent() != null) {
                this.hoverEvent(that.hoverEvent().copy());
            }
            return (B)this;
        }

        default public @NonNull B resetStyle() {
            this.color(null);
            for (TextDecoration decoration : TextDecoration.values()) {
                this.decoration(decoration, TextDecoration.State.NOT_SET);
            }
            this.clickEvent(null);
            this.hoverEvent(null);
            return (B)this;
        }

        public @NonNull C build();
    }
}

