/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.armor.modifiers;

import c4.conarm.lib.armor.ArmorCore;
import c4.conarm.lib.modifiers.ArmorModifier;
import c4.conarm.lib.utils.RecipeMatchHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.IToolMod;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolBuilder;
import slimeknights.tconstruct.tools.modifiers.ModExtraTrait;

public class ModExtraArmorTrait
extends ArmorModifier {
    private final Material material;
    public final Set<ArmorCore> armorCores;
    private final Collection<ITrait> traits;

    public ModExtraArmorTrait(Material material, Collection<ITrait> traits) {
        this(material, traits, ModExtraArmorTrait.generateIdentifier(material, traits));
    }

    public ModExtraArmorTrait(Material material, Collection<ITrait> traits, String customIdentifier) {
        super("extratrait" + customIdentifier, material.materialTextColor);
        this.material = material;
        this.armorCores = new HashSet<ArmorCore>();
        this.traits = traits;
        this.addAspects(new ModifierAspect[]{new ExtraTraitAspect(), new ModifierAspect.SingleAspect((IModifier)this), new ModifierAspect.DataAspect((IModifier)this)});
    }

    public <T extends Item> void addCombination(ArmorCore armorCore, T toolPart) {
        this.armorCores.add(armorCore);
        ItemStack toolPartItem = ((IMaterialItem)toolPart).getItemstackWithMaterial(this.material);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        stacks.add(toolPartItem);
        stacks.addAll(ModExtraTrait.EMBOSSMENT_ITEMS);
        RecipeMatchHolder.addRecipeMatch((IModifier)this, (RecipeMatch)new RecipeMatch.ItemCombination(1, stacks.toArray(new ItemStack[stacks.size()])));
    }

    public static String generateIdentifier(Material material, Collection<ITrait> traits) {
        String traitString = traits.stream().map(IToolMod::getIdentifier).sorted().collect(Collectors.joining());
        return material.getIdentifier() + traitString;
    }

    @Override
    public boolean canApplyCustom(ItemStack stack) {
        return stack.func_77973_b() instanceof ArmorCore && this.armorCores.contains(stack.func_77973_b());
    }

    public String getLocalizedName() {
        return Util.translate((String)"modifier.%s.name", (Object[])new Object[]{"extratrait"}) + " (" + this.material.getLocalizedName() + ")";
    }

    public String getLocalizedDesc() {
        return Util.translateFormatted((String)String.format("modifier.%s.desc", "extratrait"), (Object[])new Object[]{this.material.getLocalizedName()});
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        this.traits.forEach(trait -> ToolBuilder.addTrait((NBTTagCompound)rootCompound, (ITrait)trait, (int)this.color));
    }

    public boolean hasTexturePerMaterial() {
        return true;
    }

    private static class ExtraTraitAspect
    extends ModifierAspect {
        private ExtraTraitAspect() {
        }

        public boolean canApply(ItemStack stack, ItemStack original) throws TinkerGuiException {
            NBTTagList modifierList = TagUtil.getModifiersTagList((ItemStack)original);
            for (int i = 0; i < modifierList.func_74745_c(); ++i) {
                NBTTagCompound tag = modifierList.func_150305_b(i);
                ModifierNBT data = ModifierNBT.readTag((NBTTagCompound)tag);
                if (!data.identifier.startsWith("extratrait")) continue;
                throw new TinkerGuiException(Util.translate((String)"gui.error.already_has_extratrait", (Object[])new Object[0]));
            }
            return true;
        }

        public void updateNBT(NBTTagCompound root, NBTTagCompound modifierTag) {
        }
    }
}

