/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.jarrelocator;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.lucko.jarrelocator.Relocation;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

public final class JarRelocator {
    private final File input;
    private final File output;
    private final Collection<Relocation> rules;

    public JarRelocator(File input, File output, Collection<Relocation> rules) {
        this.input = input;
        this.output = output;
        this.rules = rules;
    }

    public JarRelocator(File input, File output, Map<String, String> rules) {
        this.input = input;
        this.output = output;
        this.rules = new ArrayList<Relocation>(rules.size());
        for (Map.Entry<String, String> entry : rules.entrySet()) {
            this.rules.add(new Relocation(entry.getKey(), entry.getValue()));
        }
    }

    public void run() throws IOException {
        HashSet<String> resources = new HashSet<String>();
        Relocator relocator = new Relocator(this.rules);
        try (JarOutputStream jarOut = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(this.output)));
             JarFile jarIn = new JarFile(this.input);){
            Enumeration<JarEntry> entries = jarIn.entries();
            while (true) {
                if (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (name.equals("META-INF/INDEX.LIST") || entry.isDirectory()) continue;
                    String mappedName = relocator.map(name);
                    InputStream entryIn = jarIn.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        String dir;
                        int index = mappedName.lastIndexOf(47);
                        if (index != -1 && !resources.contains(dir = mappedName.substring(0, index))) {
                            JarRelocator.addDirectory(resources, jarOut, dir);
                        }
                        if (name.endsWith(".class")) {
                            JarRelocator.addRelocatedClass(relocator, name, entryIn, jarOut);
                            continue;
                        }
                        if (resources.contains(mappedName)) {
                            return;
                        }
                        JarRelocator.addResource(resources, mappedName, entry.getTime(), entryIn, jarOut);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (entryIn == null) continue;
                        if (throwable != null) {
                            try {
                                entryIn.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        entryIn.close();
                        continue;
                    }
                }
                break;
            }
        }
    }

    private static void addDirectory(Set<String> resources, JarOutputStream jarOut, String name) throws IOException {
        String parent;
        if (name.lastIndexOf(47) > 0 && !resources.contains(parent = name.substring(0, name.lastIndexOf(47)))) {
            JarRelocator.addDirectory(resources, jarOut, parent);
        }
        JarEntry entry = new JarEntry(name + "/");
        jarOut.putNextEntry(entry);
        resources.add(name);
    }

    private static void addResource(Set<String> resources, String name, long lastModified, InputStream entryIn, JarOutputStream jarOut) throws IOException {
        JarEntry jarEntry = new JarEntry(name);
        jarEntry.setTime(lastModified);
        jarOut.putNextEntry(jarEntry);
        JarRelocator.copy(entryIn, jarOut);
        resources.add(name);
    }

    private static void addRelocatedClass(Relocator relocator, String name, InputStream entryIn, JarOutputStream jarOut) throws IOException {
        ClassReader classReader = new ClassReader(entryIn);
        ClassWriter classWriter = new ClassWriter(0);
        RelocatingClassVisitor classVisitor = new RelocatingClassVisitor(classWriter, relocator, name);
        try {
            classReader.accept((ClassVisitor)classVisitor, 8);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error processing class " + name, e);
        }
        byte[] renamedClass = classWriter.toByteArray();
        String mappedName = relocator.map(name.substring(0, name.indexOf(46)));
        jarOut.putNextEntry(new JarEntry(mappedName + ".class"));
        jarOut.write(renamedClass);
    }

    private static void copy(InputStream from, OutputStream to) throws IOException {
        int n;
        byte[] buf = new byte[8192];
        while ((n = from.read(buf)) != -1) {
            to.write(buf, 0, n);
        }
    }

    private static class Relocator
    extends Remapper {
        private static final Pattern CLASS_PATTERN = Pattern.compile("(\\[*)?L(.+);");
        private final Collection<Relocation> rules;

        private Relocator(Collection<Relocation> rules) {
            this.rules = rules;
        }

        public Object mapValue(Object object) {
            if (object instanceof String) {
                String name;
                String value = name = (String)object;
                String prefix = "";
                String suffix = "";
                Matcher m = CLASS_PATTERN.matcher(name);
                if (m.matches()) {
                    prefix = m.group(1) + "L";
                    suffix = ";";
                    name = m.group(2);
                }
                for (Relocation r : this.rules) {
                    if (r.canRelocateClass(name)) {
                        value = prefix + r.relocateClass(name) + suffix;
                        break;
                    }
                    if (!r.canRelocatePath(name)) continue;
                    value = prefix + r.relocatePath(name) + suffix;
                    break;
                }
                return value;
            }
            return super.mapValue(object);
        }

        public String map(String name) {
            String value = name;
            String prefix = "";
            String suffix = "";
            Matcher m = CLASS_PATTERN.matcher(name);
            if (m.matches()) {
                prefix = m.group(1) + "L";
                suffix = ";";
                name = m.group(2);
            }
            for (Relocation r : this.rules) {
                if (!r.canRelocatePath(name)) continue;
                value = prefix + r.relocatePath(name) + suffix;
                break;
            }
            return value;
        }
    }

    private static final class RelocatingClassVisitor
    extends ClassRemapper {
        private final String pkg;

        private RelocatingClassVisitor(ClassWriter writer, Remapper remapper, String name) {
            super((ClassVisitor)writer, remapper);
            this.pkg = name.substring(0, name.lastIndexOf(47) + 1);
        }

        public void visitSource(String source, String debug) {
            if (source == null) {
                super.visitSource(null, debug);
            } else {
                String fqSource = this.pkg + source;
                String mappedSource = this.remapper.map(fqSource);
                String filename = mappedSource.substring(mappedSource.lastIndexOf(47) + 1);
                super.visitSource(filename, debug);
            }
        }
    }
}

