/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraftforge.common.config.Configuration;
import org.squiddev.plethora.core.ConfigCore;

public final class ConfigCoreForgeLoader {
    private static Configuration configuration;

    public static void doSync() {
        Configuration config = configuration;
        ConfigCore.CostSystem.initial = config.get("costsystem", "initial", 100.0, "The energy level all systems start at").setRequiresWorldRestart(true).setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.costsystem.initial").getDouble();
        ConfigCore.CostSystem.regen = config.get("costsystem", "regen", 10.0, "The amount of energy regenerated each tick").setRequiresWorldRestart(true).setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.costsystem.regen").getDouble();
        ConfigCore.CostSystem.limit = config.get("costsystem", "limit", 100.0, "The maximum energy level an item can have").setRequiresWorldRestart(true).setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.costsystem.limit").getDouble();
        ConfigCore.CostSystem.allowNegative = config.get("costsystem", "allowNegative", false, "Allow costs to go into the negative.\n Methods will fail when there is negative energy.\n This allows you to use costs higher than the allocated\n buffer and so have a more traditional rate-limiting system.").setRequiresWorldRestart(true).setLanguageKey("gui.config.plethora.costsystem.allowNegative").getBoolean();
        ConfigCore.CostSystem.awaitRegen = config.get("costsystem", "awaitRegen", true, "Wait for the system to get sufficient energy instead of throwing\n an error.").setRequiresWorldRestart(true).setLanguageKey("gui.config.plethora.costsystem.awaitRegen").getBoolean();
        config.getCategory("costsystem").setLanguageKey("gui.config.plethora.costsystem").setComment("Some methods have a particular cost: they\n consume a set amount of energy from their owner.\n This level regenerates over time.\n\n *Note:* These values only apply to the default handler.\n Other mods may add custom handlers.");
        String[] org_squiddev_plethora_core_ConfigCore_Blacklist_blacklistProviders = config.get("blacklist", "blacklistProviders", new String[0], "List of provider classes, packages or methods which are blacklisted.\n This will blacklist all converters, methods and transfer and meta providers\n matching a pattern.\n\n This only applies to classes registered through annotations and does not blacklist\n method builders.\n\n Valid forms:\n - \"foo.bar\" - All classes in package (note trailing period).\n - \"foo.bar.Provider\" - This class, all its members and nested classes\n - \"foo.bar.Provider#method\" - A particular method with a name").setRequiresWorldRestart(true).setRequiresMcRestart(true).setLanguageKey("gui.config.plethora.blacklist.blacklistProviders").getStringList();
        ConfigCore.Blacklist.blacklistProviders = new ArrayList();
        for (String var : org_squiddev_plethora_core_ConfigCore_Blacklist_blacklistProviders) {
            ConfigCore.Blacklist.blacklistProviders.add(var);
        }
        String[] org_squiddev_plethora_core_ConfigCore_Blacklist_blacklistTileEntities = config.get("blacklist", "blacklistTileEntities", new String[0], "List of tile entity classes or packages which will not be wrapped\n as peripherals. For example use \"net.minecraft.\" to disable wrapping\n any vanilla peripheral. This does not blacklist subclasses.").setRequiresWorldRestart(true).setRequiresMcRestart(true).setLanguageKey("gui.config.plethora.blacklist.blacklistTileEntities").getStringList();
        ConfigCore.Blacklist.blacklistTileEntities = new ArrayList();
        for (String var : org_squiddev_plethora_core_ConfigCore_Blacklist_blacklistTileEntities) {
            ConfigCore.Blacklist.blacklistTileEntities.add(var);
        }
        String[] org_squiddev_plethora_core_ConfigCore_Blacklist_blacklistMods = config.get("blacklist", "blacklistMods", new String[0], "List of mods to block.\n IMPORTANT: This does not block wrapping a mod's peripherals, just disables\n custom mod specific integration.").setRequiresWorldRestart(true).setRequiresMcRestart(true).setLanguageKey("gui.config.plethora.blacklist.blacklistMods").getStringList();
        ConfigCore.Blacklist.blacklistMods = new HashSet();
        for (String var : org_squiddev_plethora_core_ConfigCore_Blacklist_blacklistMods) {
            ConfigCore.Blacklist.blacklistMods.add(var);
        }
        String[] org_squiddev_plethora_core_ConfigCore_Blacklist_blacklistModules = config.get("blacklist", "blacklistModules", new String[0], "List of modules to blacklist.").setLanguageKey("gui.config.plethora.blacklist.blacklistModules").getStringList();
        ConfigCore.Blacklist.blacklistModules = new HashSet();
        for (String var : org_squiddev_plethora_core_ConfigCore_Blacklist_blacklistModules) {
            ConfigCore.Blacklist.blacklistModules.add(var);
        }
        String[] org_squiddev_plethora_core_ConfigCore_Blacklist_blacklistModulesTurtle = config.get("blacklist", "blacklistModulesTurtle", new String[0], "List of modules to blacklist from being mounted on a turtle.\n\n This includes all blacklisted modules.").setLanguageKey("gui.config.plethora.blacklist.blacklistModulesTurtle").getStringList();
        ConfigCore.Blacklist.blacklistModulesTurtle = new HashSet();
        for (String var : org_squiddev_plethora_core_ConfigCore_Blacklist_blacklistModulesTurtle) {
            ConfigCore.Blacklist.blacklistModulesTurtle.add(var);
        }
        String[] org_squiddev_plethora_core_ConfigCore_Blacklist_blacklistModulesPocket = config.get("blacklist", "blacklistModulesPocket", new String[0], "List of modules to blacklist from being mounted on a pocket computer.\n\n This includes all blacklisted modules.").setLanguageKey("gui.config.plethora.blacklist.blacklistModulesPocket").getStringList();
        ConfigCore.Blacklist.blacklistModulesPocket = new HashSet();
        for (String var : org_squiddev_plethora_core_ConfigCore_Blacklist_blacklistModulesPocket) {
            ConfigCore.Blacklist.blacklistModulesPocket.add(var);
        }
        String[] org_squiddev_plethora_core_ConfigCore_Blacklist_blacklistModulesVehicle = config.get("blacklist", "blacklistModulesVehicle", new String[0], "List of modules to blacklist from being mounted on a minecart or other vehicle.\n\n This includes all blacklisted modules.").setLanguageKey("gui.config.plethora.blacklist.blacklistModulesVehicle").getStringList();
        ConfigCore.Blacklist.blacklistModulesVehicle = new HashSet();
        for (String var : org_squiddev_plethora_core_ConfigCore_Blacklist_blacklistModulesVehicle) {
            ConfigCore.Blacklist.blacklistModulesVehicle.add(var);
        }
        String[] org_squiddev_plethora_core_ConfigCore_Blacklist_blacklistModulesTile = config.get("blacklist", "blacklistModulesTile", new String[0], "List of modules to blacklist from being mounted from a tile.\n\n For instance, the note block tile exposes the minecraft:noteblock module, allowing\n you to use that module from the tile's peripheral, rather than through a manipulator.\n\n This includes all blacklisted modules.").setLanguageKey("gui.config.plethora.blacklist.blacklistModulesTile").getStringList();
        ConfigCore.Blacklist.blacklistModulesTile = new HashSet();
        for (String var : org_squiddev_plethora_core_ConfigCore_Blacklist_blacklistModulesTile) {
            ConfigCore.Blacklist.blacklistModulesTile.add(var);
        }
        config.getCategory("blacklist").setLanguageKey("gui.config.plethora.blacklist").setComment("Blacklist various providers");
        ConfigCore.Testing.strict = config.get("testing", "strict", false, "Enable strict loading mode. This will ensure non-lazy\n loading of methods, and crash when an error is encountered\n rather than just logging.").setRequiresWorldRestart(true).setRequiresMcRestart(true).setLanguageKey("gui.config.plethora.testing.strict").getBoolean();
        ConfigCore.Testing.bytecodeVerify = config.get("testing", "bytecodeVerify", false, "Verify generated bytecode for generated methods.\n Only needed if you're developing new method builders.").setLanguageKey("gui.config.plethora.testing.bytecodeVerify").getBoolean();
        config.getCategory("testing").setLanguageKey("gui.config.plethora.testing").setComment("Various options for debugging and testing this mod");
        config.getCategory("basecosts").setLanguageKey("gui.config.plethora.basecosts").setComment("The base costs for all methods.");
    }

    public static void init(File file) {
        configuration = new Configuration(file);
        configuration.load();
        ConfigCoreForgeLoader.sync();
    }

    public static void init(Configuration config) {
        configuration = config;
        ConfigCoreForgeLoader.sync();
    }

    public static void sync() {
        ConfigCoreForgeLoader.doSync();
        configuration.save();
    }

    public static Configuration getConfiguration() {
        return configuration;
    }
}

