/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.squiddev.plethora.api.EntityWorldLocation;
import org.squiddev.plethora.api.IAttachable;
import org.squiddev.plethora.api.IPlayerOwnable;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.method.IContextBuilder;
import org.squiddev.plethora.api.method.IContextFactory;
import org.squiddev.plethora.api.method.IMethod;
import org.squiddev.plethora.api.module.IModuleAccess;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.api.module.IModuleHandler;
import org.squiddev.plethora.api.module.SingletonModuleContainer;
import org.squiddev.plethora.api.reference.ConstantReference;
import org.squiddev.plethora.api.reference.IReference;
import org.squiddev.plethora.core.AttachableWrapperPeripheral;
import org.squiddev.plethora.core.ConfigCore;
import org.squiddev.plethora.core.Context;
import org.squiddev.plethora.core.ContextFactory;
import org.squiddev.plethora.core.MethodRegistry;
import org.squiddev.plethora.core.UnbakedContext;
import org.squiddev.plethora.core.capabilities.DefaultCostHandler;
import org.squiddev.plethora.core.executor.TaskRunner;
import org.squiddev.plethora.utils.PlayerHelpers;

class PocketUpgradeModule
implements IPocketUpgrade {
    private final IModuleHandler handler;
    private final ItemStack stack;
    private final String adjective;

    PocketUpgradeModule(@Nonnull ItemStack stack, @Nonnull IModuleHandler handler, @Nonnull String adjective) {
        this.handler = handler;
        this.stack = stack;
        this.adjective = adjective;
    }

    @Nonnull
    public ResourceLocation getUpgradeID() {
        return this.handler.getModule();
    }

    @Nonnull
    public String getUnlocalisedAdjective() {
        return this.adjective;
    }

    @Nonnull
    public ItemStack getCraftingItem() {
        return this.stack;
    }

    public IPeripheral createPeripheral(final @Nonnull IPocketAccess pocket) {
        ResourceLocation thisModule = this.handler.getModule();
        String moduleName = thisModule.toString();
        if (ConfigCore.Blacklist.blacklistModulesPocket.contains(moduleName) || ConfigCore.Blacklist.blacklistModules.contains(moduleName)) {
            return null;
        }
        MethodRegistry registry = MethodRegistry.instance;
        final Entity entity = pocket.getValidEntity();
        PocketModuleAccess access = new PocketModuleAccess(pocket, this.handler);
        final IModuleContainer container = access.getContainer();
        ConstantReference<IModuleContainer> containerRef = new ConstantReference<IModuleContainer>(){

            @Override
            @Nonnull
            public IModuleContainer get() throws LuaException {
                if (!pocket.getUpgrades().containsKey(PocketUpgradeModule.this.getUpgradeID())) {
                    throw new LuaException("The upgrade is gone");
                }
                return container;
            }

            @Override
            @Nonnull
            public IModuleContainer safeGet() throws LuaException {
                return this.get();
            }
        };
        LastEntityLocation location = new LastEntityLocation(pocket);
        IContextFactory factory = ((ContextFactory)((ContextFactory)((ContextFactory)((ContextFactory)ContextFactory.of(container, containerRef).withCostHandler(DefaultCostHandler.get(pocket))).withModules(container, containerRef)).addContext("origin", new PocketPlayerOwnable(access))).addContext("origin", location)).addContext("origin", entity, (IReference)new ConstantReference<Entity>(){

            @Override
            @Nonnull
            public Entity get() throws LuaException {
                Entity accessEntity = pocket.getValidEntity();
                if (accessEntity != entity || accessEntity == null) {
                    throw new LuaException("Entity has changed");
                }
                return accessEntity;
            }

            @Override
            @Nonnull
            public Entity safeGet() throws LuaException {
                return this.get();
            }
        });
        this.handler.getAdditionalContext(access, (IContextBuilder)((Object)factory));
        Pair<List<IMethod<?>>, List<UnbakedContext<?>>> paired = registry.getMethodsPaired((Context<?>)((ContextFactory)factory).getBaked());
        return ((List)paired.getLeft()).isEmpty() ? null : new PocketPeripheral(this, access, paired, ((ContextFactory)factory).getAttachments());
    }

    public void update(@Nonnull IPocketAccess access, IPeripheral peripheral) {
        if (peripheral instanceof PocketPeripheral) {
            PocketPeripheral methodWrapper = (PocketPeripheral)peripheral;
            if (methodWrapper.getEntity() != access.getValidEntity()) {
                access.invalidatePeripheral();
            }
            methodWrapper.getRunner().func_73660_a();
        }
    }

    public boolean onRightClick(@Nonnull World world, @Nonnull IPocketAccess access, IPeripheral peripheral) {
        return false;
    }

    private static class LastEntityLocation
    implements IWorldLocation {
        private final IPocketAccess pocket;
        private Entity lastEntity;

        LastEntityLocation(IPocketAccess pocket) {
            this.pocket = pocket;
            this.lastEntity = pocket.getValidEntity();
        }

        @Override
        @Nonnull
        public World getWorld() {
            return this.lastEntity.func_130014_f_();
        }

        @Override
        @Nonnull
        public BlockPos getPos() {
            return this.lastEntity.func_180425_c();
        }

        @Override
        @Nonnull
        public Vec3d getLoc() {
            return this.lastEntity.func_174791_d();
        }

        @Override
        @Nonnull
        public AxisAlignedBB getBounds() {
            AxisAlignedBB bounds = this.lastEntity.func_70046_E();
            return bounds == null ? this.lastEntity.func_174813_aQ() : bounds;
        }

        @Override
        @Nonnull
        public IWorldLocation get() throws LuaException {
            Entity entity = this.pocket.getValidEntity();
            if (entity == null) {
                throw new LuaException("Entity is not there");
            }
            this.lastEntity = entity;
            return this;
        }

        @Override
        @Nonnull
        public IWorldLocation safeGet() {
            return this;
        }

        @Override
        public boolean isConstant() {
            return true;
        }
    }

    public static class PocketPlayerOwnable
    implements ConstantReference<PocketPlayerOwnable>,
    IPlayerOwnable {
        private final PocketModuleAccess access;

        public PocketPlayerOwnable(PocketModuleAccess access) {
            this.access = access;
        }

        @Override
        @Nullable
        public GameProfile getOwningProfile() {
            return PlayerHelpers.getProfile(this.access.getOwner());
        }

        @Override
        @Nonnull
        public PocketPlayerOwnable get() {
            return this;
        }

        @Override
        @Nonnull
        public PocketPlayerOwnable safeGet() {
            return this;
        }
    }

    private static final class PocketModuleAccess
    implements IModuleAccess {
        private AttachableWrapperPeripheral wrapper;
        private final IPocketAccess access;
        private final Entity entity;
        private final IWorldLocation location;
        private final IModuleContainer container;

        private PocketModuleAccess(IPocketAccess access, IModuleHandler handler) {
            this.entity = access.getValidEntity();
            this.location = new EntityWorldLocation(this.entity);
            this.access = access;
            this.container = new SingletonModuleContainer(handler.getModule());
        }

        @Nonnull
        public Entity getOwner() {
            return this.entity;
        }

        @Override
        @Nonnull
        public IWorldLocation getLocation() {
            return this.location;
        }

        @Override
        @Nonnull
        public IModuleContainer getContainer() {
            return this.container;
        }

        @Override
        @Nonnull
        public NBTTagCompound getData() {
            return this.access.getUpgradeNBTData();
        }

        @Override
        public void markDataDirty() {
            this.access.updateUpgradeNBTData();
        }

        @Override
        public void queueEvent(@Nonnull String event, Object ... args) {
            if (this.wrapper != null) {
                this.wrapper.queueEvent(event, args);
            }
        }
    }

    private static final class PocketPeripheral
    extends AttachableWrapperPeripheral {
        private final Entity entity;

        public PocketPeripheral(PocketUpgradeModule owner, PocketModuleAccess access, Pair<List<IMethod<?>>, List<UnbakedContext<?>>> methods, List<IAttachable> attachments) {
            super(owner.getUpgradeID().toString(), (Object)owner, methods, new TaskRunner(), attachments);
            this.entity = access.entity;
            access.wrapper = this;
        }

        public Entity getEntity() {
            return this.entity;
        }

        @Override
        public boolean equals(IPeripheral other) {
            return super.equals(other) && other instanceof PocketPeripheral && this.entity == ((PocketPeripheral)other).entity;
        }
    }
}

