/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.glasses;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import org.squiddev.plethora.api.IAttachable;
import org.squiddev.plethora.api.module.IModuleAccess;
import org.squiddev.plethora.api.reference.ConstantReference;
import org.squiddev.plethora.api.reference.IReference;
import org.squiddev.plethora.gameplay.modules.glasses.BaseObject;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasHandler;
import org.squiddev.plethora.gameplay.modules.glasses.MessageCanvasAdd;
import org.squiddev.plethora.gameplay.modules.glasses.MessageCanvasRemove;
import org.squiddev.plethora.gameplay.modules.glasses.MessageCanvasUpdate;
import org.squiddev.plethora.gameplay.modules.glasses.objects.ObjectGroup;

public final class CanvasServer
implements ConstantReference<CanvasServer>,
IAttachable {
    private final int canvasId;
    private final IModuleAccess access;
    private final EntityPlayerMP player;
    private final Int2ObjectMap<BaseObject> objects = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<IntSet> childrenOf = new Int2ObjectOpenHashMap();
    private final IntSet removed = new IntOpenHashSet();
    private final AtomicInteger lastId = new AtomicInteger(1);
    private final ObjectGroup.Frame2D group2D = () -> 0;
    private final ObjectGroup.Origin3D origin3D = () -> 1;

    public CanvasServer(@Nonnull IModuleAccess access, @Nonnull EntityPlayerMP player) {
        this.canvasId = CanvasHandler.nextId();
        this.access = access;
        this.player = player;
        this.childrenOf.put(0, (Object)new IntOpenHashSet());
        this.childrenOf.put(1, (Object)new IntOpenHashSet());
    }

    @Override
    public void attach() {
        this.access.getData().func_74768_a("id", this.canvasId);
        this.access.markDataDirty();
        CanvasHandler.addServer(this);
    }

    @Override
    public void detach() {
        CanvasHandler.removeServer(this);
        this.access.getData().func_82580_o("id");
        this.access.markDataDirty();
    }

    public int newObjectId() {
        return this.lastId.incrementAndGet();
    }

    public ObjectGroup.Frame2D canvas2d() {
        return this.group2D;
    }

    public ObjectGroup.Origin3D canvas3d() {
        return this.origin3D;
    }

    @Nonnull
    synchronized MessageCanvasAdd getAddMessage() {
        return new MessageCanvasAdd(this.canvasId, (BaseObject[])this.objects.values().toArray((Object[])new BaseObject[this.objects.size()]));
    }

    @Nonnull
    MessageCanvasRemove getRemoveMessage() {
        return new MessageCanvasRemove(this.canvasId);
    }

    @Nullable
    synchronized MessageCanvasUpdate getUpdateMessage() {
        List<BaseObject> changed = null;
        for (BaseObject object : this.objects.values()) {
            if (!object.pollDirty()) continue;
            if (changed == null) {
                changed = new ArrayList();
            }
            changed.add(object);
        }
        if (changed == null && this.removed.isEmpty()) {
            return null;
        }
        if (changed == null) {
            changed = Collections.emptyList();
        }
        MessageCanvasUpdate message = new MessageCanvasUpdate(this.canvasId, changed, this.removed.toIntArray());
        this.removed.clear();
        return message;
    }

    public synchronized void add(@Nonnull BaseObject object) {
        IntSet parent = (IntSet)this.childrenOf.get(object.parent());
        if (parent == null) {
            throw new IllegalArgumentException("No such parent");
        }
        if (this.objects.put(object.id(), (Object)object) != null) {
            throw new IllegalStateException("An object already exists with that key");
        }
        parent.add(object.id());
        if (object instanceof ObjectGroup) {
            this.childrenOf.put(object.id(), (Object)new IntOpenHashSet());
        }
    }

    public synchronized void remove(BaseObject object) {
        if (!this.removeImpl(object.id())) {
            throw new IllegalStateException("No such object with this key");
        }
    }

    public synchronized BaseObject getObject(int id) {
        return (BaseObject)this.objects.get(id);
    }

    public synchronized void clear(ObjectGroup object) {
        IntSet children = (IntSet)this.childrenOf.get(object.id());
        if (children == null) {
            throw new IllegalStateException("Object has no children");
        }
        this.clearImpl(children);
    }

    private boolean removeImpl(int id) {
        if (this.objects.remove(id) == null) {
            return false;
        }
        IntSet children = (IntSet)this.childrenOf.remove(id);
        if (children != null) {
            this.clearImpl(children);
        }
        this.removed.add(id);
        return true;
    }

    private void clearImpl(IntSet objects) {
        IntIterator iterator = objects.iterator();
        while (iterator.hasNext()) {
            int childId = iterator.nextInt();
            this.removeImpl(childId);
            iterator.remove();
        }
    }

    @Nonnull
    public EntityPlayerMP getPlayer() {
        return this.player;
    }

    @Override
    @Nonnull
    public CanvasServer get() {
        return this;
    }

    @Override
    @Nonnull
    public CanvasServer safeGet() {
        return this;
    }

    public <T extends BaseObject> IReference<T> reference(T baseObject) {
        return new BaseObject.BaseObjectReference(this, baseObject);
    }
}

