/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.glasses.objects.object2d;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasClient;
import org.squiddev.plethora.gameplay.modules.glasses.objects.ColourableObject;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object2d.MultiPoint2D;
import org.squiddev.plethora.utils.ByteBufUtils;
import org.squiddev.plethora.utils.Vec2d;

public class Triangle
extends ColourableObject
implements MultiPoint2D {
    private final Vec2d[] points = new Vec2d[3];

    public Triangle(int id, int parent) {
        super(id, parent, (byte)4);
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = Vec2d.ZERO;
        }
    }

    @Override
    @Nonnull
    public Vec2d getPoint(int idx) {
        return this.points[idx];
    }

    @Override
    public void setVertex(int idx, @Nonnull Vec2d point) {
        if (!Objects.equal((Object)this.points[idx], (Object)point)) {
            this.points[idx] = point;
            this.setDirty();
        }
    }

    @Override
    public int getVertices() {
        return 3;
    }

    @Override
    public void writeInitial(ByteBuf buf) {
        super.writeInitial(buf);
        for (Vec2d point : this.points) {
            ByteBufUtils.writeVec2d(buf, point);
        }
    }

    @Override
    public void readInitial(ByteBuf buf) {
        super.readInitial(buf);
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = ByteBufUtils.readVec2d(buf);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(CanvasClient canvas) {
        Triangle.setupFlat();
        int red = this.getRed();
        int green = this.getGreen();
        int blue = this.getBlue();
        int alpha = this.getAlpha();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(4, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(this.points[0].x, this.points[0].y, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(this.points[1].x, this.points[1].y, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(this.points[2].x, this.points[2].y, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
    }
}

