/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.glasses.objects.object3d;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.api.method.MethodResult;
import org.squiddev.plethora.api.method.wrapper.FromTarget;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasClient;
import org.squiddev.plethora.gameplay.modules.glasses.objects.ColourableObject;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object3d.DepthTestable;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object3d.Positionable3D;
import org.squiddev.plethora.utils.ByteBufUtils;

public class Box
extends ColourableObject
implements Positionable3D,
DepthTestable {
    private Vec3d position;
    private double width;
    private double height;
    private double depth;
    private boolean depthTest = true;

    public Box(int id, int parent) {
        super(id, parent, (byte)11);
    }

    @Override
    public boolean hasDepthTest() {
        return this.depthTest;
    }

    @Override
    public void setDepthTest(boolean depthTest) {
        if (this.depthTest != depthTest) {
            this.depthTest = depthTest;
            this.setDirty();
        }
    }

    @Override
    @Nonnull
    public Vec3d getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(@Nonnull Vec3d position) {
        if (!Objects.equal((Object)this.position, (Object)position)) {
            this.position = position;
            this.setDirty();
        }
    }

    public void setSize(double width, double height, double depth) {
        if (this.width != width || this.height != height || this.depth != depth) {
            this.width = width;
            this.height = height;
            this.depth = depth;
            this.setDirty();
        }
    }

    @Override
    public void readInitial(ByteBuf buf) {
        super.readInitial(buf);
        this.position = ByteBufUtils.readVec3d(buf);
        this.width = buf.readFloat();
        this.height = buf.readFloat();
        this.depth = buf.readFloat();
        this.depthTest = buf.readBoolean();
    }

    @Override
    public void writeInitial(ByteBuf buf) {
        super.writeInitial(buf);
        ByteBufUtils.writeVec3d(buf, this.position);
        buf.writeFloat((float)this.width);
        buf.writeFloat((float)this.height);
        buf.writeFloat((float)this.depth);
        buf.writeBoolean(this.depthTest);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(CanvasClient canvas) {
        Box.setupFlat();
        if (this.depthTest) {
            GlStateManager.func_179126_j();
        } else {
            GlStateManager.func_179097_i();
        }
        double minX = this.position.field_72450_a;
        double minY = this.position.field_72448_b;
        double minZ = this.position.field_72449_c;
        double maxX = minX + this.width;
        double maxY = minY + this.height;
        double maxZ = minZ + this.depth;
        int red = this.getRed();
        int green = this.getGreen();
        int blue = this.getBlue();
        int alpha = this.getAlpha();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(minX, minY, minZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, minY, minZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, minY, minZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181669_b(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
    }

    @PlethoraMethod(doc="function():number, number, number -- Get the size of this box.", worldThread=false)
    public static MethodResult getSize(@FromTarget Box rect) {
        return MethodResult.result(rect.width, rect.height, rect.depth);
    }

    @PlethoraMethod(doc="function(width:number, height:number, depth:number) -- Set the size of this box.", worldThread=false)
    public static void setSize(@FromTarget Box rect, float width, float height, float depth) {
        rect.setSize(width, height, depth);
    }
}

