/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.computercraft;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPeripheral;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.squiddev.plethora.api.IPeripheralHandler;
import org.squiddev.plethora.api.vehicle.IVehicleAccess;
import org.squiddev.plethora.api.vehicle.IVehicleUpgradeHandler;
import org.squiddev.plethora.gameplay.client.RenderHelpers;

public class SpeakerPeripheralBase
extends SpeakerPeripheral {
    private World world;
    private Vec3d position;

    public void update(@Nonnull World world, @Nonnull Vec3d position) {
        this.update();
        this.position = position;
        this.world = world;
    }

    public World getWorld() {
        return this.world;
    }

    @Deprecated
    public BlockPos getPos() {
        return new BlockPos(this.position);
    }

    public Vec3d getPosition() {
        return this.position;
    }

    public boolean equals(IPeripheral other) {
        return other != null && ((Object)((Object)this)).getClass() == other.getClass();
    }

    public static final class VehicleUpgradeHandler
    extends SpeakerPeripheralBase
    implements IVehicleUpgradeHandler {
        private final ItemStack stack;

        VehicleUpgradeHandler(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public boolean equals(IPeripheral other) {
            return this == other || other instanceof VehicleUpgradeHandler && this.stack == ((VehicleUpgradeHandler)other).stack;
        }

        @Override
        public void update(@Nonnull IVehicleAccess vehicle, @Nonnull IPeripheral peripheral) {
            Entity entity = vehicle.getVehicle();
            this.update(entity.func_130014_f_(), entity.func_174791_d());
        }

        @Override
        public IPeripheral create(@Nonnull IVehicleAccess vehicle) {
            return this;
        }

        @Override
        @Nonnull
        @SideOnly(value=Side.CLIENT)
        public Pair<IBakedModel, Matrix4f> getModel(@Nonnull IVehicleAccess access) {
            return Pair.of((Object)RenderHelpers.getMesher().func_178089_a(this.stack), (Object)new Matrix4f(0.6f, 0.0f, 0.0f, 0.0f, 0.0f, -0.6f, 0.0f, 0.0f, 0.0f, 0.0f, -0.6f, -0.46875f, 0.0f, 0.0f, 0.0f, 1.0f));
        }
    }

    public static final class PeripheralHandler
    extends SpeakerPeripheralBase
    implements IPeripheralHandler {
        private final ItemStack stack;

        PeripheralHandler(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public boolean equals(IPeripheral other) {
            return this == other || other instanceof PeripheralHandler && this.stack == ((PeripheralHandler)other).stack;
        }

        @Override
        @Nonnull
        public IPeripheral getPeripheral() {
            return this;
        }

        @Override
        public void update(@Nonnull World world, @Nonnull Vec3d position, @Nullable EntityLivingBase entity) {
            this.update(world, position);
        }
    }
}

