/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.forestry;

import forestry.api.apiculture.IBee;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.apiculture.genetics.BeeDefinition;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.BaseMetaProvider;
import org.squiddev.plethora.api.method.IPartialContext;

@Injects(value="forestry")
public final class MetaIndividual
extends BaseMetaProvider<IIndividual> {
    @Override
    @Nonnull
    public Map<String, ?> getMeta(@Nonnull IPartialContext<IIndividual> context) {
        IIndividual individual = context.getTarget();
        HashMap<String, Object> out = new HashMap<String, Object>();
        out.put("id", individual.getIdent());
        out.put("analyzed", individual.isAnalyzed());
        if (individual.isAnalyzed()) {
            out.put("genome", context.makePartialChild(individual.getGenome()).getMeta());
            HashMap<String, Boolean> pureBred = new HashMap<String, Boolean>();
            for (IChromosomeType type : individual.getGenome().getSpeciesRoot().getKaryotype()) {
                pureBred.put(type.getName().toLowerCase(Locale.ENGLISH), individual.isPureBred(type));
            }
            out.put("pureBred", pureBred);
        }
        return out;
    }

    @Override
    @Nonnull
    public IIndividual getExample() {
        IBee individual = BeeDefinition.FOREST.getIndividual();
        individual.analyze();
        return individual;
    }
}

