/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla.method;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.ArgumentHelper;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.IUnbakedContext;
import org.squiddev.plethora.api.method.MethodResult;
import org.squiddev.plethora.api.method.wrapper.FromSubtarget;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.api.module.SubtargetedModuleMethod;
import org.squiddev.plethora.gameplay.ConfigGameplay;
import org.squiddev.plethora.gameplay.modules.PlethoraModules;

@Injects
public final class MethodsKineticEntity {
    public static final SubtargetedModuleMethod<EntityEnderman> TELEPORT = SubtargetedModuleMethod.of(MethodsKineticEntity.class.getName() + "#teleport", "teleport", PlethoraModules.KINETIC_M, EntityEnderman.class, "function(x:number, y:number, z:number) -- Teleport to a position relative to the current one", MethodsKineticEntity::teleport);
    public static final SubtargetedModuleMethod<AbstractSkeleton> SHOOT_SKELETON = SubtargetedModuleMethod.of(MethodsKineticEntity.class.getName() + "#shootSkeleton", "shoot", PlethoraModules.KINETIC_M, AbstractSkeleton.class, "function(potency:number) -- Fire an arrow in the direction the skeleton is looking", MethodsKineticEntity::shootSkeleton);
    public static final SubtargetedModuleMethod<EntityBlaze> SHOOT_BLAZE = SubtargetedModuleMethod.of(MethodsKineticEntity.class.getName() + "#shootBlaze", "shoot", PlethoraModules.KINETIC_M, EntityBlaze.class, "function(yaw:number, pitch:number) -- Fire a fireball in the specified direction.", MethodsKineticEntity::shootBlaze);
    private static final PotionType[] WITCH_POTIONS = new PotionType[]{PotionTypes.field_185252_x, PotionTypes.field_185246_r, PotionTypes.field_185254_z, PotionTypes.field_185226_I};
    public static final SubtargetedModuleMethod<EntityWitch> SHOOT_WITCH = SubtargetedModuleMethod.of(MethodsKineticEntity.class.getName() + "#shootWitch", "shoot", PlethoraModules.KINETIC_M, EntityWitch.class, "function(potency:number) -- Throw a potion in the direction the witch is looking", MethodsKineticEntity::shootWitch);
    public static final SubtargetedModuleMethod<EntityMinecart> PROPEL = SubtargetedModuleMethod.of(MethodsKineticEntity.class.getName() + "#propel", "propel", PlethoraModules.KINETIC_M, EntityMinecart.class, "function(velocity:number) -- Propel this minecart in along the track.", MethodsKineticEntity::propel);

    private MethodsKineticEntity() {
    }

    @PlethoraMethod(module={"plethora:kinetic"}, doc="-- Look in a set direction")
    public static void look(@FromSubtarget EntityLivingBase target, double yaw, double pitch) {
        yaw %= 360.0;
        pitch %= 360.0;
        pitch = MathHelper.func_151237_a((double)pitch, (double)-90.0, (double)90.0);
        if (target instanceof EntityPlayerMP) {
            NetHandlerPlayServer handler = ((EntityPlayerMP)target).field_71135_a;
            handler.func_147364_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, (float)yaw, (float)pitch);
        } else {
            target.field_70177_z = target.field_70761_aq = (float)yaw;
            target.field_70759_as = target.field_70761_aq;
            target.field_70125_A = (float)pitch;
        }
    }

    @PlethoraMethod(module={"plethora:kinetic"}, doc="-- Explode this creeper.")
    public static void explode(@FromSubtarget(value={"origin"}) EntityCreeper target) {
        target.func_146077_cc();
    }

    private static MethodResult teleport(@Nonnull IUnbakedContext<IModuleContainer> context, @Nonnull Object[] args) throws LuaException {
        double x = ArgumentHelper.getReal((Object[])args, (int)0);
        double y = ArgumentHelper.getReal((Object[])args, (int)1);
        double z = ArgumentHelper.getReal((Object[])args, (int)2);
        org.squiddev.plethora.api.method.ArgumentHelper.assertBetween(x, (double)(-ConfigGameplay.Kinetic.teleportRange), (double)ConfigGameplay.Kinetic.teleportRange, "X coordinate out of bounds (%s)");
        org.squiddev.plethora.api.method.ArgumentHelper.assertBetween(y, (double)(-ConfigGameplay.Kinetic.teleportRange), (double)ConfigGameplay.Kinetic.teleportRange, "Y coordinate out of bounds (%s)");
        org.squiddev.plethora.api.method.ArgumentHelper.assertBetween(z, (double)(-ConfigGameplay.Kinetic.teleportRange), (double)ConfigGameplay.Kinetic.teleportRange, "Z coordinate out of bounds (%s)");
        double cost = Math.sqrt(x * x + y * y + z * z) * (double)ConfigGameplay.Kinetic.teleportCost;
        return context.getCostHandler().await(cost, MethodResult.nextTick(() -> {
            IContext baked = context.bake();
            EntityEnderman target = baked.getContext("origin", EntityEnderman.class);
            return MethodResult.result((Object)target.func_70825_j(target.field_70165_t + x, target.field_70163_u + y, target.field_70161_v + z));
        }));
    }

    @Nonnull
    private static MethodResult shootSkeleton(@Nonnull IUnbakedContext<IModuleContainer> unbaked, @Nonnull Object[] args) throws LuaException {
        double potency = ArgumentHelper.getReal((Object[])args, (int)0);
        org.squiddev.plethora.api.method.ArgumentHelper.assertBetween(potency, 0.1, 1.0, "Potency out of range (%s).");
        return unbaked.getCostHandler().await((double)ConfigGameplay.Kinetic.shootCost * potency, MethodResult.nextTick(() -> {
            IContext context = unbaked.bake();
            AbstractSkeleton skeleton = context.getContext("origin", AbstractSkeleton.class);
            ItemStack stack = skeleton.func_184586_b(EnumHand.MAIN_HAND);
            if (stack.func_190926_b() || stack.func_77973_b() != Items.field_151031_f) {
                throw new LuaException("Not holding a bow");
            }
            IWorldLocation location = context.getContext(IWorldLocation.class);
            EntityArrow arrow = (EntityArrow)ReflectionHelper.findMethod(AbstractSkeleton.class, (String)"getArrow", (String)"func_190726_a", (Class[])new Class[]{Float.TYPE}).invoke((Object)skeleton, Float.valueOf((float)potency));
            float rotationYaw = skeleton.field_70177_z;
            float rotationPitch = skeleton.field_70125_A;
            float motionX = -MathHelper.func_76126_a((float)(rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rotationPitch / 180.0f * (float)Math.PI));
            float motionZ = MathHelper.func_76134_b((float)(rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rotationPitch / 180.0f * (float)Math.PI));
            float motionY = -MathHelper.func_76126_a((float)(rotationPitch / 180.0f * (float)Math.PI));
            arrow.func_70186_c((double)motionX, (double)motionY, (double)motionZ, 1.6f, (float)(potency * 2.0));
            double damage = potency * 2.0;
            int power = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
            if (power > 0) {
                damage += (double)power * 0.5 + 0.5;
            }
            arrow.func_70239_b(damage);
            if (potency == 1.0) {
                arrow.func_70243_d(true);
            }
            skeleton.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (skeleton.func_70681_au().nextFloat() * 0.4f + 0.8f));
            location.getWorld().func_72838_d((Entity)arrow);
            return MethodResult.empty();
        }));
    }

    @Nonnull
    private static MethodResult shootBlaze(@Nonnull IUnbakedContext<IModuleContainer> unbaked, @Nonnull Object[] args) throws LuaException {
        double yaw = ArgumentHelper.getReal((Object[])args, (int)0) % 360.0;
        double pitch = ArgumentHelper.getReal((Object[])args, (int)1) % 360.0;
        double motionX = -Math.sin(yaw / 180.0 * 3.1415927410125732) * Math.cos(pitch / 180.0 * 3.1415927410125732);
        double motionZ = Math.cos(yaw / 180.0 * 3.1415927410125732) * Math.cos(pitch / 180.0 * 3.1415927410125732);
        double motionY = -Math.sin(pitch / 180.0 * 3.1415927410125732);
        return unbaked.getCostHandler().await((double)ConfigGameplay.Kinetic.shootCost, MethodResult.nextTick(() -> {
            IContext context = unbaked.bake();
            EntityBlaze blaze = context.getContext("origin", EntityBlaze.class);
            World world = blaze.func_130014_f_();
            world.func_180498_a(null, 1018, new BlockPos((int)blaze.field_70165_t, (int)blaze.field_70163_u, (int)blaze.field_70161_v), 0);
            EntitySmallFireball fireball = new EntitySmallFireball(world, (EntityLivingBase)blaze, motionX, motionY, motionZ);
            fireball.field_70163_u = blaze.field_70163_u + (double)(blaze.field_70131_O / 2.0f) + 0.5;
            world.func_72838_d((Entity)fireball);
            return MethodResult.empty();
        }));
    }

    @Nonnull
    private static MethodResult shootWitch(@Nonnull IUnbakedContext<IModuleContainer> unbaked, @Nonnull Object[] args) throws LuaException {
        double potency = ArgumentHelper.getReal((Object[])args, (int)0);
        org.squiddev.plethora.api.method.ArgumentHelper.assertBetween(potency, 0.1, 1.0, "Potency out of range (%s).");
        return unbaked.getCostHandler().await((double)ConfigGameplay.Kinetic.shootCost * potency, MethodResult.nextTick(() -> {
            IContext context = unbaked.bake();
            EntityWitch witch = context.getContext("origin", EntityWitch.class);
            if (witch.func_184730_o()) {
                throw new LuaException("Currently drinking a potion");
            }
            World world = witch.func_130014_f_();
            Vec3d motion = witch.func_70040_Z();
            PotionType potionType = WITCH_POTIONS[witch.func_70681_au().nextInt(WITCH_POTIONS.length)];
            EntityPotion potion = new EntityPotion(world, (EntityLivingBase)witch, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)potionType));
            potion.field_70125_A -= -20.0f;
            potion.func_70186_c(motion.field_72450_a, 0.2 + potency * 1.4, motion.field_72448_b, 0.75f, 8.0f);
            world.func_184148_a(null, witch.field_70165_t, witch.field_70163_u, witch.field_70161_v, SoundEvents.field_187924_gx, witch.func_184176_by(), 1.0f, 0.8f + witch.func_70681_au().nextFloat() * 0.4f);
            world.func_72838_d((Entity)potion);
            return MethodResult.empty();
        }));
    }

    private static MethodResult propel(@Nonnull IUnbakedContext<IModuleContainer> context, @Nonnull Object[] args) throws LuaException {
        double given = ArgumentHelper.getReal((Object[])args, (int)0);
        org.squiddev.plethora.api.method.ArgumentHelper.assertBetween(given, -ConfigGameplay.Kinetic.propelMax, ConfigGameplay.Kinetic.propelMax, "Velocity coordinate out of bounds (%s)");
        double velocity = given * 0.1;
        return context.getCostHandler().await(Math.abs(given) * ConfigGameplay.Kinetic.propelCost, MethodResult.nextTick(() -> {
            IContext baked = context.bake();
            EntityMinecart target = baked.getContext("origin", EntityMinecart.class);
            double vx = target.field_70159_w;
            double vz = target.field_70179_y;
            double len = Math.sqrt(vx * vx + vz * vz);
            if (len == 0.0) {
                float yaw = target.field_70177_z;
                vx = -MathHelper.func_76126_a((float)(yaw / 180.0f * (float)Math.PI));
                vz = MathHelper.func_76134_b((float)(yaw / 180.0f * (float)Math.PI));
                len = 1.0;
            }
            target.func_70024_g(velocity * vx / len, 0.0, velocity * vz / len);
            target.field_70133_I = true;
            return MethodResult.empty();
        }));
    }
}

