/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public interface Attribute<T> {
    public Optional<T> get(int var1);

    public boolean hasEntry(int var1);

    public static <T> Attribute<T> map() {
        return new FromMap();
    }

    public static <T> Attribute<T> map(Map<Integer, T> map) {
        return new FromMap<T>(map);
    }

    public static <T> Attribute<T> constant(@Nullable T value) {
        return new Constant<T>(value);
    }

    public static <T> JsonDeserializer<Attribute<T>> deserializer(Type elementType) {
        return (json, typeOfT, context) -> {
            if (Attribute.isMetaMap(json)) {
                FromMap map = new FromMap();
                json.getAsJsonObject().entrySet().forEach(e -> map.addEntry(Integer.parseInt((String)e.getKey()), context.deserialize((JsonElement)e.getValue(), elementType)));
                return map;
            }
            return Attribute.constant(context.deserialize(json, elementType));
        };
    }

    public static boolean isMetaMap(JsonElement json) {
        return json.isJsonObject() && json.getAsJsonObject().entrySet().stream().allMatch(e -> ((String)e.getKey()).matches("[0-9]+"));
    }

    public static class Constant<T>
    implements Attribute<T> {
        private final T value;

        Constant(@Nullable T value) {
            this.value = value;
        }

        @Override
        public Optional<T> get(int meta) {
            return Optional.ofNullable(this.value);
        }

        @Override
        public boolean hasEntry(int meta) {
            return true;
        }
    }

    public static class FromMap<T>
    implements Attribute<T> {
        private final Map<Integer, T> map;

        FromMap() {
            this(Maps.newHashMap());
        }

        FromMap(Map<Integer, T> map) {
            this.map = map;
        }

        @Override
        public Optional<T> get(int meta) {
            return Optional.ofNullable(this.map.get(meta));
        }

        @Override
        public boolean hasEntry(int meta) {
            return this.map.containsKey(meta);
        }

        private void addEntry(int meta, T value) {
            this.map.put(meta, value);
        }
    }
}

