/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.tracking;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import pregenerator.ChunkPregenerator;
import pregenerator.ConfigManager;
import pregenerator.impl.tracking.AverageCounter;
import pregenerator.impl.tracking.TimeTracker;
import pregenerator.impl.tracking.WorldTracker;

public class ServerTracker {
    public static final ServerTracker INSTANCE = new ServerTracker();
    Map<World, WorldTracker> mapping = new LinkedHashMap<World, WorldTracker>();
    private boolean enabled = false;
    TimeTracker tracker = new TimeTracker(40);
    AverageCounter packets = new AverageCounter(40);

    public void init() {
        ChunkPregenerator.pregenBase.registerTickEvent(this);
        this.enabled = ConfigManager.tracking;
    }

    public void toggle() {
        this.enabled = !this.enabled;
        ConfigManager.changeTracking(this.enabled);
        for (WorldTracker entry : this.mapping.values()) {
            entry.setState(this.enabled);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (!this.enabled) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            this.tracker.setStart();
            this.packets.addMore(this.getServer().field_175589_i.size());
            this.packets.onFinished();
        } else {
            this.tracker.onFinished();
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!this.enabled) {
            return;
        }
        WorldTracker tracker = this.mapping.get(event.world);
        if (tracker != null) {
            if (event.phase == TickEvent.Phase.START) {
                tracker.onTickStart();
            } else {
                tracker.onTickEnd();
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load load) {
        World world = load.getWorld();
        if (world instanceof WorldServer) {
            this.mapping.put(world, new WorldTracker((WorldServer)world, this.enabled));
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload unload) {
        this.mapping.remove(unload.getWorld());
    }

    public void onServerStopped() {
        this.mapping.clear();
    }

    public MinecraftServer getServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    public WorldTracker getWorld(int dim) {
        return this.mapping.get(DimensionManager.getWorld((int)dim));
    }

    public WorldTracker getWorld(World world) {
        return this.mapping.get(world);
    }

    public long getAverage() {
        return this.tracker.getAverage();
    }

    public int getPackets() {
        return this.packets.getAverage();
    }

    public List<WorldTracker> getTracker() {
        return new ArrayList<WorldTracker>(this.mapping.values());
    }
}

