/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import info.openmods.calc.Frame;
import info.openmods.calc.symbol.ICallable;
import info.openmods.calc.types.multi.TypeDomain;
import info.openmods.calc.types.multi.TypedValue;
import info.openmods.calc.utils.AnnotationMap;
import info.openmods.calc.utils.DefaultMap;
import info.openmods.calc.utils.OptionalInt;
import info.openmods.calc.utils.Stack;
import info.openmods.calc.utils.reflection.TypeVariableHolder;
import info.openmods.calc.utils.reflection.TypeVariableHolderFiller;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypedFunction {
    private static final DefaultMap<Method, TypeVariant> variantsCache = new DefaultMap<Method, TypeVariant>(){

        @Override
        protected TypeVariant create(Method key) {
            return TypedFunction.createVariant(key);
        }
    };
    protected final TypedFunctionBody body;

    private static DispatchArgMatcher createMatcher(Class<?> argType, DispatchArg annotation, Class<?> ... extraTypes) {
        HashSet dispatchArgsTypes = Sets.newHashSet((Object[])annotation.extra());
        dispatchArgsTypes.addAll(Arrays.asList(extraTypes));
        dispatchArgsTypes.add(argType);
        return new DispatchArgMatcher(dispatchArgsTypes);
    }

    private static DispatchArgMatcher createMatcher(RawDispatchArg annotation, Class<?> ... extraTypes) {
        HashSet dispatchArgsTypes = Sets.newHashSet((Object[])annotation.value());
        Preconditions.checkArgument((!dispatchArgsTypes.isEmpty() ? 1 : 0) != 0, (Object)"Raw dispatch arg must specify dispatch types");
        dispatchArgsTypes.addAll(Arrays.asList(extraTypes));
        return new DispatchArgMatcher(dispatchArgsTypes);
    }

    private static TypeVariant createVariant(final Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Type[] parameterTypes = method.getGenericParameterTypes();
        int parameterCount = parameterTypes.length;
        int optionalArgsStart = -1;
        boolean isVariadic = method.isVarArgs();
        final ArrayList argConverters = Lists.newArrayList();
        final HashMap argMatchers = Maps.newHashMap();
        for (int i = 0; i < parameterCount; ++i) {
            DispatchArg dispatchAnn;
            TypeToken type = TypeToken.of((Type)parameterTypes[i]);
            AnnotationMap annotations = new AnnotationMap(parameterAnnotations[i]);
            if (annotations.hasAnnotation(OptionalArgs.class)) {
                optionalArgsStart = i;
            }
            boolean isTypedDispatch = (dispatchAnn = annotations.get(DispatchArg.class)) != null;
            RawDispatchArg dispatchRawAnn = annotations.get(RawDispatchArg.class);
            boolean isRawDispatch = dispatchRawAnn != null;
            boolean isRawNonDispatch = annotations.hasAnnotation(RawArg.class);
            boolean isRawArg = isRawNonDispatch || isRawDispatch;
            boolean isDispatchArg = isTypedDispatch || isRawDispatch;
            boolean isVariadicArg = isVariadic && i == parameterCount - 1;
            Preconditions.checkArgument((!isTypedDispatch || !isRawNonDispatch ? 1 : 0) != 0, (Object)"Argument cannot be both dispatch and raw");
            Preconditions.checkArgument((!isRawDispatch || !isRawNonDispatch ? 1 : 0) != 0, (Object)"Argument cannot be both raw and raw dispatch");
            Preconditions.checkArgument((!isRawDispatch || !isTypedDispatch ? 1 : 0) != 0, (Object)"Argument cannot be both raw and typed dispatch");
            Preconditions.checkArgument((!isVariadicArg || !isDispatchArg ? 1 : 0) != 0, (Object)"Variadic arguments cannot be used for dispatch");
            if (isVariadicArg) {
                Class componentType = type.getComponentType().getRawType();
                if (isRawArg) {
                    Preconditions.checkState((boolean)TypedValue.class.isAssignableFrom(componentType), (Object)"Raw argument must have TypedValue type");
                    argConverters.add(new VariadicRawArgConverter());
                    continue;
                }
                argConverters.add(new VariadicArgConverter(componentType));
                continue;
            }
            if (optionalArgsStart >= 0) {
                Preconditions.checkState((boolean)Optional.class.isAssignableFrom(type.getRawType()), (Object)"Optional argument must have Optional type");
                Class<?> varType = TypeVariableHolders.OptionalType.resolve(type);
                if (isRawArg) {
                    Preconditions.checkState((boolean)TypedValue.class.isAssignableFrom(varType), (Object)"Raw argument must have TypedValue type");
                    argConverters.add(new OptionalRawArgConverter());
                    if (!isDispatchArg) continue;
                    argMatchers.put(i, TypedFunction.createMatcher(dispatchRawAnn, MissingType.class));
                    continue;
                }
                argConverters.add(new OptionalArgConverter(varType));
                if (!isDispatchArg) continue;
                argMatchers.put(i, TypedFunction.createMatcher(varType, dispatchAnn, MissingType.class));
                continue;
            }
            Class rawType = type.getRawType();
            if (isRawArg) {
                Preconditions.checkState((boolean)TypedValue.class.isAssignableFrom(rawType), (Object)"Raw argument must have TypedValue type");
                argConverters.add(new MandatoryRawArgConverter());
                if (!isDispatchArg) continue;
                argMatchers.put(i, TypedFunction.createMatcher(dispatchRawAnn, new Class[0]));
                continue;
            }
            argConverters.add(new MandatoryArgConverter(rawType));
            if (!isDispatchArg) continue;
            argMatchers.put(i, TypedFunction.createMatcher(rawType, dispatchAnn, new Class[0]));
        }
        final int mandatoryArgCount = optionalArgsStart >= 0 ? optionalArgsStart : parameterCount;
        boolean isCollectionReturn = method.isAnnotationPresent(MultiReturn.class);
        boolean isRawReturn = method.isAnnotationPresent(RawReturn.class);
        final Class<?> returnType = method.getReturnType();
        if (MultipleReturn.class.isAssignableFrom(returnType)) {
            Preconditions.checkState((!isRawReturn ? 1 : 0) != 0, (Object)"Method returning MultipleReturn cannot be marked as @RawReturn");
            Preconditions.checkState((!isCollectionReturn ? 1 : 0) != 0, (Object)"Method returning MultipleReturn cannot be marked as @MultiReturn");
            class MultipleReturnVariant
            extends TypeVariant {
                final /* synthetic */ Map val$argMatchers;
                final /* synthetic */ List val$argConverters;
                final /* synthetic */ int val$mandatoryArgCount;

                public MultipleReturnVariant() {
                    this.val$argMatchers = map;
                    this.val$argConverters = list;
                    this.val$mandatoryArgCount = n;
                    super(method2, map, list, n);
                }

                @Override
                protected List<TypedValue> convertResult(TypeDomain domain, Object result) {
                    MultipleReturn results = (MultipleReturn)result;
                    for (TypedValue v : results.rets) {
                        Preconditions.checkArgument((v.domain == domain ? 1 : 0) != 0, (String)"Mixed domain on result %s", (Object)v);
                    }
                    return Arrays.asList(results.rets);
                }
            }
            return new MultipleReturnVariant();
        }
        if (isCollectionReturn) {
            Preconditions.checkState((!isRawReturn ? 1 : 0) != 0, (Object)"Method marked as @MultiReturn cannot be marked as @RawReturn");
            if (returnType.isArray()) {
                final Class<?> componentType = returnType.getComponentType();
                class ArrayReturnVariant
                extends TypeVariant {
                    public ArrayReturnVariant() {
                        super(method2, map, list, n);
                    }

                    @Override
                    protected List<TypedValue> convertResult(TypeDomain domain, Object result) {
                        ArrayList ret = Lists.newArrayList();
                        int returnSize = Array.getLength(result);
                        for (int i = 0; i < returnSize; ++i) {
                            Object v = Array.get(result, i);
                            ret.add(domain.castAndCreate(componentType, v));
                        }
                        return ret;
                    }
                }
                return new ArrayReturnVariant();
            }
            if (Iterable.class.isAssignableFrom(returnType)) {
                final Class<?> componentType = TypeVariableHolders.IterableType.resolve(method.getGenericReturnType());
                class IterableReturnVariant
                extends TypeVariant {
                    public IterableReturnVariant() {
                        super(method2, map, list, n);
                    }

                    @Override
                    protected List<TypedValue> convertResult(TypeDomain domain, Object result) {
                        ArrayList ret = Lists.newArrayList();
                        Iterable results = (Iterable)result;
                        for (Object v : results) {
                            ret.add(domain.castAndCreate(componentType, v));
                        }
                        return ret;
                    }
                }
                return new IterableReturnVariant();
            }
            throw new IllegalArgumentException("Method " + method + " is marked with @MultiReturn, but does not return array or Iterable");
        }
        if (isRawReturn) {
            Preconditions.checkState((boolean)TypedValue.class.isAssignableFrom(method.getReturnType()), (Object)"Method marked with @RawReturn must return TypedValue");
            class RawSingleReturnVariant
            extends TypeVariant {
                final /* synthetic */ Map val$argMatchers;
                final /* synthetic */ List val$argConverters;
                final /* synthetic */ int val$mandatoryArgCount;

                public RawSingleReturnVariant() {
                    this.val$argMatchers = map;
                    this.val$argConverters = list;
                    this.val$mandatoryArgCount = n;
                    super(method2, map, list, n);
                }

                @Override
                protected List<TypedValue> convertResult(TypeDomain domain, Object result) {
                    return Lists.newArrayList((Object[])new TypedValue[]{(TypedValue)result});
                }
            }
            return new RawSingleReturnVariant();
        }
        class SingleReturnVariant
        extends TypeVariant {
            public SingleReturnVariant() {
                super(method2, map, list, n);
            }

            @Override
            public List<TypedValue> convertResult(TypeDomain domain, Object result) {
                return this.wrapArg(domain, result, returnType);
            }

            private <T> List<TypedValue> wrapArg(TypeDomain domain, Object result, Class<T> returnType2) {
                T castResult = returnType2.cast(result);
                return Lists.newArrayList((Object[])new TypedValue[]{domain.create(returnType2, castResult)});
            }
        }
        return new SingleReturnVariant();
    }

    private TypedFunction(TypedFunctionBody body) {
        this.body = body;
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        TypeVariableHolderFiller.instance.initialize(TypeVariableHolders.class);
    }

    public static class Bound
    extends TypedFunction
    implements ICallable<TypedValue> {
        private final TypeDomain domain;
        private final Object target;

        public Bound(TypeDomain domain, Object target, TypedFunctionBody body) {
            super(body);
            this.domain = domain;
            this.target = target;
        }

        @Override
        public void call(Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
            this.body.call(this.domain, this.target, frame, argumentsCount, returnsCount);
        }
    }

    public static class Unbound
    extends TypedFunction
    implements IUnboundCallable {
        private final Class<?> targetCls;

        public Unbound(Class<?> targetCls, TypedFunctionBody body) {
            super(body);
            this.targetCls = targetCls;
        }

        @Override
        public void call(TypeDomain domain, Object target, Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
            Preconditions.checkState((boolean)this.targetCls.isInstance(target));
            this.body.call(domain, target, frame, argumentsCount, returnsCount);
        }
    }

    public static interface IUnboundCallable {
        public void call(TypeDomain var1, Object var2, Frame<TypedValue> var3, OptionalInt var4, OptionalInt var5);
    }

    private static abstract class TypedFunctionBody {
        private final OptionalInt mandatoryArgNum;

        private TypedFunctionBody(OptionalInt mandatoryArgNum) {
            this.mandatoryArgNum = mandatoryArgNum;
        }

        public void call(TypeDomain domain, Object target, Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
            int argCount;
            if (argumentsCount.isPresent()) {
                argCount = argumentsCount.get();
            } else {
                Preconditions.checkState((boolean)this.mandatoryArgNum.isPresent(), (Object)"Number of arguments not given and function is not fixed");
                argCount = this.mandatoryArgNum.get();
            }
            ArrayList reversedArgs = Lists.newArrayList();
            Stack<TypedValue> stack = frame.stack();
            for (int i = 0; i < argCount; ++i) {
                reversedArgs.add(stack.pop());
            }
            List args = Lists.reverse((List)reversedArgs);
            List<TypedValue> returns = this.execute(domain, target, args);
            if (returnsCount.isPresent()) {
                Integer expectedReturns = returnsCount.get();
                int actualReturns = returns.size();
                Preconditions.checkState((expectedReturns == actualReturns ? 1 : 0) != 0, (String)"Invalid number of return values, requested %s, got %s", (Object)expectedReturns, (int)actualReturns);
            }
            stack.pushAll(returns);
        }

        protected abstract List<TypedValue> execute(TypeDomain var1, Object var2, List<TypedValue> var3);
    }

    private static abstract class TypeVariant {
        private final Method method;
        private final Map<Integer, DispatchArgMatcher> dispatchArgMatchers;
        private final List<ArgConverter> argConverters;
        private final int mandatoryArgNum;
        private final int lastDispatchArg;

        public TypeVariant(Method method, Map<Integer, DispatchArgMatcher> dispatchArgMatchers, List<ArgConverter> argConverters, int mandatoryArgNum) {
            this.method = method;
            this.dispatchArgMatchers = ImmutableMap.copyOf(dispatchArgMatchers);
            this.argConverters = argConverters;
            this.mandatoryArgNum = mandatoryArgNum;
            this.lastDispatchArg = dispatchArgMatchers.isEmpty() ? -1 : (Integer)Ordering.natural().max(dispatchArgMatchers.keySet());
        }

        private boolean isMatchAmbigous(TypeVariant other) {
            int thisLength = this.method.getParameterTypes().length;
            int otherLength = other.method.getParameterTypes().length;
            for (int i = 0; i < Math.max(thisLength, otherLength); ++i) {
                DispatchArgMatcher otherMatcher;
                DispatchArgMatcher ownMatcher = i < thisLength ? this.dispatchArgMatchers.get(i) : DispatchArgMatcher.MISSING;
                DispatchArgMatcher dispatchArgMatcher = otherMatcher = i < otherLength ? other.dispatchArgMatchers.get(i) : DispatchArgMatcher.MISSING;
                if (ownMatcher == null || otherMatcher == null || ownMatcher.isAmbiguous(otherMatcher)) continue;
                return false;
            }
            return true;
        }

        private boolean matchDispatchArgs(List<TypedValue> args) {
            int argCount = args.size();
            for (Map.Entry<Integer, DispatchArgMatcher> m : this.dispatchArgMatchers.entrySet()) {
                Class<MissingType> matchedArgType;
                int matchedArgIndex = m.getKey();
                Class clazz = matchedArgType = matchedArgIndex < argCount ? args.get((int)matchedArgIndex).type : MissingType.class;
                if (m.getValue().match(matchedArgType)) continue;
                return false;
            }
            return true;
        }

        private List<Object> convertArgs(TypeDomain domain, List<TypedValue> args) {
            ArrayList results = Lists.newArrayList();
            for (TypedValue v : args) {
                Preconditions.checkArgument((v.domain == domain ? 1 : 0) != 0, (String)"Mixed domain on arg %s", (Object)v);
            }
            Iterator<TypedValue> argsIterator = args.iterator();
            for (ArgConverter converter : this.argConverters) {
                results.add(converter.convert(argsIterator));
            }
            Preconditions.checkState((!argsIterator.hasNext() ? 1 : 0) != 0, (Object)"Unconverted args!");
            return results;
        }

        protected abstract List<TypedValue> convertResult(TypeDomain var1, Object var2);

        public List<TypedValue> execute(TypeDomain domain, Object target, List<TypedValue> args) {
            try {
                List<Object> unwrappedArgs = this.convertArgs(domain, args);
                Object result = this.method.invoke(target, unwrappedArgs.toArray());
                return this.convertResult(domain, result);
            }
            catch (Exception e) {
                throw new MethodInvokeException(this.method, (Throwable)e);
            }
        }
    }

    private static class VariadicRawArgConverter
    implements ArgConverter {
        private VariadicRawArgConverter() {
        }

        @Override
        public Object convert(Iterator<TypedValue> value) {
            ArrayList values = Lists.newArrayList(value);
            Object result = Array.newInstance(TypedValue.class, values.size());
            for (int i = 0; i < values.size(); ++i) {
                TypedValue v = (TypedValue)values.get(i);
                Array.set(result, i, v);
            }
            return result;
        }
    }

    private static class VariadicArgConverter
    implements ArgConverter {
        private final Class<?> cls;

        public VariadicArgConverter(Class<?> cls) {
            Preconditions.checkNotNull(cls);
            this.cls = cls;
        }

        @Override
        public Object convert(Iterator<TypedValue> value) {
            ArrayList values = Lists.newArrayList(value);
            Object result = Array.newInstance(this.cls, values.size());
            for (int i = 0; i < values.size(); ++i) {
                TypedValue v = (TypedValue)values.get(i);
                Object c = v.unwrap(this.cls);
                Array.set(result, i, c);
            }
            return result;
        }
    }

    private static class OptionalRawArgConverter
    implements ArgConverter {
        private OptionalRawArgConverter() {
        }

        @Override
        public Object convert(Iterator<TypedValue> value) {
            if (value.hasNext()) {
                TypedValue result = value.next();
                return Optional.of((Object)result);
            }
            return Optional.absent();
        }
    }

    private static class OptionalArgConverter
    implements ArgConverter {
        private final Class<?> cls;

        public OptionalArgConverter(Class<?> cls) {
            Preconditions.checkNotNull(cls);
            this.cls = cls;
        }

        @Override
        public Object convert(Iterator<TypedValue> value) {
            if (value.hasNext()) {
                TypedValue result = value.next();
                return Optional.of(result.unwrap(this.cls));
            }
            return Optional.absent();
        }
    }

    private static class MandatoryRawArgConverter
    implements ArgConverter {
        private MandatoryRawArgConverter() {
        }

        @Override
        public Object convert(Iterator<TypedValue> value) {
            Preconditions.checkArgument((boolean)value.hasNext(), (Object)"Missing mandatory argument");
            return value.next();
        }
    }

    private static class MandatoryArgConverter
    implements ArgConverter {
        private final Class<?> cls;

        public MandatoryArgConverter(Class<?> cls) {
            Preconditions.checkNotNull(cls);
            this.cls = cls;
        }

        @Override
        public Object convert(Iterator<TypedValue> value) {
            Preconditions.checkArgument((boolean)value.hasNext(), (Object)"Missing mandatory argument");
            TypedValue result = value.next();
            return result.unwrap(this.cls);
        }
    }

    private static interface ArgConverter {
        public Object convert(Iterator<TypedValue> var1);
    }

    private static class DispatchArgMatcher {
        public static final DispatchArgMatcher MISSING = new DispatchArgMatcher(MissingType.class);
        public final Set<Class<?>> expectedTypes;

        private DispatchArgMatcher(Set<Class<?>> expectedTypes) {
            this.expectedTypes = ImmutableSet.copyOf(expectedTypes);
        }

        private DispatchArgMatcher(Class<?> ... expectedTypes) {
            this.expectedTypes = ImmutableSet.copyOf((Object[])expectedTypes);
        }

        public boolean match(Class<?> type) {
            return this.expectedTypes.contains(type);
        }

        public boolean isAmbiguous(DispatchArgMatcher other) {
            return !Sets.intersection(this.expectedTypes, other.expectedTypes).isEmpty();
        }
    }

    private static class MissingType {
        private MissingType() {
        }
    }

    private static class TypeVariableHolders {
        private TypeVariableHolders() {
        }

        @TypeVariableHolder(value=Iterable.class)
        private static class IterableType {
            private static TypeVariable<?> T;

            private IterableType() {
            }

            public static Class<?> resolve(Type t) {
                return TypeToken.of((Type)t).resolveType(T).getRawType();
            }
        }

        @TypeVariableHolder(value=Optional.class)
        private static class OptionalType {
            private static TypeVariable<?> T;

            private OptionalType() {
            }

            public static Class<?> resolve(TypeToken<?> t) {
                return t.resolveType(T).getRawType();
            }
        }
    }

    public static class Builder {
        private static final Ordering<TypeVariant> VARIANT_ORDERING = Ordering.natural().reverse().onResultOf(input -> Integer.valueOf(((TypeVariant)input).lastDispatchArg));
        private static final DefaultMap<Set<Method>, TypedFunctionBody> bodyCache = new DefaultMap<Set<Method>, TypedFunctionBody>(){

            @Override
            protected TypedFunctionBody create(Set<Method> methods) {
                ArrayList variants = Lists.newArrayList();
                for (Method m : methods) {
                    try {
                        variants.add(variantsCache.getOrCreate(m));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to register method " + m, e);
                    }
                }
                if (variants.size() == 1) {
                    return Builder.createSingleFunction((TypeVariant)variants.get(0));
                }
                Builder.verifyVariants(variants);
                Collections.sort(variants, VARIANT_ORDERING);
                OptionalInt mandatoryArgNum = Builder.calculateMandatoryArgNum(variants);
                return Builder.createMultiFunction(variants, mandatoryArgNum);
            }
        };
        private Set<Class<?>> allowedClasses = Sets.newHashSet();
        private final Set<Method> variants = Sets.newHashSet();

        private Builder() {
        }

        public Builder addVariant(Method method) {
            if (!Modifier.isStatic(method.getModifiers())) {
                this.allowedClasses.add(method.getDeclaringClass());
            }
            method.setAccessible(true);
            this.variants.add(method);
            return this;
        }

        public Builder addVariants(Class<?> cls) {
            for (Method m : cls.getMethods()) {
                if (!m.isAnnotationPresent(Variant.class)) continue;
                this.addVariant(m);
            }
            return this;
        }

        public IUnboundCallable build(Class<?> targetCls) {
            Preconditions.checkArgument((!this.variants.isEmpty() ? 1 : 0) != 0, (Object)"No variants defined");
            if (targetCls == null) {
                if (!this.allowedClasses.isEmpty()) {
                    throw new NonStaticMethodsPresent();
                }
            } else {
                for (Class<?> cls : this.allowedClasses) {
                    if (cls.isAssignableFrom(targetCls)) continue;
                    throw new NonCompatibleMethodsPresent(cls, targetCls);
                }
            }
            TypedFunctionBody body = bodyCache.getOrCreate((Set<Method>)ImmutableSet.copyOf(this.variants));
            return new Unbound(targetCls, body);
        }

        public ICallable<TypedValue> build(TypeDomain domain, Object target) {
            Preconditions.checkArgument((!this.variants.isEmpty() ? 1 : 0) != 0, (Object)"No variants defined");
            if (target == null) {
                if (!this.allowedClasses.isEmpty()) {
                    throw new NonStaticMethodsPresent();
                }
            } else {
                for (Class<?> cls : this.allowedClasses) {
                    if (cls.isInstance(target)) continue;
                    throw new NonCompatibleMethodsPresent(cls, target);
                }
            }
            TypedFunctionBody body = bodyCache.getOrCreate((Set<Method>)ImmutableSet.copyOf(this.variants));
            return new Bound(domain, target, body);
        }

        private static TypedFunctionBody createSingleFunction(final TypeVariant variant) {
            return new TypedFunctionBody(OptionalInt.of(variant.mandatoryArgNum)){

                @Override
                protected List<TypedValue> execute(TypeDomain domain, Object target, List<TypedValue> args) {
                    if (!variant.matchDispatchArgs(args)) {
                        throw new DispatchException(args);
                    }
                    return variant.execute(domain, target, args);
                }
            };
        }

        private static TypedFunctionBody createMultiFunction(final List<TypeVariant> variants, OptionalInt mandatoryArgNum) {
            return new TypedFunctionBody(mandatoryArgNum){

                @Override
                protected List<TypedValue> execute(TypeDomain domain, Object target, List<TypedValue> args) {
                    for (TypeVariant v : variants) {
                        if (!v.matchDispatchArgs(args)) continue;
                        return v.execute(domain, target, args);
                    }
                    throw new DispatchException(args);
                }
            };
        }

        private static void verifyVariants(List<TypeVariant> variants) {
            HashSet ambiguousMethods = Sets.newHashSet();
            for (int i = 0; i < variants.size(); ++i) {
                TypeVariant v1 = variants.get(i);
                for (int j = i + 1; j < variants.size(); ++j) {
                    TypeVariant v2 = variants.get(j);
                    if (!v2.isMatchAmbigous(v1)) continue;
                    ambiguousMethods.add(v1.method);
                    ambiguousMethods.add(v2.method);
                }
            }
            if (!ambiguousMethods.isEmpty()) {
                throw new AmbiguousDispatchException(ambiguousMethods);
            }
        }

        private static OptionalInt calculateMandatoryArgNum(List<TypeVariant> variants) {
            OptionalInt result = OptionalInt.absent();
            for (TypeVariant v : variants) {
                if (result.isPresent()) {
                    if (result.get() == v.mandatoryArgNum) continue;
                    return OptionalInt.absent();
                }
                result = OptionalInt.of(v.mandatoryArgNum);
            }
            return result;
        }
    }

    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DispatchArg {
        public Class<?>[] extra() default {};
    }

    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface OptionalArgs {
    }

    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RawDispatchArg {
        public Class<?>[] value();
    }

    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RawArg {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Variant {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MultiReturn {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RawReturn {
    }

    public static class MultipleReturn {
        private final TypedValue[] rets;

        private MultipleReturn(TypedValue[] rets) {
            this.rets = rets;
        }

        public static MultipleReturn wrap(TypedValue ... rets) {
            return new MultipleReturn(rets);
        }
    }

    public static class MethodInvokeException
    extends RuntimeException {
        private static final long serialVersionUID = 4012320626013808859L;

        public MethodInvokeException(Method method, Throwable t) {
            super("Failed to invoke method " + method, t);
        }
    }

    public static class NonCompatibleMethodsPresent
    extends RuntimeException {
        private static final long serialVersionUID = -3296321220525016125L;

        public NonCompatibleMethodsPresent(Class<?> required, Object target) {
            super("Target " + target.getClass() + " is not compatible with selected methods from class " + required);
        }
    }

    public static class NonStaticMethodsPresent
    extends RuntimeException {
        private static final long serialVersionUID = -8854128456679001775L;

        public NonStaticMethodsPresent() {
            super("Non-static methods detected, but target is null");
        }
    }

    public static class AmbiguousDispatchException
    extends RuntimeException {
        private static final long serialVersionUID = 4012320626013808859L;

        public AmbiguousDispatchException(Collection<Method> methods) {
            super("Cannot always select overload between methods " + methods.toString());
        }
    }

    public static class DispatchException
    extends RuntimeException {
        private static final long serialVersionUID = 8096730015947971477L;

        public DispatchException(Collection<TypedValue> args) {
            super("Failed to found override for args " + args);
        }
    }
}

