/*
 * Decompiled with CFR 0.152.
 */
package openmods.movement;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MovementInput;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import openmods.movement.PlayerMovementEvent;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class PlayerMovementManager {
    private static boolean wasJumping = false;
    private static boolean wasSneaking = false;

    private PlayerMovementManager() {
    }

    @SubscribeEvent
    public static void updateMovementState(InputUpdateEvent evt) {
        MovementInput input = evt.getMovementInput();
        EntityPlayer owner = evt.getEntityPlayer();
        if (input.field_78901_c && !wasJumping) {
            input.field_78901_c = PlayerMovementManager.postMovementEvent(owner, PlayerMovementEvent.Type.JUMP);
        }
        if (input.field_78899_d && !wasSneaking) {
            input.field_78899_d = PlayerMovementManager.postMovementEvent(owner, PlayerMovementEvent.Type.SNEAK);
        }
        wasJumping = input.field_78901_c;
        wasSneaking = input.field_78899_d;
    }

    private static boolean postMovementEvent(EntityPlayer player, PlayerMovementEvent.Type type) {
        return !MinecraftForge.EVENT_BUS.post((Event)new PlayerMovementEvent(player, type));
    }
}

