/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.Config;
import openmods.config.properties.ConfigurationChange;

public class CanvasReplaceBlacklist {
    private Set<ResourceLocation> idBlacklist = CanvasReplaceBlacklist.createBlacklist();
    public static final CanvasReplaceBlacklist instance = new CanvasReplaceBlacklist();

    private static Set<ResourceLocation> createBlacklist() {
        return Arrays.asList(Config.canvasBlacklist).stream().map(ResourceLocation::new).collect(Collectors.toSet());
    }

    public boolean isAllowedToReplace(IBlockState state) {
        Block block = state.func_177230_c();
        if (block.hasTileEntity(state)) {
            return false;
        }
        if (CanvasReplaceBlacklist.filterVanillaBlocks(block)) {
            return false;
        }
        return !this.idBlacklist.contains(block.getRegistryName());
    }

    private static boolean filterVanillaBlocks(Block block) {
        return block instanceof BlockDoor || block instanceof BlockBed;
    }

    @SubscribeEvent
    public void onReconfig(ConfigurationChange.Post evt) {
        if (evt.check("canvas", "replaceBlacklist")) {
            this.idBlacklist = CanvasReplaceBlacklist.createBlacklist();
        }
    }

    public boolean isAllowedToReplace(World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        return this.isAllowedToReplace(world.func_180495_p(pos));
    }
}

