/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import info.openmods.calc.Calculator;
import info.openmods.calc.ExprType;
import info.openmods.calc.SingleExprEvaluator;
import info.openmods.calc.types.fp.DoubleCalculatorFactory;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.common.item.ItemTrophyBlock;
import openblocks.common.tileentity.TileEntityTrophy;
import openblocks.trophy.BlazeBehavior;
import openblocks.trophy.CaveSpiderBehavior;
import openblocks.trophy.CreeperBehavior;
import openblocks.trophy.EndermanBehavior;
import openblocks.trophy.EvocationBehavior;
import openblocks.trophy.GuardianBehavior;
import openblocks.trophy.ITrophyBehavior;
import openblocks.trophy.ItemDropBehavior;
import openblocks.trophy.LlamaBehavior;
import openblocks.trophy.MooshroomBehavior;
import openblocks.trophy.ShulkerBehavior;
import openblocks.trophy.SkeletonBehavior;
import openblocks.trophy.SnowmanBehavior;
import openblocks.trophy.SquidBehavior;
import openblocks.trophy.WitchBehavior;
import openmods.Log;
import openmods.config.properties.ConfigurationChange;
import openmods.core.fixes.HorseNullFix;
import openmods.reflection.ReflectionHelper;

public class TrophyHandler {
    private static final Map<Trophy, Entity> ENTITY_CACHE = Maps.newHashMap();
    private final Random fallbackDropChance = new Random();
    private final SingleExprEvaluator<Double, ExprType> dropChanceCalculator = SingleExprEvaluator.create((Calculator)DoubleCalculatorFactory.createDefault());

    public TrophyHandler() {
        this.updateDropChanceFormula();
    }

    @SubscribeEvent
    public void onConfigChange(ConfigurationChange.Post evt) {
        if (evt.check("trophy", "trophyDropChanceFormula")) {
            this.updateDropChanceFormula();
        }
    }

    private void updateDropChanceFormula() {
        this.dropChanceCalculator.setExpr((Object)ExprType.INFIX, Config.trophyDropChanceFormula);
        if (!this.dropChanceCalculator.isExprValid()) {
            Log.info((String)"Invalid trophyDropChanceFormula formula: ", (Object[])new Object[]{Config.trophyDropChanceFormula});
        }
    }

    public static Entity getEntityFromCache(Trophy trophy) {
        Entity entity = ENTITY_CACHE.get((Object)trophy);
        if (entity == null) {
            if (!ENTITY_CACHE.containsKey((Object)trophy)) {
                try {
                    entity = trophy.createEntity();
                }
                catch (Throwable t) {
                    Log.severe((Throwable)t, (String)"Failed to create dummy entity for trophy %s", (Object[])new Object[]{trophy});
                }
            }
            ENTITY_CACHE.put(trophy, entity);
        }
        return entity;
    }

    private static Entity setSlimeSize(Entity entity, int size) {
        try {
            ReflectionHelper.call((Object)entity, (String[])new String[]{"func_70799_a", "setSlimeSize"}, (Object[])new Object[]{ReflectionHelper.primitive((int)size), ReflectionHelper.primitive((boolean)false)});
        }
        catch (Exception e) {
            Log.warn((Throwable)e, (String)"Can't update slime size", (Object[])new Object[0]);
        }
        return entity;
    }

    private static final ResourceLocation mc(String id) {
        return new ResourceLocation("minecraft", id);
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        ItemStack dropStack;
        Trophy mobTrophy;
        ResourceLocation entityName;
        Double result;
        Entity entity = event.getEntity();
        if (event.isRecentlyHit() && TrophyHandler.canDrop(entity) && (result = (Double)this.dropChanceCalculator.evaluate(env -> {
            env.setGlobalSymbol("looting", (Object)event.getLootingLevel());
            env.setGlobalSymbol("chance", (Object)Config.trophyDropChance);
        }, () -> {
            double bias = this.fallbackDropChance.nextDouble() / 4.0;
            double selection = this.fallbackDropChance.nextDouble();
            return ((double)event.getLootingLevel() + bias) * Config.trophyDropChance - selection;
        })) > 0.0 && (entityName = EntityList.func_191306_a(entity.getClass())) != null && (mobTrophy = Trophy.TYPES_BY_ID.get(entityName)) != null && !(dropStack = mobTrophy.getItemStack()).func_190926_b()) {
            EntityItem drop = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, dropStack);
            drop.func_174869_p();
            event.getDrops().add(drop);
        }
    }

    private static boolean canDrop(Entity entity) {
        World world = entity.field_70170_p;
        return world != null && world.func_82736_K().func_82766_b("doMobLoot");
    }

    static /* synthetic */ ResourceLocation access$000(String x0) {
        return TrophyHandler.mc(x0);
    }

    public static enum Trophy {
        Wolf(TrophyHandler.access$000("wolf")),
        Chicken(TrophyHandler.access$000("chicken"), new ItemDropBehavior(10000, new ItemStack(Items.field_151110_aK), SoundEvents.field_187665_Y)),
        Cow(TrophyHandler.access$000("cow"), new ItemDropBehavior(20000, new ItemStack(Items.field_151116_aA))),
        Creeper(TrophyHandler.access$000("creeper"), new CreeperBehavior()),
        Skeleton(TrophyHandler.access$000("skeleton"), new SkeletonBehavior()),
        PigZombie(TrophyHandler.access$000("zombie_pigman"), new ItemDropBehavior(20000, new ItemStack(Items.field_151074_bl))),
        Bat(TrophyHandler.access$000("bat"), 1.0, -0.3),
        Zombie(TrophyHandler.access$000("zombie")),
        Witch(TrophyHandler.access$000("witch"), 0.35, new WitchBehavior()),
        Villager(TrophyHandler.access$000("villager")),
        Ozelot(TrophyHandler.access$000("ocelot")){

            @Override
            protected Entity createEntity() {
                Entity entity = super.createEntity();
                try {
                    ((EntityOcelot)entity).func_70903_f(true);
                }
                catch (ClassCastException e) {
                    Log.warn((String)"Invalid cat entity class: %s", (Object[])new Object[]{entity.getClass()});
                }
                return entity;
            }
        }
        ,
        Sheep(TrophyHandler.access$000("sheep")),
        Blaze(TrophyHandler.access$000("blaze"), new BlazeBehavior()),
        Silverfish(TrophyHandler.access$000("silverfish")),
        Spider(TrophyHandler.access$000("spider")),
        CaveSpider(TrophyHandler.access$000("cave_spider"), new CaveSpiderBehavior()),
        Slime(TrophyHandler.access$000("slime"), 0.6){

            @Override
            protected Entity createEntity() {
                return TrophyHandler.setSlimeSize(super.createEntity(), 1);
            }
        }
        ,
        Ghast(TrophyHandler.access$000("ghast"), 0.1, 0.3),
        Enderman(TrophyHandler.access$000("enderman"), 0.3, new EndermanBehavior()),
        LavaSlime(TrophyHandler.access$000("magma_cube"), 0.6){

            @Override
            protected Entity createEntity() {
                return TrophyHandler.setSlimeSize(super.createEntity(), 1);
            }
        }
        ,
        Squid(TrophyHandler.access$000("squid"), 0.3, 0.5, new SquidBehavior()),
        MushroomCow(TrophyHandler.access$000("mooshroom"), new MooshroomBehavior()),
        VillagerGolem(TrophyHandler.access$000("villager_golem"), 0.3),
        SnowMan(TrophyHandler.access$000("snowman"), new SnowmanBehavior()),
        Pig(TrophyHandler.access$000("pig"), new ItemDropBehavior(20000, new ItemStack(Items.field_151147_al))),
        Endermite(TrophyHandler.access$000("endermite")),
        Guardian(TrophyHandler.access$000("guardian"), new GuardianBehavior()),
        Rabbit(TrophyHandler.access$000("rabbit"), new ItemDropBehavior(20000, new ItemStack(Items.field_151172_bF))),
        PolarBear(TrophyHandler.access$000("polar_bear"), new ItemDropBehavior(20000, new ItemStack(Items.field_151115_aP))),
        Shulker(TrophyHandler.access$000("shulker"), new ShulkerBehavior()),
        EntityHorse(TrophyHandler.access$000("horse"), 0.35, new ItemDropBehavior(20000, new ItemStack(Items.field_151015_O))){

            @Override
            protected boolean canInstantiate() {
                return HorseNullFix.Base.isWorking() && HorseNullFix.Horse.isWorking();
            }
        }
        ,
        SkeletonHorse(TrophyHandler.access$000("skeleton_horse"), 0.35, new ItemDropBehavior(20000, new ItemStack(Items.field_151103_aS))){

            @Override
            protected boolean canInstantiate() {
                return HorseNullFix.Base.isWorking();
            }
        }
        ,
        ZombieHorse(TrophyHandler.access$000("zombie_horse"), 0.35, new ItemDropBehavior(20000, new ItemStack(Items.field_151078_bh))){

            @Override
            protected boolean canInstantiate() {
                return HorseNullFix.Base.isWorking();
            }
        }
        ,
        Donkey(TrophyHandler.access$000("donkey"), 0.35, new ItemDropBehavior(20000, new ItemStack(Items.field_151015_O))){

            @Override
            protected boolean canInstantiate() {
                return HorseNullFix.Base.isWorking();
            }
        }
        ,
        Mule(TrophyHandler.access$000("mule"), 0.35, new ItemDropBehavior(20000, new ItemStack(Items.field_151015_O))){

            @Override
            protected boolean canInstantiate() {
                return HorseNullFix.Base.isWorking();
            }
        }
        ,
        Llama(TrophyHandler.access$000("llama"), 0.35, new LlamaBehavior()){

            @Override
            protected boolean canInstantiate() {
                return HorseNullFix.Base.isWorking() || HorseNullFix.Llama.isWorking();
            }
        }
        ,
        ElderGuardian(TrophyHandler.access$000("elder_guardian"), 0.2, 0.3, new GuardianBehavior()),
        WitherSkeleton(TrophyHandler.access$000("wither_skeleton"), new ItemDropBehavior(50000, new ItemStack(Items.field_151144_bL, 1, 1))),
        Stray(TrophyHandler.access$000("stray"), new SkeletonBehavior()),
        Husk(TrophyHandler.access$000("husk"), new ItemDropBehavior(20000, new ItemStack(Items.field_151008_G))),
        ZombieVillager(TrophyHandler.access$000("zombie_villager")),
        EvocationIllager(TrophyHandler.access$000("evocation_illager"), new EvocationBehavior()),
        Vex(TrophyHandler.access$000("vex")),
        VindicationIllager(TrophyHandler.access$000("vindication_illager"), new ItemDropBehavior(20000, new ItemStack(Items.field_151036_c)));

        private double scale = 0.4;
        private double verticalOffset = 0.0;
        private ITrophyBehavior behavior;
        public final ResourceLocation id;
        private boolean instantiationFailed;
        public static final Map<String, Trophy> TYPES_BY_NAME;
        public static final Map<ResourceLocation, Trophy> TYPES_BY_ID;
        public static final Trophy[] VALUES;

        private Trophy(ResourceLocation id) {
            this.id = id;
        }

        private Trophy(ResourceLocation id, ITrophyBehavior behavior) {
            this(id);
            this.behavior = behavior;
        }

        private Trophy(ResourceLocation id, double scale) {
            this(id);
            this.scale = scale;
        }

        private Trophy(ResourceLocation id, double scale, ITrophyBehavior behavior) {
            this(id);
            this.scale = scale;
            this.behavior = behavior;
        }

        private Trophy(ResourceLocation id, double scale, double verticalOffset) {
            this(id, scale);
            this.verticalOffset = verticalOffset;
        }

        private Trophy(ResourceLocation id, double scale, double verticalOffset, ITrophyBehavior behavior) {
            this(id, scale, verticalOffset);
            this.behavior = behavior;
        }

        public double getVerticalOffset() {
            return this.verticalOffset;
        }

        public double getScale() {
            return this.scale;
        }

        public Entity getEntity() {
            return TrophyHandler.getEntityFromCache(this);
        }

        public ItemStack getItemStack() {
            if (OpenBlocks.Blocks.trophy == null) {
                return ItemStack.field_190927_a;
            }
            return ItemTrophyBlock.putMetadata(new ItemStack(OpenBlocks.Blocks.trophy), this);
        }

        protected boolean canInstantiate() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void playSound(World world, BlockPos pos) {
            if (world == null) {
                return;
            }
            Entity e = this.getEntity();
            if (e instanceof EntityLiving) {
                e.field_70165_t = pos.func_177958_n();
                e.field_70163_u = pos.func_177956_o();
                e.field_70161_v = pos.func_177952_p();
                Entity entity = e;
                synchronized (entity) {
                    e.field_70170_p = world;
                    ((EntityLiving)e).func_70642_aH();
                    e.field_70170_p = null;
                }
            }
        }

        public int executeActivateBehavior(TileEntityTrophy tile, EntityPlayer player) {
            if (this.behavior != null) {
                return this.behavior.executeActivateBehavior(tile, player);
            }
            return 0;
        }

        public void executeTickBehavior(TileEntityTrophy tile) {
            if (this.behavior != null) {
                this.behavior.executeTickBehavior(tile);
            }
        }

        protected Entity createEntity() {
            if (!this.instantiationFailed && this.canInstantiate()) {
                try {
                    return EntityList.func_188429_b((ResourceLocation)this.id, null);
                }
                catch (Throwable t) {
                    Log.warn((Throwable)t, (String)"Failed to create instance of %s", (Object[])new Object[]{this.name()});
                    this.instantiationFailed = true;
                }
            }
            return null;
        }

        public String translationKey() {
            return "entity." + EntityList.func_191302_a((ResourceLocation)this.id) + ".name";
        }

        static {
            ImmutableMap.Builder byId = ImmutableMap.builder();
            ImmutableMap.Builder byName = ImmutableMap.builder();
            for (Trophy t : Trophy.values()) {
                byId.put((Object)t.id, (Object)t);
                byName.put((Object)t.name(), (Object)t);
            }
            TYPES_BY_ID = byId.build();
            TYPES_BY_NAME = byName.build();
            VALUES = Trophy.values();
        }
    }
}

