/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.objectmapping.serialize;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;

public class TypeSerializerCollection {
    private final TypeSerializerCollection parent;
    private final SerializerList serializers = new SerializerList();
    private final Map<TypeToken<?>, TypeSerializer<?>> typeMatches = new ConcurrentHashMap();

    TypeSerializerCollection(TypeSerializerCollection parent) {
        this.parent = parent;
    }

    public <T> TypeSerializer<T> get(TypeToken<T> type) {
        Preconditions.checkNotNull(type, (Object)"type");
        type = type.wrap();
        TypeSerializer<Object> serial = this.typeMatches.computeIfAbsent(type, this.serializers);
        if (serial == null && this.parent != null) {
            serial = this.parent.get(type);
        }
        return serial;
    }

    public <T> TypeSerializerCollection registerType(TypeToken<T> type, TypeSerializer<? super T> serializer) {
        Preconditions.checkNotNull(type, (Object)"type");
        Preconditions.checkNotNull(serializer, (Object)"serializer");
        this.serializers.add(new RegisteredSerializer(type, serializer));
        return this;
    }

    public <T> TypeSerializerCollection registerPredicate(Predicate<TypeToken<T>> test, TypeSerializer<? super T> serializer) {
        Preconditions.checkNotNull(test, (Object)"test");
        Preconditions.checkNotNull(serializer, (Object)"serializer");
        this.serializers.add(new RegisteredSerializer(test, serializer));
        return this;
    }

    public TypeSerializerCollection newChild() {
        return new TypeSerializerCollection(this);
    }

    private static final class SuperTypePredicate
    implements Predicate<TypeToken<?>> {
        private static final Method SUPERTYPE_TEST;
        private final TypeToken<?> type;

        private SuperTypePredicate(TypeToken<?> type) {
            this.type = type;
        }

        @Override
        public boolean test(TypeToken<?> t) {
            try {
                return (Boolean)SUPERTYPE_TEST.invoke(this.type, t);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        static {
            Method supertypeTest;
            try {
                supertypeTest = TypeToken.class.getMethod("isSupertypeOf", TypeToken.class);
            }
            catch (NoSuchMethodException e) {
                try {
                    supertypeTest = TypeToken.class.getMethod("isAssignableFrom", TypeToken.class);
                }
                catch (NoSuchMethodException ignored) {
                    supertypeTest = null;
                }
            }
            SUPERTYPE_TEST = Objects.requireNonNull(supertypeTest);
        }
    }

    private final class SerializerList
    extends CopyOnWriteArrayList<RegisteredSerializer>
    implements Function<TypeToken<?>, TypeSerializer<?>> {
        private SerializerList() {
        }

        @Override
        public TypeSerializer<?> apply(TypeToken<?> type) {
            for (RegisteredSerializer ent : this) {
                if (!ent.predicate.test(type)) continue;
                return ent.serializer;
            }
            return null;
        }
    }

    private static final class RegisteredSerializer {
        private final Predicate<TypeToken<?>> predicate;
        private final TypeSerializer<?> serializer;

        private RegisteredSerializer(Predicate<TypeToken<?>> predicate, TypeSerializer<?> serializer) {
            this.predicate = predicate;
            this.serializer = serializer;
        }

        private RegisteredSerializer(TypeToken<?> type, TypeSerializer<?> serializer) {
            this(new SuperTypePredicate(type), serializer);
        }
    }
}

