/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tile;

import ic2.core.IC2;
import ic2.core.block.base.tile.TileEntityGeneratorBase;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.util.math.Box2D;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class TileEntityWaveGenerator
extends TileEntityGeneratorBase {
    public float waveStrenght = 0.0f;
    public float targetStrengh = 0.0f;
    double modifer = (double)IC2.config.getInt("energyGeneratorWave") / 100.0;

    public TileEntityWaveGenerator() {
        super(0);
        this.maxStorage = 8000;
        this.production = 100;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return null;
    }

    @Override
    public ResourceLocation getTexture() {
        return null;
    }

    @Override
    public Box2D getEnergyBox() {
        return null;
    }

    @Override
    public boolean gainEnergy() {
        if (this.field_145850_b.func_82737_E() % 256L == 0L) {
            this.updateProduction();
        }
        if (this.waveStrenght != this.targetStrengh) {
            if (this.waveStrenght > this.targetStrengh) {
                this.waveStrenght = Math.max(this.waveStrenght - 0.01f, this.targetStrengh);
            } else if (this.waveStrenght < this.targetStrengh) {
                this.waveStrenght = Math.min(this.waveStrenght + 0.01f, this.targetStrengh);
            }
        }
        if (this.storage < this.maxStorage) {
            this.storage = Math.min(this.maxStorage, this.storage + (int)(30.0 * (double)this.waveStrenght * this.modifer));
        }
        return this.waveStrenght > 0.0f;
    }

    public void updateProduction() {
        IBlockState state;
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos(this.field_174879_c);
        currentPos.func_189536_c(this.getFacing());
        double distance = 0.0;
        for (int i = 50; i > 0 && this.field_145850_b.func_175667_e((BlockPos)currentPos) && (state = this.field_145850_b.func_180495_p((BlockPos)currentPos)).func_177230_c() == Blocks.field_150355_j; --i) {
            distance += 1.0;
            currentPos.func_189536_c(this.getFacing());
        }
        if (this.field_145850_b.func_72896_J()) {
            distance *= 1.2;
        }
        if (this.field_145850_b.func_72911_I()) {
            distance *= 4.0;
        }
        if (random.nextInt(3) != 0) {
            distance *= 0.1 + random.nextDouble();
        }
        if (distance < 0.0) {
            distance = 0.0;
        }
        this.targetStrengh = (float)(distance / 50.0);
    }

    @Override
    public boolean gainFuel() {
        return false;
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return false;
    }

    @Override
    public int getOutput() {
        return (int)((double)(this.waveStrenght * 30.0f) * this.modifer);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74776_a("Wave", this.waveStrenght);
        nbt.func_74776_a("Target", this.targetStrengh);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.waveStrenght = nbt.func_74760_g("Wave");
        this.targetStrengh = nbt.func_74760_g("Target");
    }
}

