/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low;

import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.INullableRecipeInput;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.classic.tile.IRecipeMachine;
import ic2.api.classic.tile.MachineType;
import ic2.api.classic.tile.machine.IFuelMachine;
import ic2.api.classic.tile.machine.IProgressMachine;
import ic2.api.info.Info;
import ic2.api.recipe.IRecipeInput;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorFuelMachine;
import ic2.core.block.base.util.comparator.comparators.ComparatorProgress;
import ic2.core.block.base.util.info.FuelMachineInfo;
import ic2.core.block.base.util.info.ProgressInfo;
import ic2.core.block.machine.low.container.ContainerStoneMacerator;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.gui.custom.MachineGui;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class TileEntityStoneMacerator
extends TileEntityMachine
implements ITickable,
IFuelMachine,
IRecipeMachine,
IProgressMachine,
IHasGui {
    @NetworkField(index=3)
    public int fuel = 0;
    @NetworkField(index=4)
    public int maxFuel = 0;
    @NetworkField(index=5)
    public int progress = 0;
    @NetworkField(index=6)
    public int maxProgress = 400;
    public int fuelConsumtion = 1;
    IMachineRecipeList.RecipeEntry lastRecipe;
    public List<ItemStack> results = new ArrayList<ItemStack>();

    public TileEntityStoneMacerator() {
        super(3);
        this.addGuiFields("fuel", "maxFuel", "progress", "maxProgress");
        this.addInfos(new FuelMachineInfo(this), new ProgressInfo(this));
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, 0);
        handler.registerDefaultSlotAccess(AccessRule.Import, 1);
        handler.registerDefaultSlotAccess(AccessRule.Export, 2);
        handler.registerDefaultSlotsForSide(RotationList.UP.invert(), 0, 2);
        handler.registerDefaultSlotsForSide(RotationList.DOWN.invert(), 1);
        handler.registerInputFilter(CommonFilters.IronFurnaceFuelWithLava, 0);
        handler.registerOutputFilter(CommonFilters.NotIronFurnaceFuelWithLava, 0);
        handler.registerInputFilter(CommonFilters.Macerator, 1);
        handler.registerSlotType(SlotType.Fuel, 0);
        handler.registerSlotType(SlotType.Input, 1);
        handler.registerSlotType(SlotType.Output, 2);
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorProgress(this));
        manager.addComparatorMode(new ComparatorFuelMachine(this));
    }

    public void func_73660_a() {
        boolean hasRoom = this.addToInventory();
        IMachineRecipeList.RecipeEntry entry = this.getRecipe();
        if (this.fuel <= 0 && entry != null && this.hasNewFuel()) {
            int newValue = Info.itemInfo.getFuelValue((ItemStack)this.inventory.get(0), true) / 2;
            this.fuel += newValue;
            this.maxFuel = newValue;
            this.getNetwork().updateTileGuiField(this, "maxFuel");
            this.getNetwork().updateTileGuiField(this, "fuel");
            if (this.fuel > 0) {
                if (((ItemStack)this.inventory.get(0)).func_77973_b().hasContainerItem((ItemStack)this.inventory.get(0))) {
                    this.inventory.set(0, (Object)((ItemStack)this.inventory.get(0)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(0)));
                } else {
                    ((ItemStack)this.inventory.get(0)).func_190918_g(1);
                }
            }
        }
        if (this.isBurning()) {
            if (hasRoom) {
                if (entry != null) {
                    ++this.progress;
                    this.fuel -= this.fuelConsumtion;
                    if (this.fuel < 0) {
                        this.fuel = 0;
                    }
                    if (this.progress >= this.maxProgress) {
                        this.progress = 0;
                        this.operate(entry);
                    }
                    this.getNetwork().updateTileGuiField(this, "progress");
                } else {
                    --this.fuel;
                    if (this.progress > 0) {
                        this.progress = 0;
                        this.getNetwork().updateTileGuiField(this, "progress");
                    }
                }
            } else {
                --this.fuel;
            }
            this.getNetwork().updateTileGuiField(this, "fuel");
        } else if (entry == null && this.progress > 0) {
            this.progress = 0;
            this.getNetwork().updateTileGuiField(this, "progress");
        }
        if (this.fuel <= 0) {
            this.fuel = 0;
        }
        if (this.getActive() != this.isBurning()) {
            this.setActive(this.isBurning());
        }
        this.updateComparators();
    }

    public boolean isBurning() {
        return this.fuel > 0;
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public float getMaxProgress() {
        return this.maxProgress;
    }

    @Override
    public float getFuel() {
        return this.fuel;
    }

    @Override
    public float getMaxFuel() {
        return this.maxFuel;
    }

    @Override
    public IMachineRecipeList getRecipeList() {
        return ClassicRecipes.macerator;
    }

    @Override
    public MachineType getType() {
        return MachineType.macerator;
    }

    public void operate(IMachineRecipeList.RecipeEntry entry) {
        IRecipeInput input = entry.getInput();
        MachineOutput output = entry.getOutput().copy();
        this.operateOnce(input, output, this.results);
        if (this.results.size() > 0) {
            this.addToInventory();
        }
    }

    public void operateOnce(IRecipeInput input, MachineOutput output, List<ItemStack> list) {
        list.addAll(output.getRecipeOutput(this.func_145831_w().field_73012_v, this.getTileData()));
        if (input instanceof INullableRecipeInput && ((ItemStack)this.inventory.get(1)).func_190926_b()) {
            return;
        }
        if (((ItemStack)this.inventory.get(1)).func_77973_b().hasContainerItem((ItemStack)this.inventory.get(1))) {
            this.inventory.set(1, (Object)((ItemStack)this.inventory.get(1)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(1)));
        } else {
            ((ItemStack)this.inventory.get(1)).func_190918_g(input.getAmount());
        }
    }

    public boolean hasNewFuel() {
        return TileEntityFurnace.func_145954_b((ItemStack)((ItemStack)this.inventory.get(0)));
    }

    public IMachineRecipeList.RecipeEntry getRecipe() {
        if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
            return null;
        }
        if (this.lastRecipe != null) {
            IRecipeInput recipe = this.lastRecipe.getInput();
            if (recipe instanceof INullableRecipeInput) {
                if (!recipe.matches((ItemStack)this.inventory.get(1)) || recipe.getAmount() > ((ItemStack)this.inventory.get(1)).func_190916_E()) {
                    this.lastRecipe = null;
                }
            } else if (((ItemStack)this.inventory.get(1)).func_190926_b() || !recipe.matches((ItemStack)this.inventory.get(1)) || recipe.getAmount() > ((ItemStack)this.inventory.get(1)).func_190916_E()) {
                this.lastRecipe = null;
            }
        }
        if (this.lastRecipe == null) {
            IMachineRecipeList.RecipeEntry out = ClassicRecipes.macerator.getRecipeInAndOutput(((ItemStack)this.inventory.get(1)).func_77946_l(), false);
            if (out == null) {
                return null;
            }
            this.lastRecipe = out;
            this.handleModifiers(out);
        }
        if (this.lastRecipe == null) {
            return null;
        }
        if (((ItemStack)this.inventory.get(2)).func_190926_b()) {
            return this.lastRecipe;
        }
        if (((ItemStack)this.inventory.get(2)).func_190916_E() >= ((ItemStack)this.inventory.get(2)).func_77976_d()) {
            return null;
        }
        for (ItemStack output : this.lastRecipe.getOutput().getAllOutputs()) {
            if (!StackUtil.isStackEqual((ItemStack)this.inventory.get(2), output, false, true)) continue;
            return this.lastRecipe;
        }
        return null;
    }

    public void handleModifiers(IMachineRecipeList.RecipeEntry entry) {
        if (entry == null || entry.getOutput().getMetadata() == null) {
            if (1 != this.fuelConsumtion) {
                this.fuelConsumtion = 1;
                this.getNetwork().updateTileGuiField(this, "fuelConsumtion");
            }
            if (this.maxProgress != 400) {
                this.maxProgress = 400;
                this.getNetwork().updateTileGuiField(this, "maxProgress");
            }
            return;
        }
        NBTTagCompound nbt = entry.getOutput().getMetadata();
        double energyMod = nbt.func_74764_b("fuelConsumtionModifier") ? nbt.func_74769_h("fuelConsumtionModifier") : 1.0;
        int newEnergy = TileEntityStoneMacerator.applyModifier(1, nbt.func_74762_e("fuelConsumtion"), energyMod);
        if (newEnergy != this.fuelConsumtion) {
            this.fuelConsumtion = newEnergy;
            if (this.fuelConsumtion < 1) {
                this.fuelConsumtion = 1;
            }
            this.getNetwork().updateTileGuiField(this, "fuelConsumtion");
        }
        double progMod = nbt.func_74764_b("RecipeTimeModifier") ? nbt.func_74769_h("RecipeTimeModifier") : 1.0;
        int newProgress = TileEntityStoneMacerator.applyModifier(400, nbt.func_74762_e("RecipeTime"), progMod);
        if (newProgress != this.maxProgress) {
            this.maxProgress = newProgress;
            if (this.maxProgress < 1) {
                this.maxProgress = 1;
            }
            this.getNetwork().updateTileGuiField(this, "maxProgress");
        }
    }

    static int applyModifier(int base, int extra, double multiplier) {
        long ret = Math.round((double)(base + extra) * multiplier);
        return ret > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)ret;
    }

    public boolean addToInventory() {
        if (this.results.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.results.size(); ++i) {
            ItemStack item = this.results.get(i);
            if (item.func_190926_b()) {
                this.results.remove(i--);
                continue;
            }
            if (((ItemStack)this.inventory.get(2)).func_190926_b()) {
                this.inventory.set(2, (Object)item.func_77946_l());
                this.results.remove(i--);
                continue;
            }
            if (!StackUtil.isStackEqual((ItemStack)this.inventory.get(2), item, false, true)) continue;
            int left = ((ItemStack)this.inventory.get(2)).func_77976_d() - ((ItemStack)this.inventory.get(2)).func_190916_E();
            if (left <= 0) break;
            if (left >= item.func_190916_E()) {
                ((ItemStack)this.inventory.get(2)).func_190917_f(item.func_190916_E());
                this.results.remove(i--);
                continue;
            }
            int itemLeft = item.func_190916_E() - left;
            item.func_190920_e(itemLeft);
            ((ItemStack)this.inventory.get(2)).func_190920_e(((ItemStack)this.inventory.get(2)).func_77976_d());
            break;
        }
        return this.results.size() <= 0;
    }

    @Override
    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return false;
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.fuel = nbt.func_74762_e("Fuel");
        this.maxFuel = nbt.func_74762_e("MaxFuel");
        this.progress = nbt.func_74762_e("Progress");
        this.results.clear();
        NBTTagList list = nbt.func_150295_c("Results", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            this.results.add(new ItemStack(data));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Fuel", this.fuel);
        nbt.func_74768_a("MaxFuel", this.maxFuel);
        nbt.func_74768_a("Progress", this.progress);
        NBTTagList list = new NBTTagList();
        for (ItemStack item : this.results) {
            NBTTagCompound data = new NBTTagCompound();
            item.func_77955_b(data);
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("Results", (NBTBase)list);
        return nbt;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerStoneMacerator(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return MachineGui.MaceratorGui.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.stoneMacerator;
    }

    public int getFuelLevel() {
        if (this.fuel <= 0) {
            return 0;
        }
        if (this.maxFuel <= 0) {
            this.maxFuel = this.fuel;
        }
        return (int)((double)this.fuel / (double)this.maxFuel * 14.0);
    }

    public int getProgressLevel() {
        if (this.progress <= 0) {
            return 0;
        }
        return (int)((double)((float)this.progress / (float)this.maxProgress) * 24.0);
    }
}

