/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.recipes.managers;

import ic2.api.classic.recipe.machine.ICannerRegistry;
import ic2.api.classic.recipe.machine.IFoodCanEffect;
import ic2.api.item.ICustomDamageItem;
import ic2.api.recipe.IRecipeInput;
import ic2.core.util.helpers.FilteredList;
import ic2.core.util.helpers.ItemWithMeta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;

public class CanningMachineRegistry
implements ICannerRegistry {
    Map<Integer, IFoodCanEffect> foodEffects = new HashMap<Integer, IFoodCanEffect>();
    Map<Integer, List<ItemWithMeta>> IdToItems = new HashMap<Integer, List<ItemWithMeta>>();
    Map<ItemWithMeta, Integer> itemsToIDs = new HashMap<ItemWithMeta, Integer>();
    Map<ItemWithMeta, Integer> fuelBonus = new HashMap<ItemWithMeta, Integer>();
    Map<ItemWithMeta, Float> fuelMultiplyer = new HashMap<ItemWithMeta, Float>();
    Map<ItemWithMeta, ItemStack> fuelFinder = new HashMap<ItemWithMeta, ItemStack>();
    Map<ICustomDamageItem, List<Tuple<Integer, Tuple<IRecipeInput, Integer>>>> repairMap = new LinkedHashMap<ICustomDamageItem, List<Tuple<Integer, Tuple<IRecipeInput, Integer>>>>();
    Map<ItemWithMeta, List<Tuple<IRecipeInput, ItemStack>>> canning = new LinkedHashMap<ItemWithMeta, List<Tuple<IRecipeInput, ItemStack>>>();
    Map<ItemStack, List<Tuple<IRecipeInput, ItemStack>>> canningVisible = new LinkedHashMap<ItemStack, List<Tuple<IRecipeInput, ItemStack>>>();

    @Override
    public void addRepairRecipe(ICustomDamageItem toRepair, IRecipeInput repairMaterial, int repairEffect) {
        this.addRepairRecipe(toRepair, Short.MAX_VALUE, repairMaterial, repairEffect);
    }

    @Override
    public void addRepairRecipe(ICustomDamageItem toRepair, int itemMeta, IRecipeInput repairMaterial, int repairEffect) {
        if (toRepair == null || repairMaterial == null) {
            return;
        }
        List<Tuple<Integer, Tuple<IRecipeInput, Integer>>> list = this.repairMap.get(toRepair);
        if (list == null) {
            list = new ArrayList<Tuple<Integer, Tuple<IRecipeInput, Integer>>>();
            this.repairMap.put(toRepair, list);
        }
        list.add((Tuple<Integer, Tuple<IRecipeInput, Integer>>)new Tuple((Object)itemMeta, (Object)new Tuple((Object)repairMaterial, (Object)repairEffect)));
    }

    @Override
    public Map<ICustomDamageItem, List<Tuple<Integer, Tuple<IRecipeInput, Integer>>>> getRepairMap() {
        return this.repairMap;
    }

    @Override
    public Tuple<IRecipeInput, Integer> getRepairResult(ItemStack input, ItemStack material, boolean ignoreStacksize) {
        if (material.func_190926_b() || !(input.func_77973_b() instanceof ICustomDamageItem) || input.func_190916_E() > 1) {
            return null;
        }
        ICustomDamageItem item = (ICustomDamageItem)input.func_77973_b();
        List<Tuple<Integer, Tuple<IRecipeInput, Integer>>> list = this.repairMap.get(item);
        if (list == null) {
            return null;
        }
        int inputmeta = input.func_77960_j();
        for (Tuple<Integer, Tuple<IRecipeInput, Integer>> entry : list) {
            IRecipeInput repair;
            int meta = (Integer)entry.func_76341_a();
            if (meta != inputmeta && meta != Short.MAX_VALUE || !(repair = (IRecipeInput)((Tuple)entry.func_76340_b()).func_76341_a()).matches(material) || !ignoreStacksize && repair.getAmount() > material.func_190916_E()) continue;
            return (Tuple)entry.func_76340_b();
        }
        return null;
    }

    @Override
    public void removeRepairItem(ICustomDamageItem item) {
        this.repairMap.remove(item);
    }

    @Override
    public void removeRepairItem(ICustomDamageItem item, int meta) {
        List<Tuple<Integer, Tuple<IRecipeInput, Integer>>> list = this.repairMap.get(item);
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Tuple<Integer, Tuple<IRecipeInput, Integer>> entry = list.get(i);
            if ((Integer)entry.func_76341_a() != meta) continue;
            list.remove(i--);
        }
        if (list.isEmpty()) {
            this.repairMap.remove(item);
        }
    }

    @Override
    public void registerCannerItem(ItemStack container, IRecipeInput toFill, ItemStack output) {
        if (container.func_190926_b() || toFill == null || output.func_190926_b()) {
            return;
        }
        List<Tuple<IRecipeInput, ItemStack>> list = this.canning.get(new ItemWithMeta(container));
        if (list == null) {
            list = new ArrayList<Tuple<IRecipeInput, ItemStack>>();
            this.canning.put(new ItemWithMeta(container), list);
        }
        list.add((Tuple<IRecipeInput, ItemStack>)new Tuple((Object)toFill, (Object)output));
        this.canningVisible.clear();
    }

    @Override
    public Map<ItemStack, List<Tuple<IRecipeInput, ItemStack>>> getCanningMap() {
        if (this.canningVisible.size() != this.canning.size()) {
            for (Map.Entry<ItemWithMeta, List<Tuple<IRecipeInput, ItemStack>>> entry : this.canning.entrySet()) {
                this.canningVisible.put(entry.getKey().toStack(), entry.getValue());
            }
        }
        return this.canningVisible;
    }

    @Override
    public boolean hasCanningContainer(ItemStack container) {
        if (container != null) {
            return this.canning.get(new ItemWithMeta(container)) != null;
        }
        return false;
    }

    @Override
    public Tuple<IRecipeInput, ItemStack> getCanningResult(ItemStack container, ItemStack toFill, boolean ignoreStacksize) {
        if (container.func_190926_b() || toFill.func_190926_b()) {
            return null;
        }
        List<Tuple<IRecipeInput, ItemStack>> list = this.canning.get(new ItemWithMeta(container));
        if (list == null) {
            return null;
        }
        for (Tuple<IRecipeInput, ItemStack> entry : list) {
            IRecipeInput input = (IRecipeInput)entry.func_76341_a();
            if (!input.matches(toFill) || !ignoreStacksize && input.getAmount() > toFill.func_190916_E()) continue;
            return entry;
        }
        return null;
    }

    @Override
    public void removeCanningRecipe(ItemStack container) {
        this.canning.remove(new ItemWithMeta(container));
        this.canningVisible.clear();
    }

    @Override
    public void removeCanningRecipe(ItemStack container, ItemStack toFill) {
        List<Tuple<IRecipeInput, ItemStack>> list = this.canning.get(new ItemWithMeta(container));
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Tuple<IRecipeInput, ItemStack> entry = list.get(i);
            if (!((IRecipeInput)entry.func_76341_a()).matches(toFill)) continue;
            list.remove(i--);
        }
        if (list.isEmpty()) {
            this.canning.remove(new ItemWithMeta(container));
        }
        this.canningVisible.clear();
    }

    @Override
    public int registerCanEffect(IFoodCanEffect effect) {
        for (int i = 1; i < 1024; ++i) {
            if (this.foodEffects.containsKey(i)) continue;
            this.foodEffects.put(i, effect);
            return i;
        }
        return 0;
    }

    @Override
    public IFoodCanEffect getEffectFromID(int id) {
        List<ItemWithMeta> items;
        IFoodCanEffect effect = this.foodEffects.get(id);
        if (effect == null && (items = this.IdToItems.remove(id)) != null) {
            for (ItemWithMeta stack : items) {
                this.itemsToIDs.remove(stack);
            }
        }
        return effect;
    }

    @Override
    public Map<Integer, IFoodCanEffect> getEffectMap() {
        return this.foodEffects;
    }

    @Override
    public void registerItemsForEffect(int effectID, ItemStack ... items) {
        for (ItemStack item : items) {
            ItemWithMeta stack = new ItemWithMeta(item);
            this.itemsToIDs.put(stack, effectID);
            List<ItemWithMeta> set = this.IdToItems.get(effectID);
            if (set == null) {
                set = new FilteredList<ItemWithMeta>();
                this.IdToItems.put(effectID, set);
            }
            set.add(stack);
        }
    }

    @Override
    public int getEffectForItem(ItemStack item) {
        if (item.func_190926_b()) {
            return 0;
        }
        Integer meta = this.itemsToIDs.get(new ItemWithMeta(item));
        if (meta == null) {
            return 0;
        }
        return meta;
    }

    @Override
    public void deleteEffectID(int effect, boolean deleteItems) {
        List<ItemWithMeta> items;
        this.foodEffects.remove(effect);
        if (deleteItems && (items = this.IdToItems.remove(effect)) != null) {
            for (ItemWithMeta stack : items) {
                this.itemsToIDs.remove(stack);
            }
        }
    }

    @Override
    public void registerFuelValue(ItemStack item, int fuel) {
        if (item.func_190926_b()) {
            return;
        }
        ItemWithMeta meta = new ItemWithMeta(item);
        this.fuelFinder.put(meta, item);
        this.fuelBonus.put(meta, fuel);
    }

    @Override
    public void registerFuelMultiplier(ItemStack item, float mutiplier) {
        ItemWithMeta meta = new ItemWithMeta(item);
        this.fuelFinder.put(meta, item);
        this.fuelMultiplyer.put(meta, Float.valueOf(mutiplier));
    }

    @Override
    public ICannerRegistry.FuelInfo getFuelInfo(ItemStack stack) {
        ItemWithMeta meta = new ItemWithMeta(stack);
        if (!this.fuelFinder.containsKey(meta)) {
            return null;
        }
        ItemStack itemToUse = this.fuelFinder.get(meta);
        int bonus = this.fuelBonus.containsKey(meta) ? this.fuelBonus.get(meta) : 0;
        float mutiplier = this.fuelMultiplyer.containsKey(meta) ? this.fuelMultiplyer.get(meta).floatValue() : 0.0f;
        return new ICannerRegistry.FuelInfo(bonus, mutiplier, itemToUse);
    }

    @Override
    public List<ICannerRegistry.FuelInfo> getAllFuelTypes() {
        ArrayList<ICannerRegistry.FuelInfo> info = new ArrayList<ICannerRegistry.FuelInfo>();
        for (Map.Entry<ItemWithMeta, ItemStack> entry : this.fuelFinder.entrySet()) {
            ItemWithMeta meta = entry.getKey();
            int bonus = this.fuelBonus.containsKey(meta) ? this.fuelBonus.get(meta) : 0;
            float mutiplier = this.fuelMultiplyer.containsKey(meta) ? this.fuelMultiplyer.get(meta).floatValue() : 0.0f;
            info.add(new ICannerRegistry.FuelInfo(bonus, mutiplier, entry.getValue()));
        }
        return info;
    }

    @Override
    public void deleteItemFuel(ItemStack fuel) {
        ItemWithMeta meta = new ItemWithMeta(fuel);
        this.fuelFinder.remove(meta);
        this.fuelBonus.remove(meta);
        this.fuelMultiplyer.remove(meta);
    }
}

