/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.buffers;

import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.NetworkField;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.DataInput;
import java.util.UUID;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class InputBuffer
implements IInputBuffer {
    ByteBuf buffer;

    public InputBuffer(ByteBuf buf) {
        this.buffer = buf;
    }

    @Override
    public boolean readBoolean() {
        return this.buffer.readBoolean();
    }

    @Override
    public byte readByte() {
        return this.buffer.readByte();
    }

    @Override
    public short readShort() {
        return this.buffer.readShort();
    }

    @Override
    public int readMedium() {
        return this.buffer.readMedium();
    }

    @Override
    public int readInt() {
        return this.buffer.readInt();
    }

    @Override
    public float readFloat() {
        return this.buffer.readFloat();
    }

    @Override
    public double readDouble() {
        return this.buffer.readDouble();
    }

    @Override
    public long readLong() {
        return this.buffer.readLong();
    }

    @Override
    public long readData(NetworkField.BitLevel length) {
        if (length.isSkip()) {
            return 0L;
        }
        switch (length) {
            case Bit0: {
                return 0L;
            }
            case Bit8: {
                return this.buffer.readByte();
            }
            case Bit16: {
                return this.buffer.readShort();
            }
            case Bit24: {
                return this.buffer.readMedium();
            }
            case Bit32: {
                return this.buffer.readInt();
            }
            case Bit40: {
                return ((long)this.buffer.readByte() & 0xFFL) << 32 | ((long)this.buffer.readByte() & 0xFFL) << 24 | ((long)this.buffer.readByte() & 0xFFL) << 16 | ((long)this.buffer.readByte() & 0xFFL) << 8 | (long)this.buffer.readByte() & 0xFFL;
            }
            case Bit48: {
                return ((long)this.buffer.readByte() & 0xFFL) << 40 | ((long)this.buffer.readByte() & 0xFFL) << 32 | ((long)this.buffer.readByte() & 0xFFL) << 24 | ((long)this.buffer.readByte() & 0xFFL) << 16 | ((long)this.buffer.readByte() & 0xFFL) << 8 | (long)this.buffer.readByte() & 0xFFL;
            }
            case Bit56: {
                return ((long)this.buffer.readByte() & 0xFFL) << 48 | ((long)this.buffer.readByte() & 0xFFL) << 40 | ((long)this.buffer.readByte() & 0xFFL) << 32 | ((long)this.buffer.readByte() & 0xFFL) << 24 | ((long)this.buffer.readByte() & 0xFFL) << 16 | ((long)this.buffer.readByte() & 0xFFL) << 8 | (long)this.buffer.readByte() & 0xFFL;
            }
            case Bit64: {
                return this.buffer.readLong();
            }
        }
        return 0L;
    }

    @Override
    public char readChar() {
        return this.buffer.readChar();
    }

    @Override
    public byte[] readBytes() {
        return this.readBytes(NetworkField.BitLevel.Bit32);
    }

    @Override
    public byte[] readBytes(NetworkField.BitLevel length) {
        byte[] data = new byte[(int)this.readData(length)];
        this.buffer.readBytes(data);
        return data;
    }

    @Override
    public String readString() {
        return this.readString(NetworkField.BitLevel.Bit32);
    }

    @Override
    public String readString(NetworkField.BitLevel length) {
        int limit = (int)this.readData(length);
        char[] array = new char[limit];
        for (int i = 0; i < limit; ++i) {
            array[i] = this.buffer.readChar();
        }
        return new String(array);
    }

    @Override
    public NBTTagCompound readNBTData() {
        try {
            return CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream(this.buffer), (NBTSizeTracker)new NBTSizeTracker(0x200000L));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public <T extends IForgeRegistryEntry> T readForgeRegistryEntry(RegistryNamespaced<ResourceLocation, T> registry) {
        String text = this.readString(NetworkField.BitLevel.Bit16);
        if (!text.equalsIgnoreCase("Empty")) {
            return (T)((IForgeRegistryEntry)registry.func_82594_a((Object)new ResourceLocation(text)));
        }
        return null;
    }

    @Override
    public UUID readUUID() {
        long most = this.buffer.readLong();
        long least = this.buffer.readLong();
        return new UUID(most, least);
    }

    public ByteBuf getSubBuffer() {
        return Unpooled.wrappedBuffer((byte[])this.readBytes());
    }
}

