/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.player;

import com.google.common.base.Objects;
import ic2.core.IC2;
import ic2.core.network.PacketManager;
import ic2.core.network.packets.server.TeamUpdatePacket;
import ic2.core.platform.saveables.saves.TeamSaver;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import joptsimple.internal.Strings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.scoreboard.Team;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TeamManager {
    public static TeamManager instance = new TeamManager();
    private Map<UUID, String> teamData = new HashMap<UUID, String>();
    private int ticker = 1;
    private boolean isDirty = false;

    public void onUnload() {
        this.teamData.clear();
    }

    public void onUpdate() {
        if (this.ticker++ % 250 == 0) {
            boolean changed = false;
            for (EntityPlayer player : IC2.platform.getServer().func_184103_al().func_181057_v()) {
                Team team = player.func_96124_cp();
                UUID id = player.func_110124_au();
                if (team == null) {
                    if (Strings.isNullOrEmpty((String)this.teamData.remove(id))) continue;
                    changed = true;
                    continue;
                }
                String oldID = team.func_96661_b();
                if (Objects.equal((Object)this.teamData.put(id, oldID), (Object)oldID)) continue;
                changed = true;
            }
            if (changed || this.isDirty) {
                PacketManager.instance.sendToAllPlayers(new TeamUpdatePacket(this.teamData));
                this.save();
            }
        }
    }

    public void markDirty(EntityPlayer player) {
        this.ticker = 100;
        this.isDirty = true;
        Team team = player.func_96124_cp();
        UUID id = player.func_110124_au();
        if (team == null) {
            this.teamData.remove(id);
        } else {
            this.teamData.put(id, team.func_96661_b());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientUpdate(Map<UUID, String> data) {
        this.teamData.clear();
        this.teamData.putAll(data);
    }

    public boolean isSameTeam(UUID owner, UUID requester) {
        String key = this.teamData.get(owner);
        String value = this.teamData.get(requester);
        if (Strings.isNullOrEmpty((String)key) || Strings.isNullOrEmpty((String)value)) {
            return false;
        }
        return Objects.equal((Object)key, (Object)value);
    }

    public void onServerStart(World world) {
        IC2.saveManager.getGlobalData(world, "IC2TeamData", TeamSaver.class).load(this.teamData);
    }

    public void save() {
        IC2.saveManager.getGlobalData(IC2.platform.getServer().func_130014_f_(), "IC2TeamData", TeamSaver.class).save(this.teamData);
    }
}

