/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.sigil;

import WayofTime.bloodmagic.core.data.Binding;
import WayofTime.bloodmagic.iface.ISigil;
import WayofTime.bloodmagic.item.sigil.ItemSigilBase;
import WayofTime.bloodmagic.teleport.TeleportQueue;
import WayofTime.bloodmagic.teleport.Teleports;
import WayofTime.bloodmagic.tile.TileTeleposer;
import WayofTime.bloodmagic.util.helper.NBTHelper;
import WayofTime.bloodmagic.util.helper.PlayerHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSigilTeleposition
extends ItemSigilBase {
    public ItemSigilTeleposition() {
        super("teleposition");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        TeleportLocation location = this.getTeleportLocation(stack);
        if (location != null) {
            tooltip.add("");
            tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.telepositionFocus.coords", location.pos.func_177958_n(), location.pos.func_177956_o(), location.pos.func_177952_p()));
            tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.telepositionFocus.dimension", location.dim));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        TileEntity tile;
        WorldServer teleportTo;
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ISigil.Holding) {
            stack = ((ISigil.Holding)stack.func_77973_b()).getHeldItem(stack, player);
        }
        if (PlayerHelper.isFakePlayer(player)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        TeleportLocation location = this.getTeleportLocation(stack);
        Binding binding = this.getBinding(stack);
        if (!world.field_72995_K && location != null && binding != null && (teleportTo = DimensionManager.getWorld((int)location.dim)) != null && (tile = teleportTo.func_175625_s(location.pos)) instanceof TileTeleposer) {
            BlockPos blockPos = location.pos.func_177984_a();
            UUID bindingOwnerID = binding.getOwnerId();
            if (world.field_73011_w.getDimension() == location.dim) {
                TeleportQueue.getInstance().addITeleport(new Teleports.TeleportSameDim(blockPos, (Entity)player, bindingOwnerID, true));
            } else {
                TeleportQueue.getInstance().addITeleport(new Teleports.TeleportToDim(blockPos, (Entity)player, bindingOwnerID, world, tile.func_145831_w().field_73011_w.getDimension(), true));
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ISigil.Holding) {
            stack = ((ISigil.Holding)stack.func_77973_b()).getHeldItem(stack, player);
        }
        if (PlayerHelper.isFakePlayer(player)) {
            return EnumActionResult.FAIL;
        }
        if (!world.field_72995_K && player.func_70093_af() && NBTHelper.checkNBT(stack) != null && world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileTeleposer) {
            TeleportLocation teleportLocation = new TeleportLocation(world.field_73011_w.getDimension(), pos);
            this.updateLocation(stack, teleportLocation);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @Nullable
    public TeleportLocation getTeleportLocation(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemSigilTeleposition)) {
            return null;
        }
        if (!stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound locationTag = stack.func_179543_a("tplocation");
        if (locationTag == null) {
            return null;
        }
        return TeleportLocation.fromTag(locationTag);
    }

    public void updateLocation(ItemStack stack, TeleportLocation location) {
        NBTTagCompound tagCompound;
        if (!stack.func_77942_o()) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        } else {
            tagCompound = stack.func_77978_p();
        }
        tagCompound.func_74782_a("tplocation", (NBTBase)location.serializeNBT());
    }

    public static class TeleportLocation
    implements INBTSerializable<NBTTagCompound> {
        private int dim;
        private BlockPos pos;

        private TeleportLocation() {
        }

        public TeleportLocation(int dim, BlockPos pos) {
            this.dim = dim;
            this.pos = pos;
        }

        public TeleportLocation(int dim, int x, int y, int z) {
            this(dim, new BlockPos(x, y, z));
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("dim", this.dim);
            tag.func_74772_a("pos", this.pos.func_177986_g());
            return tag;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.dim = nbt.func_74762_e("dim");
            this.pos = BlockPos.func_177969_a((long)nbt.func_74763_f("pos"));
        }

        public static TeleportLocation fromTag(NBTTagCompound tpTag) {
            TeleportLocation location = new TeleportLocation();
            location.deserializeNBT(tpTag);
            return location;
        }
    }
}

